/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.EventValidationComponent;
import com.sapportals.htmlb.JavascriptFragment;
import com.sapportals.htmlb.enum.EventTrigger;
import com.sapportals.htmlb.event.Event;
import com.sapportals.htmlb.event.EventManager;
import com.sapportals.htmlb.rendering.AtomHtmlbRenderer;
import com.sapportals.htmlb.rendering.IJavascriptRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.validation.Validator;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public abstract class EventValidationRenderer
extends AtomHtmlbRenderer
implements IJavascriptRenderer {
    private static HashSet emptyHashSet = new HashSet();

    public boolean getDefaultClientEventReturnValue(EventTrigger trigger, EventValidationComponent component) {
        return false;
    }

    public void renderEventValidationHandlers(Class defaultEventClass, HashSet validationTriggers, boolean noFormValidation, EventValidationComponent component, IPageContext pageContext) {
        EventTrigger trigger;
        StringBuffer buffer = new StringBuffer();
        String validationCall = "_htmlbisvalid";
        ArrayList validators = component.getAllValidators();
        Locale locale = pageContext.getLocale();
        HashMap clientEvents = component.getClientEventMap();
        HashMap serverEvents = component.getServerEventMap();
        Set clientEventTriggers = clientEvents.keySet();
        Set serverEventTriggers = serverEvents.keySet();
        HashSet triggers = new HashSet();
        triggers.addAll(serverEventTriggers);
        triggers.addAll(clientEventTriggers);
        if (!component.isEnabled() || validators == null) {
            validationTriggers = emptyHashSet;
        } else {
            Iterator validationIterator;
            triggers.addAll(validationTriggers);
            String errortext = component.getErrorText();
            StringBuffer result = new StringBuffer(1000);
            result.append("function ");
            validationCall = EventManager.getJavaScriptFunctionName(pageContext, component, EventTrigger.ON_VALIDATION.toString());
            result.append(validationCall);
            result.append("(){");
            boolean first = true;
            if (component.getErrorText() == null) {
                validationIterator = ((AbstractList)validators).iterator();
                while (validationIterator.hasNext()) {
                    Validator validator = (Validator)validationIterator.next();
                    if (first) {
                        result.append("if(");
                        first = false;
                    } else {
                        result.append("else if(");
                    }
                    result.append("!");
                    result.append(validator.getJavascript(locale));
                    result.append(")e=");
                    result.append(RenderUtil.encodeJavascriptString(validator.getErrorText(locale)));
                    result.append(";");
                }
                result.append("else e=null;this.setErrorText(e);return(e==null);");
            } else {
                validationIterator = ((AbstractList)validators).iterator();
                while (validationIterator.hasNext()) {
                    Validator v = (Validator)validationIterator.next();
                    if (first) {
                        result.append("if(");
                        first = false;
                    } else {
                        result.append("&&");
                    }
                    result.append(v.getJavascript(locale));
                }
                result.append(")e=null;else e=");
                result.append(RenderUtil.encodeJavascriptString(component.getErrorText()));
                result.append(";this.setErrorText(e);return(e==null);");
            }
            result.append("}\n");
            pageContext.getCurrentForm().addFormEndJavascript(new JavascriptFragment(component.getId(), result.toString(), component, pageContext.getParamIdForComponent(component)));
        }
        Iterator<Object> iter = clientEventTriggers.iterator();
        while (iter.hasNext()) {
            trigger = (EventTrigger)iter.next();
            String eventType = trigger.toString();
            StringBuffer result = new StringBuffer(1000);
            result.append("\nfunction ");
            String jsFuncName = EventManager.getJavaScriptFunctionName(pageContext, component, eventType);
            result.append(jsFuncName);
            result.append("(htmlbevent){");
            result.append("htmlb_formid = '");
            result.append(pageContext.getCurrentFormId());
            result.append("';");
            result.append((String)clientEvents.get(trigger));
            result.append(";}");
            pageContext.getCurrentForm().addFormEndJavascript(new JavascriptFragment(component.getId(), result.toString(), component, pageContext.getParamIdForComponent(component)));
        }
        iter = triggers.iterator();
        while (iter.hasNext()) {
            Event serverEvent;
            String eventCall;
            trigger = (EventTrigger)iter.next();
            boolean returnValue = this.getDefaultClientEventReturnValue(trigger, component);
            pageContext.write(" ");
            if (!trigger.toString().equals("")) {
                pageContext.write(trigger.toString());
                pageContext.write("=\"");
            }
            if ((eventCall = (serverEvent = (Event)serverEvents.get(trigger)) == null ? EventManager.renderEventCall(pageContext, defaultEventClass, trigger.toString(), component, null, (String)clientEvents.get(trigger), validationTriggers.contains(trigger), !noFormValidation, returnValue, null) : EventManager.renderEventCall(pageContext, serverEvent.getClass(), trigger.toString(), component, serverEvent.getAction(), (String)clientEvents.get(trigger), validationTriggers.contains(trigger), !noFormValidation, returnValue, serverEvent.getParams())).equals("")) {
                pageContext.write(validationCall);
                if (returnValue) {
                    pageContext.write("();return true;");
                } else {
                    pageContext.write("();return false;");
                }
            } else {
                pageContext.write(eventCall);
            }
            if (trigger.toString().equals("")) continue;
            pageContext.write("\"");
        }
    }

    public void renderJavascriptInterface(IPageContext renderContext, Component component, String generatedId) {
        RenderUtil.renderJavascriptInterface(renderContext, component, generatedId, null);
    }
}

