/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Tree;
import com.sapportals.htmlb.TreeNode;
import com.sapportals.htmlb.event.TreeNodeCloseEvent;
import com.sapportals.htmlb.event.TreeNodeExpandEvent;
import com.sapportals.htmlb.event.TreeNodeSelectEvent;
import com.sapportals.htmlb.hovermenu.HoverMenu;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.Section508Utils;
import java.util.Enumeration;

public class DefaultTreeRenderer
implements HtmlbRenderer {
    public void render(Component component, int selector, IPageContext renderContext) {
        if (component instanceof Tree) {
            Tree tree = (Tree)component;
            switch (selector) {
                case 0: {
                    this.renderTreeBegin(tree, renderContext);
                    break;
                }
                case 1: {
                    this.renderTreeEnd(tree, renderContext);
                }
            }
        }
    }

    public void render(Component component, IPageContext renderContext) {
        if (component instanceof Tree) {
            String componentID = renderContext.getParamIdForComponent(component);
            Tree tree = (Tree)component;
            tree.setCurrentNodeId(1);
            String nodeID = this.getNodeID(tree, componentID);
            this.renderTreeBegin(tree, renderContext);
            int startLevel = 1;
            if (tree.isRootNodeVisible()) {
                this.renderTreeNodeBegin(tree, tree.getRootNode(), nodeID, 1, renderContext);
                startLevel = 2;
            }
            this.renderTreeLevel(tree, tree.getRootNode(), nodeID, startLevel, renderContext);
            if (tree.isRootNodeVisible()) {
                this.renderRootNodeEnd(tree, renderContext);
            }
            this.renderTreeEnd(tree, renderContext);
        }
    }

    private void renderTreeBegin(Tree tree, IPageContext renderContext) {
        String componentID = renderContext.getParamIdForComponent(tree);
        renderContext.write("<input type=\"hidden\" name=\"" + componentID + "Eln" + "\" value=\"" + tree.getRootNode().getNodeStatus() + "\">");
        String nodes = tree.getEncodedTreeHierachy();
        int charsPerLine = 120;
        int i = 0;
        int len = nodes.length();
        String part = null;
        int counter = 0;
        i = 0;
        while (i < len) {
            part = nodes.substring(i, i + charsPerLine > len ? len : i + charsPerLine);
            renderContext.write("<input type=\"hidden\" name=\"" + componentID + "Nodes" + "_" + counter + "\" value=\"" + part + "\">");
            ++counter;
            i += charsPerLine;
        }
        String title = tree.getTitle();
        renderContext.write("<table cellpadding=\"0\" cellspacing=\"0\" class=\"sapTreWhl");
        renderContext.write("\" id=\"");
        renderContext.write(tree.getId());
        renderContext.write("\" treeId=\"");
        renderContext.write(tree.getId());
        String tooltip = tree.getTooltip();
        if (tooltip != null) {
            renderContext.write("\" title=\"");
            renderContext.writeEncoded(tooltip);
        }
        renderContext.write("\" style=\"width:100%;");
        if (tree.getHeight() != null) {
            renderContext.write("height:");
            renderContext.write(tree.getHeight());
        }
        renderContext.write("\"><tr><td valign=\"top\">");
        if (title != null && !title.equals("")) {
            renderContext.write("<div><span class=\"sapTreTit\">");
            renderContext.write(title);
            renderContext.write("</span></div>");
        }
    }

    private void renderTreeEnd(Tree tree, IPageContext renderContext) {
        renderContext.write("</td></tr></table>");
    }

    private void renderRootNodeEnd(Tree tree, IPageContext renderContext) {
    }

    private void renderTreeLevelBegin(int level, String nodeID, TreeNode parent, IPageContext renderContext) {
        renderContext.write("<div id=\"");
        renderContext.write(nodeID);
        renderContext.write(":children\" class=\"");
        switch (level) {
            case 1: {
                break;
            }
            case 2: {
                renderContext.write("sapTreNl2");
                break;
            }
            case 3: {
                renderContext.write("sapTreNl3");
                break;
            }
            default: {
                renderContext.write("sapTreNl4");
            }
        }
        if (!parent.isOpen() || !parent.hasChildren()) {
            renderContext.write("\" style=\"display:none;");
        }
        renderContext.write("\">");
    }

    private void renderTreeLevelEnd(int level, IPageContext renderContext) {
        renderContext.write("</div>");
    }

    private void renderTreeNodeBegin(Tree tree, TreeNode node, String nodeID, int level, IPageContext renderContext) {
        Object content;
        String tooltip508;
        int offset = tree.getOffsetForTreeNode();
        offset = offset > 0 ? (level - 1) * offset : (level - 1) * 20;
        renderContext.write("<div id=\"");
        renderContext.write(nodeID);
        renderContext.write("\" nodeKeyForHoverMenu=\"");
        renderContext.write(node.getID());
        renderContext.write("\" status=\"");
        renderContext.write(this.getStatus(node));
        if (offset != 0) {
            renderContext.write("\" style=\"margin-left:");
            renderContext.write(offset);
            renderContext.write(";");
        }
        renderContext.write("\" style=\"padding-left:");
        renderContext.write("16px");
        renderContext.write(";");
        renderContext.write("\" nowrap><span id=\"");
        renderContext.write(nodeID);
        renderContext.write(":exp\" class=\"");
        if (!node.hasChildren()) {
            renderContext.write("sapTreExpNc");
        } else if (node.isOpen()) {
            renderContext.write("sapTreExpOp");
        } else {
            renderContext.write("sapTreExpClo");
        }
        renderContext.write("\" style=\"margin-left:-");
        renderContext.write("16px");
        renderContext.write(";");
        String onNodeExpand = node.getOnNodeExpand();
        String onNodeClose = node.getOnNodeClose();
        if (node.hasChildren()) {
            if (onNodeExpand != null && !onNodeExpand.equals("") && !node.isOpen()) {
                renderContext.write("\" ondragenter=\"sapTreDragEnter(this)\" onkeypress=\" htmlbInvokeClick()\" onclick=\"");
                renderContext.write(TreeNodeExpandEvent.renderEventCall(renderContext, tree, node));
            } else if (onNodeClose != null && !onNodeClose.equals("") && node.isOpen()) {
                renderContext.write("\" ondragenter=\"sapTreDragEnter(this)\" onkeypress=\" htmlbInvokeClick()\" onclick=\"");
                renderContext.write(TreeNodeCloseEvent.renderEventCall(renderContext, tree, node));
            } else {
                renderContext.write("\" ondragenter=\"sapTreDragEnter(this)\" onkeypress=\"htmlbInvokeClick()\" onclick=\"sapTreExpClk(this)");
            }
        }
        if ((tooltip508 = Section508Utils.getTreeNodeTooltip(node, renderContext, level)) != null) {
            renderContext.write("\" title=\"");
            renderContext.writeEncoded(tooltip508);
        }
        if (node.hasChildren()) {
            renderContext.write("\" tabindex=\"0");
        }
        renderContext.write("\"></span><span nowrap class=\"sapTreNoDsbl");
        String onTreeClick = tree.getOnTreeClick();
        String onNodeClick = node.getOnNodeClick();
        HoverMenu hoverMenu = node.getHoverMenu();
        if (onNodeClick != null || onTreeClick != null) {
            renderContext.write("\" onclick=\"");
            renderContext.write(TreeNodeSelectEvent.renderEventCall(renderContext, tree, node));
            renderContext.write("\" style=\"cursor:Hand;");
            renderContext.write("\" onkeypress=\"htmlbInvokeClick()\" tabindex=\"0");
        } else if (hoverMenu != null) {
            if (hoverMenu.getMenuTrigger() == null) {
                renderContext.write("\" onMouseOver=\"");
            } else {
                renderContext.write("\" ");
                renderContext.write(hoverMenu.getMenuTrigger().toString());
                renderContext.write("=\"");
            }
            renderContext.write("htmlbShowFirstMenu('");
            renderContext.write(renderContext.getParamIdForComponent(hoverMenu));
            renderContext.write("', this);window.event.cancelBubble = true;");
            if (hoverMenu.requiresForm()) {
                renderContext.getCurrentForm().registerHoverMenu(hoverMenu);
            } else {
                renderContext.getDocument().registerHoverMenu(hoverMenu);
            }
        }
        String tooltip = node.getTooltip();
        if (tooltip != null || tooltip508 != null) {
            renderContext.write("\" title=\"");
            if (tooltip508 != null) {
                renderContext.writeEncoded(tooltip508);
                renderContext.write(" ");
            }
            renderContext.writeEncoded(tooltip);
        }
        if ((content = node.getContent()) instanceof String) {
            renderContext.write("\">");
            if (node.isEncode()) {
                renderContext.writeEncoded((String)content);
            } else {
                renderContext.write((String)content);
            }
        } else {
            Component c = (Component)content;
            renderContext.write("\">&nbsp;<div style=\"margin-top:-2.4ex;\">");
            c.render(renderContext);
            renderContext.write("</div>");
        }
        renderContext.write("</span></div>");
    }

    private void renderTreeNodeEnd(TreeNode node, int level, IPageContext renderContext) {
    }

    private void renderTreeLevel(Tree tree, TreeNode parent, String nodeID, int level, IPageContext renderContext) {
        this.renderTreeLevelBegin(level, nodeID, parent, renderContext);
        String componentID = renderContext.getParamIdForComponent(tree);
        Enumeration children = parent.getChildNodes();
        while (children.hasMoreElements()) {
            TreeNode child = (TreeNode)children.nextElement();
            String childNodeID = this.getNodeID(tree, componentID);
            this.renderTreeNodeBegin(tree, child, childNodeID, level, renderContext);
            this.renderTreeLevel(tree, child, childNodeID, level + 1, renderContext);
            this.renderTreeNodeEnd(child, level, renderContext);
        }
        this.renderTreeLevelEnd(level, renderContext);
    }

    private String getNodeID(Tree tree, String componentID) {
        int nodeId = tree.getCurrentNodeId();
        tree.setCurrentNodeId(nodeId + 1);
        String id = String.valueOf(nodeId);
        return componentID.concat("-").concat(id);
    }

    private String getStatus(TreeNode node) {
        if (node.isOpen()) {
            return "open";
        }
        return "closed";
    }
}

