/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.enum.CellHAlign;
import com.sapportals.htmlb.enum.CellVAlign;
import com.sapportals.htmlb.enum.DataType;
import com.sapportals.htmlb.enum.TableCellStyle;
import com.sapportals.htmlb.enum.TableColumnType;
import com.sapportals.htmlb.enum.TableNavigationMode;
import com.sapportals.htmlb.enum.TableSelectionMode;
import com.sapportals.htmlb.enum.TableViewDesign;
import com.sapportals.htmlb.event.TableCellClickEvent;
import com.sapportals.htmlb.event.TableHeaderClickEvent;
import com.sapportals.htmlb.event.TableNavigationEvent;
import com.sapportals.htmlb.event.TableRowSelectionEvent;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.table.IFooterRenderer;
import com.sapportals.htmlb.table.IHeaderCellRenderer;
import com.sapportals.htmlb.table.IHeaderRenderer;
import com.sapportals.htmlb.table.IRowRenderer;
import com.sapportals.htmlb.table.SpanInfo;
import com.sapportals.htmlb.table.TableColumn;
import com.sapportals.htmlb.table.TableView;
import com.sapportals.htmlb.util.Log;
import java.util.ResourceBundle;

public class DefaultTableViewRenderer
implements HtmlbRenderer {
    public void render(Component component, IPageContext rendererContext) {
        if (component instanceof TableView) {
            IHeaderRenderer headerRenderer;
            TableView tableView = (TableView)component;
            int columnCount = tableView.getColumnCount();
            int rowCount = tableView.getRowCount();
            int visibleRowCount = tableView.getVisibleRowCount();
            int visibleFirstRow = tableView.getVisibleFirstRow();
            boolean fillUpEmptyRows = tableView.isFillUpEmptyRows();
            this.renderBegin(tableView, rendererContext);
            this.renderHeadBegin(tableView, rendererContext);
            if (tableView.isHeaderVisible() && (headerRenderer = tableView.getHeaderRenderer()).willRenderHeader(tableView, rendererContext)) {
                this.renderHeadBeginTitle(tableView, rendererContext);
                headerRenderer.renderHeader(tableView, rendererContext);
                this.renderHeadEndTitle(tableView, rendererContext);
            }
            if (tableView.isCellHeaderVisible()) {
                this.renderBeginColumnHeaders(tableView, rendererContext);
                int i = 1;
                while (i <= columnCount) {
                    this.renderHeadCellBegin(tableView, rendererContext);
                    IHeaderCellRenderer myHeaderCellRenderer = tableView.getHeaderCellRenderer(i);
                    myHeaderCellRenderer.renderHeaderCell(i, tableView, rendererContext);
                    this.renderHeadCellEnd(tableView, rendererContext);
                    ++i;
                }
                this.renderEndColumnHeaders(tableView, rendererContext);
            }
            this.renderHeadEnd(tableView, rendererContext);
            this.renderContentBegin(tableView, rendererContext);
            int startRow = visibleFirstRow;
            int endRow = startRow + visibleRowCount - 1;
            if (endRow > rowCount) {
                endRow = rowCount;
            }
            if (rowCount == 0) {
                if (fillUpEmptyRows) {
                    startRow = 1;
                    endRow = visibleRowCount;
                    int i = startRow;
                    while (i <= endRow) {
                        this.renderContRowBegin(tableView, rendererContext);
                        IRowRenderer myRowRenderer = tableView.getRowRenderer(i);
                        myRowRenderer.renderRow(i, tableView, rendererContext);
                        this.renderContRowEnd(tableView, rendererContext);
                        ++i;
                    }
                } else {
                    String emptyTableText = tableView.getEmptyTableText();
                    if (emptyTableText != null && !emptyTableText.equals("")) {
                        this.renderEmptyTableText(tableView, rendererContext, emptyTableText);
                    }
                }
            } else {
                int i = startRow;
                while (i <= endRow) {
                    this.renderContRowBegin(tableView, rendererContext);
                    IRowRenderer myRowRenderer = tableView.getRowRenderer(i);
                    myRowRenderer.renderRow(i, tableView, rendererContext);
                    this.renderContRowEnd(tableView, rendererContext);
                    ++i;
                }
                if (fillUpEmptyRows) {
                    int oldStartRow = startRow;
                    startRow = endRow + 1;
                    endRow = oldStartRow + visibleRowCount;
                    int i2 = startRow;
                    while (i2 < endRow) {
                        this.renderContRowBegin(tableView, rendererContext);
                        IRowRenderer myRowRenderer = tableView.getRowRenderer(i2);
                        myRowRenderer.renderRow(i2, tableView, rendererContext);
                        this.renderContRowEnd(tableView, rendererContext);
                        ++i2;
                    }
                }
            }
            this.renderContentEnd(tableView, rendererContext);
            if (tableView.isFooterVisible()) {
                this.renderFooterBegin(tableView, rendererContext);
                IFooterRenderer myFooterRenderer = tableView.getFooterRenderer();
                myFooterRenderer.renderFooter(tableView, rendererContext);
                this.renderFooterEnd(tableView, rendererContext);
            }
            this.renderEnd(tableView, rendererContext);
        }
    }

    public void render(Component component, int selector, IPageContext renderContext) {
        TableView myTableView = (TableView)component;
        switch (selector) {
            case 1: {
                this.renderBegin(myTableView, renderContext);
                break;
            }
            case 8: {
                this.renderContCellBegin(myTableView, renderContext);
                break;
            }
            case 6: {
                this.renderContentBegin(myTableView, renderContext);
                break;
            }
            case 7: {
                this.renderContRowBegin(myTableView, renderContext);
                break;
            }
            case 12: {
                this.renderFooterBegin(myTableView, renderContext);
                break;
            }
            case 2: {
                this.renderHeadBegin(myTableView, renderContext);
                break;
            }
            case 17: {
                this.renderHeadBeginTitle(myTableView, renderContext);
                break;
            }
            case 18: {
                this.renderHeadEndTitle(myTableView, renderContext);
                break;
            }
            case 19: {
                this.renderBeginColumnHeaders(myTableView, renderContext);
                break;
            }
            case 20: {
                this.renderEndColumnHeaders(myTableView, renderContext);
                break;
            }
            case 3: {
                this.renderHeadCellBegin(myTableView, renderContext);
                break;
            }
            case 16: {
                this.renderEnd(myTableView, renderContext);
                break;
            }
            case 9: {
                this.renderContCellEnd(myTableView, renderContext);
                break;
            }
            case 11: {
                this.renderContentEnd(myTableView, renderContext);
                break;
            }
            case 10: {
                this.renderContRowEnd(myTableView, renderContext);
                break;
            }
            case 15: {
                this.renderFooterEnd(myTableView, renderContext);
                break;
            }
            case 5: {
                this.renderHeadEnd(myTableView, renderContext);
                break;
            }
            case 4: {
                this.renderHeadCellEnd(myTableView, renderContext);
                break;
            }
            case 13: {
                this.renderFooterNavigation(myTableView, renderContext);
                break;
            }
            case 14: {
                this.renderFooterPositionIndicator(myTableView, renderContext);
            }
        }
    }

    public boolean tableRequiresOnClickHandler(TableView tableView) {
        int columnCount = tableView.getColumnCount();
        int i = 1;
        while (i <= columnCount) {
            String onCellClick = tableView.getColumn(i).getOnCellClick();
            if (onCellClick != null && onCellClick.length() > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void renderBegin(TableView tableView, IPageContext rc) {
        rc.write("<table");
        if (tableView.getSummary() != null) {
            rc.write(" summary=\"" + tableView.getSummary() + "\"");
        }
        CellHAlign tableHAlign = tableView.getTableHAlignment();
        if (tableView.getTableHAlignment() != null) {
            rc.write(" align=\"");
            rc.write(tableHAlign.toString());
            rc.write("\"");
        }
        rc.write(" onclick=\"");
        if (this.tableRequiresOnClickHandler(tableView)) {
            rc.write(TableCellClickEvent.renderEventCall(rc, tableView));
        } else {
            rc.write("\"");
        }
        int columnCount = tableView.getColumnCount();
        int i = 1;
        while (i <= columnCount) {
            String onCellClick = tableView.getColumn(i).getOnCellClick();
            if (onCellClick != null && onCellClick.length() > 0) {
                rc.write(" colEvt");
                rc.write(i);
                rc.write("=\"");
                rc.write(rc.getCurrentForm().getIdForEvent(onCellClick));
                rc.write("\"");
            }
            ++i;
        }
        TableViewDesign design = tableView.getDesign();
        if (design.equals(TableViewDesign.ALTERNATING)) {
            rc.write(" class=\"sapTbvAlt\"");
        } else if (design.equals(TableViewDesign.TRANSPARENT)) {
            rc.write(" class=\"sapTbvTrans\"");
        } else {
            rc.write(" class=\"sapTbvStd\"");
        }
        rc.write(" height=\"\"");
        String width = tableView.getWidth();
        if (width != null) {
            rc.write(" width=\"");
            rc.write(width);
            rc.write("\"");
        }
        rc.write(" cellspacing=\"1\" cellpadding=\"0\">");
        String fullFormId = rc.getParamIdForComponent(tableView);
    }

    public void renderHeadBegin(TableView tableView, IPageContext rc) {
        rc.write("<thead>");
    }

    public void renderHeadBeginTitle(TableView tableView, IPageContext rc) {
        rc.write("<tr>");
        rc.write("<td colspan=\"");
        if (tableView.getSelectionMode().equals(TableSelectionMode.NONE)) {
            rc.write(tableView.getColumnCount());
        } else {
            rc.write(tableView.getColumnCount() + 1);
        }
        TableViewDesign design = tableView.getDesign();
        if (design.equals(TableViewDesign.ALTERNATING)) {
            rc.write("\" class=\"sapTbvTitAlt\" align=\"left\">");
        } else if (design.equals(TableViewDesign.TRANSPARENT)) {
            rc.write("\" class=\"sapTbvTitTrans\" align=\"left\">");
        } else {
            rc.write("\" class=\"sapTbvTitStd\" align=\"left\">");
        }
    }

    public void renderHeadEndTitle(TableView tableView, IPageContext rc) {
        rc.write("</td></tr>");
    }

    public void renderBeginColumnHeaders(TableView tableView, IPageContext rc) {
        TableViewDesign design = tableView.getDesign();
        rc.write("<tr>");
        if (!tableView.getSelectionMode().equals(TableSelectionMode.NONE) && (tableView.getRowCount() != 0 || tableView.isFillUpEmptyRows())) {
            if (design.equals(TableViewDesign.ALTERNATING)) {
                rc.write("<th class=\"sapTbvHdrAlt\">");
            } else if (design.equals(TableViewDesign.TRANSPARENT)) {
                rc.write("<th class=\"sapTbvHdrTrans\">");
            } else {
                rc.write("<th class=\"sapTbvHdrStd\">");
            }
            rc.write("&nbsp;</th>");
        }
        tableView.setCurrentColumnIndex(0);
    }

    public void renderEndColumnHeaders(TableView tableView, IPageContext rc) {
        rc.write("</tr>");
    }

    public void renderHeadEnd(TableView tableView, IPageContext rc) {
        rc.write("</thead>");
    }

    public void renderHeadCellBegin(TableView tableView, IPageContext rc) {
        String onHeaderClick;
        int currentColumnIndex = tableView.getCurrentColumnIndex() + 1;
        tableView.setCurrentColumnIndex(currentColumnIndex);
        TableColumn column = tableView.getColumn(currentColumnIndex);
        TableColumnType columnType = column.getType();
        DataType columnDataType = column.getDataType();
        TableViewDesign design = tableView.getDesign();
        if (design.equals(TableViewDesign.ALTERNATING)) {
            rc.write("<th class=\"sapTbvHdrAlt\"");
        } else if (design.equals(TableViewDesign.TRANSPARENT)) {
            rc.write("<th class=\"sapTbvHdrTrans\"");
        } else {
            rc.write("<th class=\"sapTbvHdrStd\"");
        }
        String tooltipForColumnHeader = column.getTooltipForColumnHeader();
        if (tooltipForColumnHeader != null && !tooltipForColumnHeader.equals("")) {
            rc.write(" title=\"");
            rc.write(tooltipForColumnHeader);
            rc.write("\"");
        }
        if (columnType != TableColumnType.USER) {
            if (columnDataType.equals(DataType.BCD) || columnDataType.equals(DataType.INTEGER)) {
                rc.write(" align=\"right\"");
            } else {
                CellHAlign columnHAlignment = tableView.getCellHAlignment(-1, currentColumnIndex);
                if (columnHAlignment != null) {
                    rc.write(" align=\"");
                    rc.write(columnHAlignment.toString());
                    rc.write("\"");
                }
            }
        }
        if ((onHeaderClick = tableView.getOnHeaderClick()) != null) {
            rc.write(" style=\"cursor:hand\" onClick=\"");
            rc.write(TableHeaderClickEvent.renderEventCall(rc, tableView, currentColumnIndex));
            rc.write("\"");
        }
        rc.write(">");
    }

    public void renderHeadCellEnd(TableView tableView, IPageContext rc) {
        rc.write("</th>");
    }

    public void renderContentBegin(TableView tableView, IPageContext rc) {
        tableView.setCurrentColumnIndex(0);
        tableView.setColspanForCurrentColumn(1);
        tableView.setCurrentRowIndex(0);
        int columnCount = tableView.getColumnCount();
        tableView.prepareSpanInfoBuffer();
        rc.write("<tbody>");
    }

    public void renderContRowBegin(TableView tableView, IPageContext rc) {
        int currentRow = tableView.getCurrentRowIndex() + 1;
        tableView.setCurrentRowIndex(currentRow);
        tableView.setCurrentColumnIndex(1);
        tableView.setColspanForCurrentColumn(0);
        int firstVisibleRow = tableView.getVisibleFirstRow();
        TableViewDesign design = tableView.getDesign();
        rc.write("<tr rr=\"");
        rc.write(currentRow + "\">");
        TableSelectionMode mySelectionMode = tableView.getSelectionMode();
        int rowCount = tableView.getRowCount();
        if (rowCount != 0 || tableView.isFillUpEmptyRows()) {
            int rowIndexInModel = currentRow + firstVisibleRow - 1;
            if (mySelectionMode.equals(TableSelectionMode.MULTISELECT)) {
                if (design.equals(TableViewDesign.ALTERNATING)) {
                    if ((firstVisibleRow + currentRow) % 2 == 0) {
                        rc.write("<td class=\"sapTbvCellAlt\"");
                    } else {
                        rc.write("<td class=\"sapTbvCellStd\"");
                    }
                } else if (design.equals(TableViewDesign.TRANSPARENT)) {
                    rc.write("<td class=\"sapTbvCellTrans\"");
                } else {
                    rc.write("<td class=\"sapTbvCellStd\"");
                }
                String id = rc.getParamIdForComponent(tableView);
                rc.write(" style=\"width:1\">");
                rc.write("<input type='checkbox' name='");
                rc.write(id);
                rc.write("-chk");
                rc.write(currentRow);
                rc.write("'");
                if (!tableView.isRowSelectable(rowIndexInModel) || rowIndexInModel > rowCount) {
                    rc.write(" disabled=\"\"");
                } else if (tableView.isRowSelected(rowIndexInModel)) {
                    rc.write(" checked=\"\"");
                }
                rc.write("></td>");
            } else if (mySelectionMode.equals(TableSelectionMode.SINGLESELECT)) {
                if (design.equals(TableViewDesign.ALTERNATING)) {
                    if ((firstVisibleRow + currentRow) % 2 == 0) {
                        rc.write("<td class=\"sapTbvCellAlt\"");
                    } else {
                        rc.write("<td class=\"sapTbvCellStd\"");
                    }
                } else if (design.equals(TableViewDesign.TRANSPARENT)) {
                    rc.write("<td class=\"sapTbvCellTrans\"");
                } else {
                    rc.write("<td class=\"sapTbvCellStd\"");
                }
                String id = rc.getParamIdForComponent(tableView);
                rc.write(" style=\"width:1\">");
                rc.write("<input type='radio' name='");
                rc.write(id);
                rc.write("-chk' value='");
                rc.write(currentRow);
                rc.write("'");
                if (!tableView.isRowSelectable(rowIndexInModel) || rowIndexInModel > rowCount) {
                    rc.write(" disabled=\"\"");
                } else {
                    String rowSelection = tableView.getOnRowSelection();
                    if (rowSelection != null && rowSelection.length() > 0) {
                        rc.write(" onClick=\"");
                        rc.write(TableRowSelectionEvent.renderEventCall(rc, tableView, currentRow));
                        rc.write("\"");
                    }
                    if (tableView.isRowSelected(rowIndexInModel)) {
                        rc.write(" checked=\"\"");
                    }
                }
                rc.write("></td>");
            }
        }
        rc.getCurrentForm().pushEventModifier(tableView);
    }

    public void renderContCellBegin(TableView tableView, IPageContext rc) {
        int colIndex = tableView.getCurrentColumnIndex() + tableView.getColspanForCurrentColumn();
        tableView.setCurrentColumnIndex(colIndex);
        int firstVisibleRow = tableView.getVisibleFirstRow();
        int rowIndex = tableView.getCurrentRowIndex() + firstVisibleRow - 1;
        int colspan = tableView.getColspanForCell(rowIndex, colIndex);
        int rowspan = tableView.getRowspanForCell(rowIndex, colIndex);
        SpanInfo spanInfo = tableView.getSpanInfoForCell(rowIndex, colIndex);
        CellHAlign hAlignment = tableView.getCellHAlignment(rowIndex, colIndex);
        if (hAlignment == null && spanInfo != null) {
            hAlignment = tableView.getCellHAlignment(spanInfo.originalRow, spanInfo.originalColumn);
        }
        CellVAlign vAlignment = tableView.getCellVAlignment(rowIndex, colIndex);
        tableView.setColspanForCurrentColumn(colspan);
        TableColumn column = tableView.getColumn(colIndex);
        DataType columnDataType = column.getDataType();
        rc.write("<td ");
        if (!column.isWrapping() || columnDataType.equals(DataType.BCD) || columnDataType.equals(DataType.INTEGER)) {
            rc.write("nowrap ");
        }
        String tooltipColumnKey = column.getTooltipColumnKey();
        String tooltip = null;
        if (tooltipColumnKey != null && !tooltipColumnKey.equals("") && rowIndex <= tableView.getRowCount()) {
            tooltip = tableView.getValueAt(rowIndex, tooltipColumnKey).toString();
        }
        if (tooltip != null) {
            rc.write("title=\"");
            rc.writeEncoded(tooltip);
            rc.write("\" ");
        }
        TableColumnType columnType = column.getCellType(rowIndex);
        if (hAlignment != null) {
            rc.write("align=\"" + hAlignment + "\" ");
        } else if (columnType != TableColumnType.USER && (columnDataType.equals(DataType.BCD) || columnDataType.equals(DataType.INTEGER))) {
            rc.write("align=\"right\" ");
        } else {
            rc.write("align=\"left\" ");
        }
        if (vAlignment != null) {
            rc.write("valign=\"" + vAlignment + "\" ");
        }
        if (colspan > 1) {
            rc.write("colspan=\"" + colspan + "\"");
        } else if (spanInfo != null && spanInfo.colspan > 1 && rowIndex == firstVisibleRow) {
            rc.write("colspan=\"" + spanInfo.colspan + "\"");
        }
        if (rowspan > 1) {
            rc.write(" rowspan=\"" + rowspan + "\"");
        } else if (spanInfo != null && spanInfo.rowspan > 1 && rowIndex == firstVisibleRow) {
            rc.write(" rowspan=\"" + spanInfo.rowspan + "\"");
        }
        TableCellStyle style = tableView.getStyleForCell(rowIndex, colIndex);
        TableViewDesign design = tableView.getDesign();
        int currentRow = tableView.getCurrentRowIndex();
        String classString = new String();
        classString = design.equals(TableViewDesign.ALTERNATING) ? ((firstVisibleRow + currentRow) % 2 == 0 ? " class=\"sapTbvCellAlt" : " class=\"sapTbvCellStd") : (design.equals(TableViewDesign.TRANSPARENT) ? " class=\"sapTbvCellTrans" : " class=\"sapTbvCellStd");
        if (TableCellStyle.NEGATIVE.equals(style)) {
            classString = " class=\"sapTbvCellNeg";
        } else if (TableCellStyle.POSITIVE.equals(style)) {
            classString = " class=\"sapTbvCellPos";
        } else if (TableCellStyle.MARKED.equals(style)) {
            classString = " class=\"sapTbvCellMarked";
        } else if (TableCellStyle.SUBTOTAL.equals(style)) {
            classString = " class=\"sapTbvCellSubtot";
        } else if (TableCellStyle.SUBTOTAL_LIGHT.equals(style)) {
            classString = " class=\"sapTbvCellSubtotLight";
        } else if (TableCellStyle.TOTAL.equals(style)) {
            classString = " class=\"sapTbvCellTot";
        } else if (TableCellStyle.BADVALUE_DARK.equals(style)) {
            classString = " class=\"sapTbvCellBadDark";
        } else if (TableCellStyle.BADVALUE_MEDIUM.equals(style)) {
            classString = " class=\"sapTbvCellBadMedium";
        } else if (TableCellStyle.BADVALUE_LIGHT.equals(style)) {
            classString = " class=\"sapTbvCellBadLight";
        } else if (TableCellStyle.CRITICALVALUE_DARK.equals(style)) {
            classString = " class=\"sapTbvCellCritDark";
        } else if (TableCellStyle.CRITICALVALUE_MEDIUM.equals(style)) {
            classString = " class=\"sapTbvCellCritMedium";
        } else if (TableCellStyle.CRITICALVALUE_LIGHT.equals(style)) {
            classString = " class=\"sapTbvCellCritLight";
        } else if (TableCellStyle.GOODVALUE_DARK.equals(style)) {
            classString = " class=\"sapTbvCellGoodDark";
        } else if (TableCellStyle.GOODVALUE_MEDIUM.equals(style)) {
            classString = " class=\"sapTbvCellGoodMedium";
        } else if (TableCellStyle.GOODVALUE_LIGHT.equals(style)) {
            classString = " class=\"sapTbvCellGoodLight";
        } else if (TableCellStyle.GROUP_HIGHLIGHTED.equals(style)) {
            classString = " class=\"sapTbvCellGrpHL";
        } else if (TableCellStyle.GROUP_HIGHLIGHTED_LIGHT.equals(style)) {
            classString = " class=\"sapTbvCellGrpHLLight";
        } else if (TableCellStyle.GROUP_LEVEL1.equals(style)) {
            classString = " class=\"sapTbvCellGrpLvl1";
        } else if (TableCellStyle.GROUP_LEVEL2.equals(style)) {
            classString = " class=\"sapTbvCellGrpLvl2";
        } else if (TableCellStyle.GROUP_LEVEL3.equals(style)) {
            classString = " class=\"sapTbvCellGrpLvl3";
        } else if (TableCellStyle.KEY_MEDIUM.equals(style)) {
            classString = " class=\"sapTbvCellKeyMedium";
        }
        if (column.isMonospaced()) {
            classString = classString.concat("Mono");
        }
        classString = classString.concat("\"");
        rc.write(classString);
        String onClick = column.getOnCellClick();
        String width = column.getWidth();
        if (onClick != null) {
            rc.write(" style=\"cursor:hand;");
            if (width != null && width.length() > 0) {
                rc.write("width:");
                rc.write(width);
                rc.write(";");
            }
            rc.write("\" cc=\"");
            rc.write(colIndex);
            rc.write("\"");
        } else if (width != null && width.length() > 0) {
            rc.write(" style=\"width:");
            rc.write(width);
            rc.write(";\"");
        }
        rc.write(">");
    }

    public void renderContCellEnd(TableView tableView, IPageContext rc) {
        rc.write("</td>");
    }

    public void renderContRowEnd(TableView tableView, IPageContext rc) {
        rc.write("</tr>");
        rc.getCurrentForm().popEventModifier();
    }

    public void renderContentEnd(TableView tableView, IPageContext rc) {
        rc.write("</tbody>");
    }

    public void renderFooterBegin(TableView tableView, IPageContext rc) {
        TableViewDesign design = tableView.getDesign();
        if (design.equals(TableViewDesign.ALTERNATING)) {
            rc.write("<tr><td align=\"left\" class=\"sapTbvHdrAlt\" colspan=\"");
        } else if (design.equals(TableViewDesign.TRANSPARENT)) {
            rc.write("<tr><td align=\"left\" class=\"sapTbvHdrTrans\" colspan=\"");
        } else {
            rc.write("<tr><td align=\"left\" class=\"sapTbvHdrStd\" colspan=\"");
        }
        if (tableView.getSelectionMode().equals(TableSelectionMode.NONE)) {
            rc.write(tableView.getColumnCount());
        } else {
            rc.write(tableView.getColumnCount() + 1);
        }
        rc.write("\" nowrap>");
        rc.write("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr>");
    }

    public void renderFooterNavigation(TableView tableView, IPageContext rc) {
        int rowCount = tableView.getRowCount();
        int visibleRowCount = tableView.getVisibleRowCount();
        boolean navByLine = tableView.getNavigationMode().equals(TableNavigationMode.BYLINE);
        boolean isLastPage = visibleRowCount == rowCount;
        boolean isFirstRowVisible = tableView.getVisibleFirstRow() == 1;
        boolean isLastRowVisible = tableView.getVisibleLastRow() >= rowCount;
        rc.write("<td nowrap align=\"left\"><span class=\"sapTbvBtnTop");
        if (isFirstRowVisible) {
            rc.write("Dsbl\"></span>&nbsp;</td>");
        } else {
            rc.write("\" onClick=\"");
            rc.write(TableNavigationEvent.renderEventCall(rc, tableView, "top"));
            rc.write("\"></span>&nbsp;</td>");
        }
        rc.write("<td nowrap align=\"left\"><span class=\"sapTbvBtnPgUp");
        if (isFirstRowVisible) {
            rc.write("Dsbl\"></span>&nbsp;</td>");
        } else {
            rc.write("\" onClick=\"");
            rc.write(TableNavigationEvent.renderEventCall(rc, tableView, "pageUp"));
            rc.write("\"></span>&nbsp;</td>");
        }
        if (navByLine) {
            if (isFirstRowVisible) {
                rc.write("<td nowrap align=\"left\"><span class=\"sapTbvBtnUpDsbl\"></span>&nbsp;</td>");
            } else {
                rc.write("<td nowrap align=\"left\" onClick=\"");
                rc.write(TableNavigationEvent.renderEventCall(rc, tableView, "lineUp"));
                rc.write("\"><span class=\"sapTbvBtnUp\"></span>&nbsp;</td>");
            }
            if (isLastRowVisible) {
                rc.write("<td nowrap align=\"left\" nowrap><span class=\"sapTbvBtnDownDsbl\"></span>&nbsp;</td>");
            } else {
                rc.write("<td nowrap align=\"left\" onClick=\"");
                rc.write(TableNavigationEvent.renderEventCall(rc, tableView, "lineDown"));
                rc.write("\"><span class=\"sapTbvBtnDown\"></span>&nbsp;</td>");
            }
        }
        if (isLastPage || isLastRowVisible) {
            rc.write("<td nowrap align=\"left\"><span class=\"sapTbvBtnPgDownDsbl\"></span>&nbsp;</td>");
        } else {
            rc.write("<td nowrap align=\"left\" onClick=\"");
            rc.write(TableNavigationEvent.renderEventCall(rc, tableView, "pageDown"));
            rc.write("\"><span class=\"sapTbvBtnPgDown\"></span>&nbsp;</td>");
        }
        if (isLastPage || isLastRowVisible) {
            rc.write("<td nowrap align=\"left\"><span class=\"sapTbvBtnBottomDsbl\"></span>&nbsp;</td>");
        } else {
            rc.write("<td nowrap align=\"left\" onClick=\"");
            rc.write(TableNavigationEvent.renderEventCall(rc, tableView, "bottom"));
            rc.write("\"><span class=\"sapTbvBtnBottom\"></span>&nbsp;</td>");
        }
    }

    public void renderFooterPositionIndicator(TableView tableView, IPageContext rc) {
        int visibleRowCount = tableView.getVisibleRowCount();
        int visibleFirstRow = tableView.getVisibleFirstRow();
        TableViewDesign design = tableView.getDesign();
        if (design.equals(TableViewDesign.ALTERNATING)) {
            rc.write("<td width=\"100%\" align=\"right\" class=\"sapTbvHdrAlt\">");
        } else if (design.equals(TableViewDesign.TRANSPARENT)) {
            rc.write("<td width=\"100%\" align=\"right\" class=\"sapTbvHdrTrans\">");
        } else {
            rc.write("<td width=\"100%\" align=\"right\" class=\"sapTbvHdrStd\" nowrap>");
        }
        TableNavigationMode navigationMode = tableView.getNavigationMode();
        if (navigationMode.equals(TableNavigationMode.BYLINE)) {
            String navByLine = this.getResource(rc, "TXT_HTMLB_TABLE_NAV_BY_LINE");
            rc.writeEncoded(navByLine);
            rc.write(" ");
            if (tableView.getRowCount() != 0) {
                rc.write(visibleFirstRow);
            } else {
                rc.write("0");
            }
            rc.write("/");
            rc.write(tableView.getRowCount());
        } else if (visibleRowCount != 0) {
            int rowCount = tableView.getRowCount();
            int pageCount = rowCount % visibleRowCount != 0 || rowCount == 0 ? rowCount / visibleRowCount + 1 : rowCount / visibleRowCount;
            rc.writeEncoded(this.getResource(rc, "TXT_HTMLB_TABLE_NAV_BY_PAGE"));
            rc.write(" ");
            int currentPageIndex = tableView.getCurrentPageIndex();
            rc.write(currentPageIndex);
            rc.write("/");
            rc.write(pageCount);
        }
        rc.write("</td>");
    }

    public void renderFooterEnd(TableView tableView, IPageContext rc) {
        rc.write("</tr></table></td></tr>");
    }

    public void renderEnd(TableView tableView, IPageContext rc) {
        rc.write("</table>");
        String encodedKeys = tableView.encodeInternalData();
        rc.write("<input type=\"hidden\" name=\"");
        rc.write(rc.getParamIdForComponent(tableView));
        rc.write("-keys\" value=\"");
        rc.write(encodedKeys);
        rc.write("\">");
    }

    public void renderEmptyTableText(TableView tableView, IPageContext rc, String emptyTableText) {
        rc.write("<tr>");
        rc.write("<td class=\"sapTbvCellAlt\" colspan=\"");
        if (tableView.getSelectionMode().equals(TableSelectionMode.NONE)) {
            rc.write(tableView.getColumnCount());
        } else {
            rc.write(tableView.getColumnCount() + 1);
        }
        rc.write("\">");
        rc.write(emptyTableText);
        rc.write("</td></tr>");
    }

    private String getResource(IPageContext pageContext, String key) {
        try {
            return ResourceBundle.getBundle("com.sapportals.htmlb.Localization", pageContext.getLocale()).getString(key);
        }
        catch (Exception e) {
            Log.getLogLocation(false).debugT("DefaultTableViewRenderer", "getResource");
            return "";
        }
    }
}

