/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.RadioButton;
import com.sapportals.htmlb.RadioButtonGroup;
import com.sapportals.htmlb.enum.CellVAlign;
import com.sapportals.htmlb.event.RadioButtonClickEvent;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import java.util.Iterator;

public class DefaultRadioButtonGroupRenderer
implements HtmlbRenderer {
    public void render(Component component, int selector, IPageContext renderContext) {
        if (component instanceof RadioButtonGroup) {
            RadioButtonGroup myGroup = (RadioButtonGroup)component;
            switch (selector) {
                case 0: {
                    this.renderBegin(myGroup, renderContext);
                    break;
                }
                case 1: {
                    this.renderEnd(myGroup, renderContext);
                    break;
                }
                case 3: {
                    this.renderElementBegin(myGroup, renderContext);
                    break;
                }
                case 4: {
                    this.renderElementEnd(myGroup, renderContext);
                }
            }
        }
    }

    public void render(Component component, IPageContext renderContext) {
        if (component instanceof RadioButtonGroup) {
            RadioButtonGroup myGroup = (RadioButtonGroup)component;
            this.renderBegin(myGroup, renderContext);
            this.renderContent(myGroup, renderContext);
            this.renderEnd(myGroup, renderContext);
        }
    }

    public void renderBegin(RadioButtonGroup cbg, IPageContext renderContext) {
        renderContext.write(RadioButtonClickEvent.renderJSFunction(renderContext, cbg));
        renderContext.write("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" name=\"");
        renderContext.write("\" class=\"sapRbgWhl\">");
        cbg.setCurrentItem(0);
    }

    public void renderContent(RadioButtonGroup cbg, IPageContext renderContext) {
        Iterator it = cbg.iterator();
        while (it.hasNext()) {
            this.renderElementBegin(cbg, renderContext);
            RadioButton msi = (RadioButton)it.next();
            renderContext.write("<td");
            if (cbg.getVerticalAlignRbColumn() == CellVAlign.BOTTOM) {
                renderContext.write(" valign=\"bottom\"");
            }
            if (cbg.getVerticalAlignRbColumn() == CellVAlign.MIDDLE) {
                renderContext.write(" valign=\"middle\"");
            }
            if (cbg.getVerticalAlignRbColumn() == CellVAlign.TOP) {
                renderContext.write(" valign=\"top\"");
            }
            if (cbg.getVerticalAlignRbColumn() == CellVAlign.BASELINE) {
                renderContext.write(" valign=\"baseline\"");
            }
            renderContext.write(">");
            renderContext.render(msi, 2);
            renderContext.write("</td>");
            renderContext.write("<td");
            if (cbg.getVerticalAlignTextColumn() == CellVAlign.BOTTOM) {
                renderContext.write(" valign=\"bottom");
            }
            if (cbg.getVerticalAlignTextColumn() == CellVAlign.MIDDLE) {
                renderContext.write(" valign=\"middle");
            }
            if (cbg.getVerticalAlignTextColumn() == CellVAlign.TOP) {
                renderContext.write(" valign=\"top");
            }
            if (cbg.getVerticalAlignTextColumn() == CellVAlign.BASELINE) {
                renderContext.write(" valign=\"baseline");
            }
            renderContext.write("\"");
            if (msi.hasValidTooltip()) {
                renderContext.write(" title=\"");
                renderContext.write(msi.getTooltip());
                renderContext.write("\"");
            }
            renderContext.write(" class=\"sapRbgTxt\">");
            renderContext.render(msi, 3);
            renderContext.write("</td>");
            this.renderElementEnd(cbg, renderContext);
        }
    }

    public void renderElementBegin(RadioButtonGroup cbg, IPageContext renderContext) {
        int currentItem = cbg.getCurrentItem() + 1;
        cbg.setCurrentItem(currentItem);
        int colCount = cbg.getColumnCount();
        int colIndex = currentItem % colCount;
        if (colCount == 1 || colIndex == 1) {
            renderContext.write("<tr>");
        }
    }

    public void renderElementEnd(RadioButtonGroup cbg, IPageContext renderContext) {
        int myCount = cbg.getColumnCount();
        int colIndex = cbg.getCurrentItem() % myCount;
        if (colIndex == 0) {
            renderContext.write("</tr>");
        }
    }

    public void renderEnd(RadioButtonGroup group, IPageContext renderContext) {
        renderContext.write("</table>");
    }
}

