/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.MessageBar;
import com.sapportals.htmlb.enum.MessageType;
import com.sapportals.htmlb.rendering.AtomHtmlbRenderer;
import com.sapportals.htmlb.rendering.IJavascriptRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;

public class DefaultMessageBarRenderer
extends AtomHtmlbRenderer
implements IJavascriptRenderer {
    public void render(Component component, IPageContext renderContext) {
        if (component instanceof MessageBar) {
            MessageBar messageBar = (MessageBar)component;
            String text = messageBar.getMessageText();
            MessageType type = messageBar.getMessageType();
            if (text == null || text.equals("")) {
                type = MessageType.NONE;
            }
            String id = renderContext.getDocument().getDocumentId();
            renderContext.write("<div id=\"");
            renderContext.write(id);
            renderContext.write("_messagebar\" class=\"sapMessageBar");
            if (type != null) {
                renderContext.write(type.toString());
            } else {
                renderContext.write("None");
            }
            renderContext.write("\">");
            if (type != MessageType.NONE) {
                renderContext.write(text);
            }
            renderContext.write("</div>");
        }
    }

    public void renderJavascriptInterface(IPageContext renderContext, Component component, String generatedId) {
        RenderUtil.renderJavascriptInterface(renderContext, component, generatedId, "\"" + renderContext.getDocument().getDocumentId() + "\"");
    }
}

