/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.MenuBar;
import com.sapportals.htmlb.MenuItem;
import com.sapportals.htmlb.enum.HoverMenuTrigger;
import com.sapportals.htmlb.hovermenu.HoverMenu;
import com.sapportals.htmlb.rendering.AtomHtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;

public class DefaultMenuBarRenderer
extends AtomHtmlbRenderer {
    public void render(Component component, IPageContext renderContext) {
        if (component instanceof MenuBar) {
            MenuBar menuBar = (MenuBar)component;
            StringBuffer result = new StringBuffer();
            String menuBarWidth = menuBar.getWidth();
            result.append("<span class=\"sapMenuBarWhl\" id=\"");
            result.append(menuBar.getId());
            if (menuBarWidth != null && !menuBarWidth.equals("")) {
                result.append("\" style=\"width:");
                result.append(menuBarWidth);
                result.append(";");
            }
            result.append("\"><nobr>");
            int number = menuBar.getNumberOfMenuItems();
            int i = 0;
            while (i < number) {
                MenuItem item = menuBar.getMenuItemAt(i);
                result.append("<span tabindex=\"0\" class=\"sapMenuItemWhl\" id=\"");
                result.append(item.getId());
                if (item.isEnabled()) {
                    HoverMenu menu = item.getHoverMenu();
                    if (menu == null) {
                        throw new IllegalStateException("The menu item " + item.getId() + " must contain a hover menu");
                    }
                    String id = renderContext.getParamIdForComponent(menu);
                    if (menu.requiresForm()) {
                        renderContext.getCurrentForm().registerHoverMenu(menu);
                    } else {
                        renderContext.getDocument().registerHoverMenu(menu);
                    }
                    HoverMenuTrigger trigger = menuBar.getMenuTrigger();
                    if (trigger == null || trigger.equals(HoverMenuTrigger.ONLRCLICK)) {
                        result.append("\" onMouseOver=\"htmlbShowFirstMenu('");
                    } else {
                        result.append("\" ");
                        result.append(trigger.toString());
                        result.append("=\"htmlbShowFirstMenu('");
                    }
                    result.append(id);
                    result.append("', this, 1);window.event.cancelBubble = true; return false;\">");
                    result.append("<span class=\"sapMenuItemTxt\" id=\"");
                    result.append(item.getText());
                    result.append("\">&nbsp;");
                    result.append(item.getText());
                    result.append("</span>");
                    result.append("<span class=\"sapMenuItemBtn\" id=\"menuitembtn\">&nbsp;&nbsp;</span>");
                    result.append("</span>");
                } else {
                    result.append("\" onContextMenu=\"return false;");
                    result.append("\">");
                    result.append("<span class=\"sapMenuItemTxtDsbl\" id=\"");
                    result.append(item.getText());
                    result.append("\">&nbsp;");
                    result.append(item.getText());
                    result.append("</span>");
                    result.append("<span class=\"sapMenuItemBtnDsbl\" id=\"menuitembtn\">&nbsp;&nbsp;</span>");
                    result.append("</span>");
                }
                ++i;
            }
            result.append("</nobr></span>");
            renderContext.write(result.toString());
        }
    }
}

