/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Link;
import com.sapportals.htmlb.enum.LinkDesign;
import com.sapportals.htmlb.enum.LinkFontSize;
import com.sapportals.htmlb.enum.TextViewDesign;
import com.sapportals.htmlb.event.LinkClickEvent;
import com.sapportals.htmlb.rendering.AtomHtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;

public class DefaultLinkRenderer
extends AtomHtmlbRenderer {
    public void render(Component component, int selector, IPageContext renderContext) {
        if (component instanceof Link) {
            Link myLink = (Link)component;
            switch (selector) {
                case 0: {
                    this.renderBegin(myLink, renderContext);
                    break;
                }
                case 1: {
                    this.renderEnd(myLink, renderContext);
                    break;
                }
                case 2: {
                    this.renderElement(myLink, renderContext);
                }
            }
        }
    }

    public void render(Component component, IPageContext rc) {
        if (component instanceof Link) {
            Link myLink = (Link)component;
            this.renderBegin(myLink, rc);
            this.renderElement(myLink, rc);
            this.renderEnd(myLink, rc);
        }
    }

    public void renderElement(Link myLink, IPageContext rc) {
        RenderUtil.renderContainerContent(myLink, rc);
    }

    public void renderBegin(Link myLink, IPageContext rc) {
        String onClick = myLink.getOnClick();
        String reference = myLink.getReference();
        boolean disabled = false;
        if (!(onClick != null && onClick.length() != 0 || reference != null && reference.length() != 0)) {
            disabled = true;
        }
        rc.write("<a class=\"");
        if (disabled) {
            rc.write("sapLnkDsbl\" onClick=\"return false;\" href=\"javascript:void(0)");
        } else {
            String target;
            if (myLink.getLinkDesign().equals(LinkDesign.DRILLDOWN)) {
                rc.write("sapLnk");
            } else if (myLink.getLinkDesign().equals(LinkDesign.FUNCTION)) {
                rc.write("sapLnkFunction");
            } else if (myLink.getLinkDesign().equals(LinkDesign.REPORTING)) {
                rc.write("sapLnkReport");
            } else if (myLink.getLinkDesign().equals(LinkDesign.RESULT)) {
                rc.write("sapLnkResult");
            }
            if (onClick != null) {
                rc.write("\" href=\"#\" onClick=\"");
                rc.write(LinkClickEvent.renderEventCall(rc, myLink));
            }
            if (reference != null) {
                rc.write("\" href=\"");
                rc.write(reference);
            }
            if ((target = myLink.getTarget()) != null) {
                rc.write("\" target=\"");
                rc.write(target);
            }
        }
        String tooltip = myLink.getTooltip();
        if (tooltip != null) {
            rc.write("\" title=\"");
            rc.writeEncoded(tooltip);
        }
        rc.write("\">");
        LinkFontSize fontSize = myLink.getFontSize();
        if (fontSize != null && fontSize.equals(LinkFontSize.SMALL) && myLink.getInnerText() != null) {
            myLink.getInnerText().setDesign(TextViewDesign.LEGEND);
        }
    }

    public void renderEnd(Link l, IPageContext rc) {
        rc.write("</a>");
    }
}

