/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Label;
import com.sapportals.htmlb.enum.TextViewDesign;
import com.sapportals.htmlb.rendering.EventValidationRenderer;
import com.sapportals.htmlb.rendering.IPageContext;

public class DefaultLabelRenderer
extends EventValidationRenderer {
    public void render(Component component, IPageContext rc) {
        if (component instanceof Label) {
            String tooltip;
            String id;
            Label label = (Label)component;
            rc.write("<label for=\"");
            Component c = (Component)((Object)label.getLabelFor());
            if (c != null) {
                id = rc.getParamIdForComponent(c);
            } else {
                String componentId = label.getLabeledComponentId();
                id = rc.getComponentIdForLabel(componentId);
            }
            rc.write(id);
            rc.write("\" class=\"");
            TextViewDesign myDesign = label.getDesign();
            String design = myDesign == TextViewDesign.HEADER1 ? "urTxtH1" : (myDesign == TextViewDesign.HEADER2 ? "urTxtH2" : (myDesign == TextViewDesign.HEADER3 ? "urTxtH3" : (myDesign == TextViewDesign.EMPHASIZED ? "urTxtEmph" : (myDesign == TextViewDesign.STANDARD ? "urTxtStd" : (myDesign == TextViewDesign.LABEL ? "urTxtLbl" : (myDesign == TextViewDesign.LABELSMALL ? "urTxtLblSml" : (myDesign == TextViewDesign.LEGEND ? "urTxtLeg" : (myDesign == TextViewDesign.REFERENCE ? "urTxtRef" : "urTxtStd"))))))));
            rc.write(design);
            String width = label.getWidth();
            if (width != null) {
                rc.write("\" style=\"width:");
                rc.write(width);
                rc.write(";");
            }
            if ((tooltip = label.getTooltip()) != null) {
                rc.write("\" title=\"");
                rc.writeEncoded(tooltip);
            }
            rc.write("\">");
            if (!label.isWrapping()) {
                rc.write("<nobr>");
            }
            if (label.isEncode()) {
                rc.writeEncoded(label.getText());
            } else {
                rc.write(label.getText());
            }
            if (label.isRequired()) {
                rc.write("<span class=\"urTxtReq\">*</span>");
            }
            if (myDesign == TextViewDesign.LABEL || myDesign == TextViewDesign.LABELSMALL) {
                rc.write("<span class=\"");
                rc.write(design);
                rc.write("\">&nbsp;</span>");
            }
            if (!label.isWrapping()) {
                rc.write("</nobr>");
            }
            rc.write("</label>");
        }
    }
}

