/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.EventValidationComponent;
import com.sapportals.htmlb.InputField;
import com.sapportals.htmlb.JavascriptFragment;
import com.sapportals.htmlb.enum.DataType;
import com.sapportals.htmlb.enum.EventTrigger;
import com.sapportals.htmlb.enum.InputFieldDesign;
import com.sapportals.htmlb.enum.ResourceType;
import com.sapportals.htmlb.rendering.EventValidationRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.type.AbstractDataType;
import com.sapportals.htmlb.type.DataString;
import com.sapportals.htmlb.type.TypeFormatter;
import java.text.SimpleDateFormat;
import java.util.HashSet;

public class DefaultInputFieldRenderer
extends EventValidationRenderer {
    private static HashSet validationTriggers = new HashSet();
    static /* synthetic */ Class class$com$sapportals$htmlb$event$Event;

    public boolean getDefaultClientEventReturnValue(EventTrigger trigger, EventValidationComponent component) {
        return trigger == EventTrigger.ON_CHANGE;
    }

    public void render(Component component, IPageContext rc) {
        if (component instanceof InputField) {
            boolean showDateHelp;
            InputField inf = (InputField)component;
            DataType type = inf.getType();
            boolean bl = showDateHelp = DataType.DATE.equals(type) && inf.isShowHelp();
            if (showDateHelp) {
                StringBuffer sb = new StringBuffer(250);
                String javaScriptPath = rc.getJavascriptPath();
                sb.append("var javaScriptPath='");
                sb.append(javaScriptPath);
                sb.append("';");
                String[] dayNames = RenderUtil.getDayAbbreviations(rc.getLocale());
                if (dayNames.length != 7) {
                    throw new IllegalStateException("Only locales with 7 days are supported!");
                }
                sb.append("var htmlbDayNames = new Array('");
                int i = 0;
                while (i < 6) {
                    sb.append(dayNames[i]);
                    sb.append("','");
                    ++i;
                }
                sb.append(dayNames[6]);
                sb.append("');\n");
                sb.append("var htmlbMonthNames = new Array('");
                String[] monthNames = RenderUtil.getMonthNames(rc.getLocale());
                int i2 = 0;
                while (i2 < 11) {
                    sb.append(monthNames[i2]);
                    sb.append("','");
                    ++i2;
                }
                sb.append(monthNames[11]);
                sb.append("');\n");
                String jscript = sb.toString();
                rc.getDocument().getIncludes().addBodyEndResource(ResourceType.DIRECTJSCRIPT, "HTMLB_INPUTFIELD_DATEHELP", jscript);
                rc.write("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" id=\"");
                rc.write("\"><tr><td>");
            }
            if (inf.isVisible()) {
                String tooltip;
                String value;
                int maxlength;
                if (inf.isPassword()) {
                    rc.write("<input type=\"password\" class=\"sapEdf");
                } else {
                    rc.write("<input type=\"text\" class=\"sapEdf");
                }
                if (!inf.isValid()) {
                    rc.write("i");
                }
                if (inf.isRequired()) {
                    rc.write("Req");
                } else {
                    rc.write("Txt");
                }
                if (inf.isEnabled()) {
                    rc.write("Enbl");
                } else {
                    rc.write("Dsbl");
                }
                if (inf.getDesign() == InputFieldDesign.SMALL) {
                    rc.write("Sml");
                }
                rc.write("\" autocomplete=\"off");
                int mySize = inf.getSize();
                if (mySize > 0) {
                    rc.write("\" size=\"");
                    rc.write(mySize);
                }
                if ((maxlength = inf.getMaxlength()) > 0) {
                    rc.write("\" maxlength =\"");
                    rc.write(maxlength);
                }
                if ((value = inf.getWidth()) != null && !"".equals(value)) {
                    rc.write("\" style=\"width:");
                    rc.write(value);
                    rc.write(";");
                }
                if ((tooltip = inf.getTooltip()) != null) {
                    rc.write("\" title=\"");
                    rc.writeEncoded(tooltip);
                }
                if (!inf.isEnabled()) {
                    rc.write("\" readonly ");
                }
                rc.write("\"");
                this.renderEventValidationHandlers(class$com$sapportals$htmlb$event$Event == null ? (class$com$sapportals$htmlb$event$Event = DefaultInputFieldRenderer.class$("com.sapportals.htmlb.event.Event")) : class$com$sapportals$htmlb$event$Event, validationTriggers, false, inf, rc);
            } else {
                rc.write("<input type=\"hidden\"");
            }
            rc.write(" name=\"");
            String uniqueName = rc.getParamIdForComponent(inf);
            rc.write(uniqueName);
            rc.write("\" id=\"");
            rc.write(uniqueName);
            if (inf.isLabeled()) {
                rc.write("\" id=\"");
                rc.write(uniqueName);
            }
            Object value = inf.getValue();
            rc.write("\" value=\"");
            if (value != null) {
                String valueString = null;
                if (value instanceof AbstractDataType) {
                    AbstractDataType dataValue = (AbstractDataType)value;
                    if (dataValue != null) {
                        valueString = dataValue.isValid() ? dataValue.toString(rc) : (dataValue instanceof DataString ? dataValue.toString(rc) : dataValue.getValueAsString());
                    }
                } else {
                    valueString = value.toString();
                }
                if (inf.getValueEncode()) {
                    rc.writeEncoded(valueString);
                } else {
                    rc.write(DefaultInputFieldRenderer.encodeQuots(valueString));
                }
            }
            rc.write("\"></input>");
            if (showDateHelp) {
                rc.write("</td><td><div class=\"sapEdfHlp\" onClick=\"");
                rc.write("sapHelpDate('");
                rc.write(uniqueName);
                rc.write("','htmlbDayNames','htmlbMonthNames','" + inf.getFirstDayOfWeek() + "','");
                SimpleDateFormat sdf = (SimpleDateFormat)TypeFormatter.getFormat(rc.getLocale(), DataType.DATE);
                String pattern = sdf.toPattern();
                String dateFormat = "2";
                if ("dd.MM.yyyy".equals(pattern)) {
                    dateFormat = "1";
                } else if ("MM/dd/yyyy".equals(pattern)) {
                    dateFormat = "2";
                } else if ("yyyy-MM-dd".equals(pattern)) {
                    dateFormat = "6";
                }
                rc.write(dateFormat);
                rc.write("','");
                rc.write(rc.getStylesheetUrl());
                rc.write("','");
                rc.write(rc.getCurrentFormId());
                rc.write("')\">");
                rc.write("&nbsp;</DIV></td></tr></table>");
            }
            StringBuffer buffer = new StringBuffer(1000);
            String infId = rc.getParamIdForComponent(inf);
            String enabled = inf.isEnabled() ? "true" : "false";
            AbstractDataType dataValue = (AbstractDataType)inf.getValue();
            String stringValue = "";
            if (dataValue != null) {
                stringValue = dataValue.getValueAsString();
            }
            String formid = rc.getCurrentFormId();
            buffer.append("htmlb_inputfields['");
            buffer.append(RenderUtil.encodeForJS(formid + inf.getId()));
            buffer.append("']=new htmlb_inputfield(\"");
            buffer.append(infId);
            buffer.append("\",\"");
            buffer.append(inf.getId());
            buffer.append("\",\"");
            buffer.append(RenderUtil.encodeForJS(stringValue));
            buffer.append("\",");
            buffer.append(enabled);
            buffer.append(",\"");
            buffer.append(inf.getTooltip());
            buffer.append("\");");
            JavascriptFragment javascript = new JavascriptFragment("", buffer.toString());
            rc.getCurrentForm().addFormEndJavascript(javascript);
        }
    }

    public static String encodeQuots(String value) {
        StringBuffer buff = new StringBuffer(value.length());
        char c = '\u0000';
        int i = 0;
        while (i < value.length()) {
            c = value.charAt(i);
            if (c == '\"') {
                buff.append("&quot;");
            } else {
                buff.append(c);
            }
            ++i;
        }
        return buff.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        validationTriggers.add(EventTrigger.ON_BLUR);
        validationTriggers.add(EventTrigger.ON_CHANGE);
    }
}

