/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Includes;
import com.sapportals.htmlb.Resource;
import com.sapportals.htmlb.enum.ResourceType;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import java.util.Iterator;
import java.util.List;

public class DefaultIncludesRenderer
implements HtmlbRenderer {
    public void render(Component component, int selector, IPageContext renderContext) {
        if (component instanceof Includes) {
            Includes myIncludes = (Includes)component;
            switch (selector) {
                case 0: {
                    this.render(myIncludes.getHeadList(), renderContext);
                    break;
                }
                case 1: {
                    this.render(myIncludes.getBodyBeginList(), renderContext);
                    break;
                }
                case 2: {
                    this.render(myIncludes.getBodyEndList(), renderContext);
                }
            }
        }
    }

    public void render(Component component, IPageContext renderContext) {
        this.render(component, 0, renderContext);
    }

    public void render(List resourceList, IPageContext renderContext) {
        Iterator myIterator = resourceList.iterator();
        while (myIterator.hasNext()) {
            Resource myResource = (Resource)myIterator.next();
            ResourceType myType = myResource.getType();
            if (myType == ResourceType.CSS) {
                this.renderCSS(myResource, renderContext);
                continue;
            }
            if (myType == ResourceType.JAVASCRIPT) {
                this.renderJS(myResource, renderContext);
                continue;
            }
            if (myType == ResourceType.RAWTEXT) {
                this.renderRawText(myResource, renderContext);
                continue;
            }
            if (myType != ResourceType.DIRECTJSCRIPT) continue;
            this.renderJSDirect(myResource, renderContext);
        }
    }

    protected void renderRawText(Resource myResource, IPageContext renderContext) {
        renderContext.write((String)myResource.getData());
    }

    protected void renderCSS(Resource cssResource, IPageContext renderContext) {
        renderContext.writeHeadIncludes("<link type=\"text/css\" href=\"");
        renderContext.writeHeadIncludes((String)cssResource.getData());
        renderContext.writeHeadIncludes("\" rel=\"stylesheet\">");
    }

    protected void renderJS(Resource jsResource, IPageContext renderContext) {
        renderContext.writeHeadIncludes("<script language=\"JavaScript\" src=\"");
        renderContext.writeHeadIncludes((String)jsResource.getData());
        String optionalAttributes = jsResource.getOptionalAttributes();
        if (optionalAttributes != null) {
            renderContext.writeHeadIncludes("\" ");
            renderContext.writeHeadIncludes(optionalAttributes);
            renderContext.writeHeadIncludes("></script>");
        } else {
            renderContext.writeHeadIncludes("\"></script>");
        }
    }

    protected void renderJSDirect(Resource jsResource, IPageContext renderContext) {
        renderContext.write("<script language=\"JavaScript\" defer=\"\">");
        renderContext.write((String)jsResource.getData());
        renderContext.write("</script>");
    }
}

