/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.ImageArea;
import com.sapportals.htmlb.ImageMap;
import com.sapportals.htmlb.Link;
import com.sapportals.htmlb.enum.ImageAreaType;
import com.sapportals.htmlb.event.LinkClickEvent;
import com.sapportals.htmlb.rendering.AtomHtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import java.util.Iterator;
import java.util.List;

public class DefaultImageMapRenderer
extends AtomHtmlbRenderer {
    public void render(Component component, IPageContext rc) {
        if (component instanceof ImageMap) {
            ImageMap map = (ImageMap)component;
            rc.write("<map name=\"");
            rc.write(rc.getParamIdForComponent(map));
            rc.write("\">");
            List areas = map.getAreas();
            if (areas != null) {
                Iterator iter = areas.iterator();
                while (iter.hasNext()) {
                    ImageArea area = (ImageArea)iter.next();
                    Link link = area.getLink();
                    String onClick = null;
                    String reference = null;
                    String target = null;
                    String tooltip = null;
                    boolean disabled = false;
                    rc.write("<area shape=\"");
                    String type = "";
                    if (area.getAreaType().equals(ImageAreaType.RECTANGLE)) {
                        type = "rect";
                    } else if (area.getAreaType().equals(ImageAreaType.CIRCLE)) {
                        type = "circle";
                    } else if (area.getAreaType().equals(ImageAreaType.POLYGON)) {
                        type = "poly";
                    }
                    rc.write(type);
                    rc.write("\" coords=\"");
                    rc.write(area.getCoordinates());
                    if (link != null) {
                        onClick = link.getOnClick();
                        reference = link.getReference();
                        target = link.getTarget();
                        tooltip = link.getTooltip();
                    }
                    if (!(onClick != null && onClick.length() != 0 || reference != null && reference.length() != 0)) {
                        disabled = true;
                    }
                    if (disabled) {
                        rc.write("\" onClick=\"return false;\" href=\"#");
                    } else {
                        if (onClick != null) {
                            rc.write("\" href=\"#\" onClick=\"");
                            rc.write(LinkClickEvent.renderEventCall(rc, link));
                        }
                        if (reference != null) {
                            rc.write("\" href=\"");
                            rc.write(reference);
                        }
                        if (target != null) {
                            rc.write("\" target=\"");
                            rc.write(target);
                        }
                        if (tooltip != null) {
                            rc.write("\" alt=\"");
                            rc.write(tooltip);
                        }
                    }
                    rc.write("\"/>");
                }
            }
            rc.write("</map>");
        }
    }
}

