/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.HtmlEdit;
import com.sapportals.htmlb.enum.DataType;
import com.sapportals.htmlb.enum.HtmlEditDesign;
import com.sapportals.htmlb.event.InsertImageEvent;
import com.sapportals.htmlb.event.InsertLinkEvent;
import com.sapportals.htmlb.rendering.AtomHtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.statusicons.Mimes;
import com.sapportals.htmlb.type.TypeFormatter;
import com.sapportals.htmlb.util.Log;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;

public class DefaultHtmlEditRenderer
extends AtomHtmlbRenderer {
    private static final String IMG_ALIGNCENTER = "200_01";
    private static final String IMG_ALIGNRIGHT = "200_02";
    private static final String IMG_ALIGNLEFT = "200_03";
    private static final String IMG_BOLD = "200_04";
    private static final String IMG_ITALIC = "200_05";
    private static final String IMG_UNDERLINE = "200_06";
    private static final String IMG_STRIKETHROUGH = "200_07";
    private static final String IMG_SUBSCRIPT = "200_08";
    private static final String IMG_SUPERSCRIPT = "200_09";
    private static final String IMG_CUT = "200_10";
    private static final String IMG_COPY = "200_11";
    private static final String IMG_PASTE = "200_12";
    private static final String IMG_PRINT = "200_13";
    private static final String IMG_PREVIEW = "200_14";
    private static final String IMG_LISTBULL = "200_15";
    private static final String IMG_LISTNUM = "200_16";
    private static final String IMG_INDENT = "200_17";
    private static final String IMG_OUTDENT = "200_18";
    private static final String IMG_LINKKM = "200_19";
    private static final String IMG_LINKWEB = "200_20";
    private static final String IMG_IMAGEKM = "200_21";
    private static final String IMG_INSERTTABLE = "200_22";
    private static final String IMG_INSERTTABLECOLUMN = "200_23";
    private static final String IMG_DELETETABLECOLUMN = "200_24";
    private static final String IMG_INSERTTABLEROW = "200_25";
    private static final String IMG_DELETETABLEROW = "200_26";
    private static final String IMG_JOINTABLECELL = "200_27";
    private static final String IMG_JOINTABLEROW = "200_28";
    private static final String IMG_MODIFYTABLEPROP = "200_29";
    private static final String IMG_INSERTSPECIALCHAR = "200_30";
    private static final String IMG_INSERTRULE = "200_31";
    private static final String IMG_UNDO = "200_32";
    private static final String IMG_REDO = "200_33";
    private static final String IMG_DATEAANDTIME = "200_34";
    private static final String IMG_TEXTCSS = "200_35";
    private static final String IMG_TEXTSIZE = "200_36";
    private static final String IMG_TEXTFGCOLOR = "200_37";
    private static final String IMG_TEXTBGCOLOR = "200_38";
    private static final String IMG_PROPERTIES = "200_39";
    private static final String IMG_WIDTH = "12";
    private static final String IMG_HEIGHT = "12";
    private static final String CLASS_TOOLBAR = "class=\"urTbarWhl\"";
    private static final String CLASS_IMAGELINK = "";
    private static final String CLASS_EDITAREA = " class=\"urScrl urFontStd urTxtStd\" ";
    private static final String CLASS_EDITAREA_NO_STYLE = " class=\"\"";
    private String str508SkipStartId = "";
    private String str508SkipEndId = "";
    private String accessibilityDescription = "";
    private String expanderId = "";

    public void render(Component component, IPageContext renderContext) {
        StringBuffer buffer = new StringBuffer(4096);
        if (component instanceof HtmlEdit) {
            HtmlEdit edit = (HtmlEdit)component;
            if (edit.getAccessibilityDescription().length() > 0) {
                this.accessibilityDescription = edit.getAccessibilityDescription();
            }
            this.getHTMLText(buffer, edit, renderContext);
            renderContext.write(buffer.toString());
        }
    }

    private void getHTMLText(StringBuffer b, HtmlEdit editComponent, IPageContext pc) {
        String id;
        this.str508SkipEndId = id = pc.getParamIdForComponent(editComponent);
        this.str508SkipEndId = this.str508SkipEndId + "-skipend";
        this.getStartLayout(b, editComponent, id);
        int tabIndex = 0;
        if (editComponent.getDesignConfiguration() != HtmlEditDesign.NOTOOLBAR && (this.doDisplayToolbarLine1(editComponent) || this.doDisplayToolbarLine2(editComponent))) {
            b.append("<tr height=20><td valign=top><table ");
            b.append(CLASS_TOOLBAR);
            b.append(" cellpadding=0 cellspacing=0 border=0 width=\"100%\" height=\"100%\">");
            if (this.doDisplayToolbarLine1(editComponent)) {
                b.append("<TR><TD><TABLE><TR>");
                if (editComponent.getDoPreview()) {
                    this.getPreview(b, id, pc, tabIndex);
                    ++tabIndex;
                }
                if (editComponent.getDoCutCopyPaste()) {
                    this.getCutCopyPaste(b, id, pc, tabIndex);
                    this.writeBlank(b);
                    tabIndex += 3;
                }
                if (editComponent.getDoBold()) {
                    this.getBold(b, id, pc, tabIndex);
                    ++tabIndex;
                }
                if (editComponent.getDoItalic()) {
                    this.getItalic(b, id, pc, tabIndex);
                    ++tabIndex;
                }
                if (editComponent.getDoUnderline()) {
                    this.getUnderline(b, id, pc, tabIndex);
                    this.writeBlank(b);
                }
                int n = ++tabIndex;
                this.getTextStyleMenu(b, id, pc, n, editComponent.getDoUsePortalStyle());
                int n2 = ++tabIndex;
                this.getTextSizeMenu(b, id, pc, n2);
                int n3 = ++tabIndex;
                this.getTextForegroundColor(b, id, pc, n3);
                int n4 = ++tabIndex;
                ++tabIndex;
                this.getTextBackgroundColor(b, id, pc, n4, editComponent.getDoUsePortalStyle());
                this.writeBlank(b);
                ++tabIndex;
                if (editComponent.getDoList()) {
                    this.getList(b, id, pc, tabIndex);
                    tabIndex += 2;
                }
                if (editComponent.getDoInOutdent()) {
                    this.getInOutdent(b, id, pc, tabIndex);
                    tabIndex += 2;
                }
                if (editComponent.getDesignConfiguration() == HtmlEditDesign.FULL && editComponent.getDoAlign()) {
                    this.getAlign(b, id, pc, tabIndex);
                    tabIndex += 3;
                }
                if (editComponent.getDoImage()) {
                    this.writeBlank(b);
                    this.getInsertImage(b, id, editComponent, pc, tabIndex);
                    ++tabIndex;
                }
                if (editComponent.getDoLinkKM()) {
                    this.getInsertLinkKM(b, id, editComponent, pc, tabIndex);
                    ++tabIndex;
                }
                if (editComponent.getDoLink()) {
                    this.getInsertLink(b, id, editComponent, pc, tabIndex);
                    this.writeBlank(b);
                    ++tabIndex;
                }
                if (editComponent.getDesignConfiguration() == HtmlEditDesign.FULL) {
                    if (editComponent.getInsertSpecialCharacter()) {
                        this.getInsertSpecialChar(b, id, pc, tabIndex++);
                    }
                    if (editComponent.getInsertHorizontalLine()) {
                        this.getInsertRule(b, id, pc, tabIndex++);
                    }
                    if (editComponent.getDoInsertTable()) {
                        this.getInsertTable(b, id, editComponent, pc, tabIndex);
                        this.writeBlank(b);
                        ++tabIndex;
                    }
                    if (editComponent.getDoModifyTableProperties()) {
                        this.getModifyTableProperties(b, id, editComponent, pc, tabIndex);
                        ++tabIndex;
                    }
                }
                this.expanderId = id + "_expander";
                b.append("</TR></TABLE></TD>");
                b.append("<td id=\"");
                b.append(this.expanderId);
                b.append("\"");
                b.append(" tabindex=\"0\" ");
                if (editComponent.isExpandSize()) {
                    b.append(" class=\"urTbarBtnExp urSTbvCellGrpLvl3\"");
                } else {
                    b.append(" class=\"urTbarBtnCol urSTbvCellGrpLvl3\"");
                }
                b.append(" style=\"cursor:hand;\" width=\"3\" title=\"Expand Editor\" align=\"right\" LANGUAGE=\"javascript\" onClick=\"htmlb_hed_expPanel_onclick(this,'");
                b.append(id);
                b.append("')\" onKeyPress=\"htmlb_hed_expPanel_onclick(this,'");
                b.append(id);
                b.append("')\"></td>");
                b.append("</TR>");
            }
            b.append("</table></td></tr>");
        }
        this.getEndLayout(b, id, editComponent, pc);
    }

    private String getInitMethod(String id, HtmlEdit editComponent, IPageContext pc) {
        String initStr = "save('" + id + "');";
        HashMap<String, String> allTexts = new HashMap<String, String>();
        allTexts.put("TXT_HTMLB_HED_ROWS", this.getResource(pc, "TXT_HTMLB_HED_ROWS"));
        allTexts.put("TXT_HTMLB_HED_COLS", this.getResource(pc, "TXT_HTMLB_HED_COLS"));
        allTexts.put("TXT_HTMLB_HED_WIDTH", this.getResource(pc, "TXT_HTMLB_HED_WIDTH"));
        allTexts.put("TXT_HTMLB_HED_ALIGN", this.getResource(pc, "TXT_HTMLB_HED_ALIGN"));
        allTexts.put("TXT_HTMLB_HED_BORDER", this.getResource(pc, "TXT_HTMLB_HED_BORDER"));
        allTexts.put("TXT_HTMLB_HED_CELLPAD", this.getResource(pc, "TXT_HTMLB_HED_CELLPAD"));
        allTexts.put("TXT_HTMLB_HED_CELLSPACE", this.getResource(pc, "TXT_HTMLB_HED_CELLSPACE"));
        allTexts.put("TXT_HTMLB_HED_TABLEHEADER", this.getResource(pc, "TXT_HTMLB_HED_TABLEHEADER"));
        allTexts.put("TXT_HTMLB_HED_USEPORTALSTY", this.getResource(pc, "TXT_HTMLB_HED_USEPORTALSTY"));
        allTexts.put("TXT_HTMLB_HED_TITLE_INS_TB", this.getResource(pc, "TXT_HTMLB_HED_TITLE_INS_TB"));
        allTexts.put("TXT_HTMLB_HED_TITLE_MOD_TB", this.getResource(pc, "TXT_HTMLB_HED_TITLE_MOD_TB"));
        allTexts.put("TXT_HTMLB_HED_AL_RIGHT", this.getResource(pc, "TXT_HTMLB_HED_AL_RIGHT"));
        allTexts.put("TXT_HTMLB_HED_AL_LEFT", this.getResource(pc, "TXT_HTMLB_HED_AL_LEFT"));
        allTexts.put("TXT_HTMLB_HED_AL_CENTER", this.getResource(pc, "TXT_HTMLB_HED_AL_CENTER"));
        allTexts.put("TXT_HTMLB_HED_AL_DEFAULT", this.getResource(pc, "TXT_HTMLB_HED_AL_DEFAULT"));
        allTexts.put("TXT_HTMLB_HED_AL_PROC", this.getResource(pc, "TXT_HTMLB_HED_AL_PROC"));
        allTexts.put("TXT_HTMLB_HED_AL_PIX", this.getResource(pc, "TXT_HTMLB_HED_AL_PIX"));
        allTexts.put("TXT_HTMLB_HED_OK", this.getResource(pc, "TXT_HTMLB_HED_OK"));
        allTexts.put("TXT_HTMLB_HED_CANCEL", this.getResource(pc, "TXT_HTMLB_HED_CANCEL"));
        allTexts.put("TXT_HTMLB_HED_APPLY", this.getResource(pc, "TXT_HTMLB_HED_APPLY"));
        allTexts.put("TXT_HTMLB_HED_INS_SC", this.getResource(pc, "TXT_HTMLB_HED_INS_SC"));
        allTexts.put("TXT_HTMLB_HED_TITLE_INS_WE", this.getResource(pc, "TXT_HTMLB_HED_TITLE_INS_WE"));
        allTexts.put("TXT_HTMLB_HED_TITLE_MOD_WE", this.getResource(pc, "TXT_HTMLB_HED_TITLE_MOD_WE"));
        allTexts.put("TXT_HTMLB_HED_WEB_TEXT", this.getResource(pc, "TXT_HTMLB_HED_WEB_TEXT"));
        allTexts.put("TXT_HTMLB_HED_WEB_URL", this.getResource(pc, "TXT_HTMLB_HED_WEB_URL"));
        allTexts.put("TXT_HTMLB_HED_WEB_OPEN", this.getResource(pc, "TXT_HTMLB_HED_WEB_OPEN"));
        allTexts.put("TXT_HTMLB_HED_MOD_IMG", this.getResource(pc, "TXT_HTMLB_HED_MOD_IMG"));
        allTexts.put("TXT_HTMLB_HED_HEIGHT", this.getResource(pc, "TXT_HTMLB_HED_HEIGHT"));
        allTexts.put("TXT_HTMLB_IMG_TEXT", this.getResource(pc, "TXT_HTMLB_IMG_TEXT"));
        allTexts.put("TXT_HTMLB_HED_WEB_URL", this.getResource(pc, "TXT_HTMLB_HED_WEB_URL"));
        allTexts.put("TXT_HTMLB_HED_MOD_CELL", this.getResource(pc, "TXT_HTMLB_HED_MOD_CELL"));
        allTexts.put("TXT_HTMLB_HED_HALIGN", this.getResource(pc, "TXT_HTMLB_HED_HALIGN"));
        allTexts.put("TXT_HTMLB_HED_VALIGN", this.getResource(pc, "TXT_HTMLB_HED_VALIGN"));
        allTexts.put("TXT_HTMLB_HED_AL_BASE", this.getResource(pc, "TXT_HTMLB_HED_AL_BASE"));
        allTexts.put("TXT_HTMLB_HED_AL_BOTTOM", this.getResource(pc, "TXT_HTMLB_HED_AL_BOTTOM"));
        allTexts.put("TXT_HTMLB_HED_AL_TOP", this.getResource(pc, "TXT_HTMLB_HED_AL_TOP"));
        allTexts.put("TXT_HTMLB_HED_AL_LEFT", this.getResource(pc, "TXT_HTMLB_HED_AL_LEFT"));
        allTexts.put("TXT_HTMLB_HED_AL_RIGHT", this.getResource(pc, "TXT_HTMLB_HED_AL_RIGHT"));
        allTexts.put("TXT_HTMLB_HED_PADDING", this.getResource(pc, "TXT_HTMLB_HED_PADDING"));
        allTexts.put("TXT_HTMLB_HED_BGCOLOR", this.getResource(pc, "TXT_HTMLB_HED_BGCOLOR"));
        allTexts.put("TXT_HTMLB_HED_SELECT", this.getResource(pc, "TXT_HTMLB_HED_SELECT"));
        allTexts.put("TXT_HTMLB_HED_SEL_IMG_LINK", this.getResource(pc, "TXT_HTMLB_HED_SEL_IMG_LINK"));
        allTexts.put("TXT_HTMLB_HED_CUT", this.getResource(pc, "TXT_HTMLB_HED_CUT"));
        allTexts.put("TXT_HTMLB_HED_COPY", this.getResource(pc, "TXT_HTMLB_HED_COPY"));
        allTexts.put("TXT_HTMLB_HED_PASTE", this.getResource(pc, "TXT_HTMLB_HED_PASTE"));
        allTexts.put("TXT_HTMLB_HED_SELALL", this.getResource(pc, "TXT_HTMLB_HED_SELALL"));
        allTexts.put("TXT_HTMLB_INSERTTABLEROW", this.getResource(pc, "TXT_HTMLB_INSERTTABLEROW"));
        allTexts.put("TXT_HTMLB_DELETETABLEROW", this.getResource(pc, "TXT_HTMLB_DELETETABLEROW"));
        allTexts.put("TXT_HTMLB_INSERTTABLECOL", this.getResource(pc, "TXT_HTMLB_INSERTTABLECOL"));
        allTexts.put("TXT_HTMLB_DELETETABLECOL", this.getResource(pc, "TXT_HTMLB_DELETETABLECOL"));
        allTexts.put("TXT_HTMLB_STYLESTANDARD", this.getResource(pc, "TXT_HTMLB_STYLESTANDARD"));
        allTexts.put("TXT_HTMLB_STYLEH1", this.getResource(pc, "TXT_HTMLB_STYLEH1"));
        allTexts.put("TXT_HTMLB_STYLEH2", this.getResource(pc, "TXT_HTMLB_STYLEH2"));
        allTexts.put("TXT_HTMLB_STYLEH3", this.getResource(pc, "TXT_HTMLB_STYLEH3"));
        allTexts.put("TXT_HTMLB_STYLEH4", this.getResource(pc, "TXT_HTMLB_STYLEH4"));
        allTexts.put("TXT_HTMLB_STYLEH5", this.getResource(pc, "TXT_HTMLB_STYLEH5"));
        allTexts.put("TXT_HTMLB_STYLEH6", this.getResource(pc, "TXT_HTMLB_STYLEH6"));
        allTexts.put("TXT_HTMLB_EMPHASIZED", this.getResource(pc, "TXT_HTMLB_EMPHASIZED"));
        allTexts.put("TXT_HTMLB_STANDARD", this.getResource(pc, "TXT_HTMLB_STANDARD"));
        allTexts.put("TXT_HTMLB_MONOSPACED", this.getResource(pc, "TXT_HTMLB_MONOSPACED"));
        allTexts.put("TXT_HTMLB_LEGEND", this.getResource(pc, "TXT_HTMLB_LEGEND"));
        allTexts.put("TXT_HTMLB_REFERENCE", this.getResource(pc, "TXT_HTMLB_REFERENCE"));
        allTexts.put("TXT_HTMLB_REQUIRED", this.getResource(pc, "TXT_HTMLB_REQUIRED"));
        allTexts.put("TXT_HTMLB_LARGE", this.getResource(pc, "TXT_HTMLB_LARGE"));
        allTexts.put("TXT_HTMLB_XLARGE", this.getResource(pc, "TXT_HTMLB_XLARGE"));
        allTexts.put("TXT_HTMLB_XXLARGE", this.getResource(pc, "TXT_HTMLB_XXLARGE"));
        allTexts.put("TXT_HTMLB_SMALL", this.getResource(pc, "TXT_HTMLB_SMALL"));
        allTexts.put("TXT_HTMLB_MEDIUM", this.getResource(pc, "TXT_HTMLB_MEDIUM"));
        allTexts.put("TXT_HTMLB_XSMALL", this.getResource(pc, "TXT_HTMLB_XSMALL"));
        allTexts.put("TXT_HTMLB_XXSMALL", this.getResource(pc, "TXT_HTMLB_XXSMALL"));
        allTexts.put("TXT_HTMLB_HED_SEL_IMG", this.getResource(pc, "TXT_HTMLB_HED_SEL_IMG"));
        allTexts.put("TXT_HTMLB_MG_CELL_RIGHT", this.getResource(pc, "TXT_HTMLB_MG_CELL_RIGHT"));
        allTexts.put("TXT_HTMLB_MG_CELL_LEFT", this.getResource(pc, "TXT_HTMLB_MG_CELL_LEFT"));
        allTexts.put("TXT_HTMLB_MG_CELL_UP", this.getResource(pc, "TXT_HTMLB_MG_CELL_UP"));
        allTexts.put("TXT_HTMLB_MG_CELL_DOWN", this.getResource(pc, "TXT_HTMLB_MG_CELL_DOWN"));
        allTexts.put("TXT_HTMLB_HED_BLANK", this.getResource(pc, "TXT_HTMLB_HED_BLANK"));
        allTexts.put("TXT_HTMLB_HED_PARENT", this.getResource(pc, "TXT_HTMLB_HED_PARENT"));
        allTexts.put("TXT_HTMLB_HED_SEARCH", this.getResource(pc, "TXT_HTMLB_HED_SEARCH"));
        allTexts.put("TXT_HTMLB_HED_SELF", this.getResource(pc, "TXT_HTMLB_HED_SELF"));
        allTexts.put("TXT_HTMLB_HED_TOP", this.getResource(pc, "TXT_HTMLB_HED_TOP"));
        allTexts.put("TXT_HTMLB_TARGET_WIN", this.getResource(pc, "TXT_HTMLB_TARGET_WIN"));
        allTexts.put("TXT_HTMLB_HED_SEL_CELL", this.getResource(pc, "TXT_HTMLB_HED_SEL_CELL"));
        allTexts.put("TXT_HTMLB_NOSTYLE", this.getResource(pc, "TXT_HTMLB_NOSTYLE"));
        allTexts.put("TXT_HTMLB_NOSIZE", this.getResource(pc, "TXT_HTMLB_NOSIZE"));
        allTexts.put("TXT_HTMLB_UNDO", this.getResource(pc, "TXT_HTMLB_UNDO"));
        allTexts.put("TXT_HTMLB_REDO", this.getResource(pc, "TXT_HTMLB_REDO"));
        allTexts.put("TXT_HTMLB_TXTALIGN", this.getResource(pc, "TXT_HTMLB_TXTALIGN"));
        allTexts.put("TXT_HTMLB_WHOLE_ROW", this.getResource(pc, "TXT_HTMLB_WHOLE_ROW"));
        allTexts.put("TXT_HTMLB_WHOLE_COL", this.getResource(pc, "TXT_HTMLB_WHOLE_COL"));
        allTexts.put("TXT_HTMLB_ALL_COLS", this.getResource(pc, "TXT_HTMLB_ALL_COLS"));
        allTexts.put("TXT_HTMLB_APPLYTO", this.getResource(pc, "TXT_HTMLB_APPLYTO"));
        allTexts.put("TXT_HTMLB_IMAGEPROP", this.getResource(pc, "TXT_HTMLB_IMAGEPROP"));
        allTexts.put("TXT_HTMLB_TABLEPROP", this.getResource(pc, "TXT_HTMLB_TABLEPROP"));
        allTexts.put("TXT_HTMLB_TABLECELLPROP", this.getResource(pc, "TXT_HTMLB_TABLECELLPROP"));
        allTexts.put("TXT_HTMLB_LINKPROP", this.getResource(pc, "TXT_HTMLB_LINKPROP"));
        allTexts.put("TXT_HTMLB_MODIFYTABLEPROP", this.getResource(pc, "TXT_HTMLB_MODIFYTABLEPROP"));
        allTexts.put("SAPUR_MENUBAR_WHOLE", this.getResource(pc, "SAPUR_MENUBAR_WHOLE"));
        allTexts.put("TXT_HTMLB_STYLE_TIMES", this.getResource(pc, "TXT_HTMLB_STYLE_TIMES"));
        allTexts.put("TXT_HTMLB_STYLE_COURIER", this.getResource(pc, "TXT_HTMLB_STYLE_COURIER"));
        allTexts.put("TXT_HTMLB_STYLE_TAHOMA", this.getResource(pc, "TXT_HTMLB_STYLE_TAHOMA"));
        allTexts.put("TXT_HTMLB_STYLE_GEORGIA", this.getResource(pc, "TXT_HTMLB_STYLE_GEORGIA"));
        allTexts.put("TXT_HTMLB_STYLE_IMPACT", this.getResource(pc, "TXT_HTMLB_STYLE_IMPACT"));
        allTexts.put("TXT_HTMLB_STYLE_TERMINAL", this.getResource(pc, "TXT_HTMLB_STYLE_TERMINAL"));
        allTexts.put("TXT_HTMLB_STYLE_ARIAL", this.getResource(pc, "TXT_HTMLB_STYLE_ARIAL"));
        allTexts.put("TXT_HTMLB_STYLE_ROMAN", this.getResource(pc, "TXT_HTMLB_STYLE_ROMAN"));
        Iterator allTextsIt = allTexts.keySet().iterator();
        StringBuffer jsVar = new StringBuffer("htmlb_hed_addTexts('" + pc.getLocale().toString() + "',{");
        while (allTextsIt.hasNext()) {
            String key = (String)allTextsIt.next();
            String value = (String)allTexts.get(key);
            if (value == null) {
                value = CLASS_IMAGELINK;
            }
            jsVar.append(key + ":\"" + RenderUtil.encodeForHtml(value, false) + "\"");
            if (!allTextsIt.hasNext()) continue;
            jsVar.append(",");
        }
        jsVar.append("});");
        jsVar.append("gDateformat='");
        SimpleDateFormat sdf = (SimpleDateFormat)TypeFormatter.getFormat(pc.getLocale(), DataType.DATE);
        String pattern = sdf.toPattern();
        jsVar.append(pattern.toString());
        jsVar.append("';htmlb_hed_initScreen('");
        jsVar.append(id);
        jsVar.append("','");
        jsVar.append(this.expanderId);
        jsVar.append("');");
        initStr = initStr + jsVar.toString();
        return initStr;
    }

    private void getStartLayout(StringBuffer b, HtmlEdit editComponent, String id) {
        b.append("<table width=\"");
        b.append(editComponent.getWidth());
        b.append("\" height=\"");
        b.append(editComponent.getHeight());
        b.append("\" cellpadding=0 cellspacing=0 unselectable=\"on\" border=0>");
    }

    private void writeBlank(StringBuffer b) {
        b.append("<TD>&nbsp;</TD>");
    }

    private void writeImage(StringBuffer b, String src, String alt) {
        b.append("<img src=\"");
        b.append(src);
        b.append("\" width=");
        b.append("12");
        b.append(" height=");
        b.append("12");
        b.append(" ");
        b.append(CLASS_IMAGELINK);
        b.append(" border=0 alt=\"");
        b.append(alt);
        b.append("\">");
    }

    private void writeAction(StringBuffer b, String id, IPageContext pc, String textResource, String command, String image, int tabIndex) {
        String alt = this.getResource(pc, textResource);
        b.append("<TD><A HREF=\"javascript:doSimpleAction('");
        b.append(id);
        b.append("',");
        b.append(command);
        b.append(");\"");
        if (tabIndex != 0) {
            b.append(" tabindex=\"0\"");
        }
        b.append(" id=\"");
        b.append(id);
        b.append("_tbr_");
        b.append(tabIndex);
        b.append("\"");
        b.append(" onKeyDown=\"editortoolbarswitch(this,'");
        b.append(this.str508SkipStartId);
        b.append("','");
        b.append(this.str508SkipEndId);
        b.append("')\" ");
        b.append("title=\"");
        b.append(alt);
        b.append("\">");
        this.writeImage(b, this.getImage(image), alt);
        b.append("</A></TD>");
    }

    private void writeActionWithDescription(StringBuffer b, String id, IPageContext pc, String accessibilityDescription, String command, String image, int tabIndex) {
        b.append("<TD><A HREF=\"javascript:doSimpleAction('");
        b.append(id);
        b.append("',");
        b.append(command);
        b.append(");\"");
        if (tabIndex != 0) {
            b.append(" tabindex=\"0\"");
        }
        b.append(" id=\"");
        b.append(id);
        b.append("_tbr_");
        b.append(tabIndex);
        b.append("\"");
        b.append(" onKeyDown=\"editortoolbarswitch(this,'");
        b.append(this.str508SkipStartId);
        b.append("','");
        b.append(this.str508SkipEndId);
        b.append("')\" ");
        b.append("title=\"");
        b.append(accessibilityDescription);
        b.append("\">");
        this.writeImage(b, this.getImage(image), accessibilityDescription);
        b.append("</A></TD>");
    }

    private void getPrint(StringBuffer b, String id, IPageContext pc, int t) {
        this.writeAction(b, id, pc, "TXT_HTMLB_PRINT", "cPRINT", IMG_PRINT, t);
    }

    private void getPreview(StringBuffer b, String id, IPageContext pc, int t) {
        this.str508SkipStartId = id;
        this.str508SkipStartId = this.str508SkipStartId + "_tbr_";
        this.str508SkipStartId = this.str508SkipStartId + t;
        if (pc.requiresSection508Rendering()) {
            if (this.accessibilityDescription.length() > 0) {
                this.writeActionWithDescription(b, id, pc, this.accessibilityDescription, "cPREVIEW", IMG_PREVIEW, t);
            } else {
                this.writeAction(b, id, pc, "TXT_HTMLB_EDITOR_SKIPSTART", "cPREVIEW", IMG_PREVIEW, t);
            }
        } else {
            this.writeAction(b, id, pc, "TXT_HTMLB_PREVIEW", "cPREVIEW", IMG_PREVIEW, t);
        }
    }

    private void getCutCopyPaste(StringBuffer b, String id, IPageContext pc, int t) {
        this.writeAction(b, id, pc, "TXT_HTMLB_CUT", "cCUT", IMG_CUT, t);
        this.writeAction(b, id, pc, "TXT_HTMLB_COPY", "cCOPY", IMG_COPY, t + 1);
        this.writeAction(b, id, pc, "TXT_HTMLB_PASTE", "cPASTE", IMG_PASTE, t + 2);
    }

    private void getBold(StringBuffer b, String id, IPageContext pc, int t) {
        this.writeAction(b, id, pc, "TXT_HTMLB_BOLD", "cBOLD", IMG_BOLD, t);
    }

    private void getItalic(StringBuffer b, String id, IPageContext pc, int t) {
        this.writeAction(b, id, pc, "TXT_HTMLB_ITALIC", "cITALIC", IMG_ITALIC, t);
    }

    private void getUnderline(StringBuffer b, String id, IPageContext pc, int t) {
        this.writeAction(b, id, pc, "TXT_HTMLB_UNDERLINE", "cUNDERLINE", IMG_UNDERLINE, t);
    }

    private void getList(StringBuffer b, String id, IPageContext pc, int t) {
        this.writeAction(b, id, pc, "TXT_HTMLB_BULLETLIST", "cPARABUL", IMG_LISTBULL, t);
        this.writeAction(b, id, pc, "TXT_HTMLB_NUMBEREDLIST", "cPARANUM", IMG_LISTNUM, t + 1);
    }

    private void getInOutdent(StringBuffer b, String id, IPageContext pc, int t) {
        this.writeAction(b, id, pc, "TXT_HTMLB_INDENT", "cINDENT", IMG_INDENT, t);
        this.writeAction(b, id, pc, "TXT_HTMLB_OUTDENT", "cOUTDENT", IMG_OUTDENT, t + 1);
    }

    private void getAlign(StringBuffer b, String id, IPageContext pc, int t) {
        this.writeAction(b, id, pc, "TXT_HTMLB_ALEFT", "cLEFT", IMG_ALIGNLEFT, t);
        this.writeAction(b, id, pc, "TXT_HTMLB_ACENTER", "cCENTER", IMG_ALIGNCENTER, t + 1);
        this.writeAction(b, id, pc, "TXT_HTMLB_ARIGHT", "cRIGHT", IMG_ALIGNRIGHT, t + 2);
    }

    private void getInsertRule(StringBuffer b, String id, IPageContext pc, int t) {
        this.writeAction(b, id, pc, "TXT_HTMLB_INSRULE", "cINSERTRULE", IMG_INSERTRULE, t);
    }

    private void getInsertImage(StringBuffer b, String id, HtmlEdit editComponent, IPageContext pc, int t) {
        String text = this.getResource(pc, "TXT_HTMLB_INSERTIMAGE");
        String txtImage = InsertImageEvent.renderEventCall(pc, editComponent);
        if (txtImage != null) {
            int semicolon;
            if (txtImage.startsWith("return ")) {
                txtImage = txtImage.substring(7);
            }
            if (txtImage != null && (semicolon = txtImage.indexOf(59, 0)) != 0) {
                txtImage = txtImage.substring(0, semicolon + 1);
            }
        }
        b.append("<TD><A HREF=\"javascript:if(insertImage('");
        b.append(id);
        b.append("')) {");
        b.append(txtImage);
        b.append("}\"");
        if (t != 0) {
            b.append(" tabindex=\"0\"");
        }
        b.append(" id=\"");
        b.append(id);
        b.append("_tbr_");
        b.append(t);
        b.append("\"");
        b.append(">");
        this.writeImage(b, this.getImage(IMG_IMAGEKM), text);
        b.append("</A></TD>");
    }

    private void getInsertLink(StringBuffer b, String id, HtmlEdit editComponent, IPageContext pc, int t) {
        String text = this.getResource(pc, "TXT_HTMLB_INSERTWEBLINK");
        String errortext = RenderUtil.encodeForJS(this.getResource(pc, "TXT_HTMLB_ERRORWEBLINK"));
        b.append("<TD><A HREF=\"javascript:doInsertWebLinkAction('");
        b.append(id);
        b.append("','");
        b.append(errortext);
        b.append("');\"");
        if (t != 0) {
            b.append(" tabindex=\"0\"");
        }
        b.append(" id=\"");
        b.append(id);
        b.append("_tbr_");
        b.append(t);
        b.append("\"");
        b.append(">");
        this.writeImage(b, this.getImage(IMG_LINKWEB), text);
        b.append("</A></TD>");
    }

    private void getInsertTable(StringBuffer b, String id, HtmlEdit editComponent, IPageContext pc, int t) {
        String text = this.getResource(pc, "TXT_HTMLB_INSERTTABLE");
        b.append("<TD><A HREF=\"javascript:doInsertTableAction('");
        b.append(id);
        b.append("');\"");
        if (t != 0) {
            b.append(" tabindex=\"0\"");
        }
        b.append(" id=\"");
        b.append(id);
        b.append("_tbr_");
        b.append(t);
        b.append("\"");
        b.append(" title=\"");
        b.append(text);
        b.append("\"");
        b.append(" onKeyDown=\"htmlb_hed_popup_openPopuMenu('");
        b.append(id);
        b.append("',this, event, 'insert_table') \"");
        b.append(">");
        this.writeImage(b, this.getImage(IMG_INSERTTABLE), text);
        b.append("</A></TD>");
    }

    private void getInsertSpecialChar(StringBuffer b, String id, IPageContext pc, int t) {
        String text = pc.requiresSection508Rendering() ? this.getResource(pc, "TXT_HTMLB_HED_INS_SC") + ". " + this.getResource(pc, "TXT_HTMLB_POPUP_OPEN") : this.getResource(pc, "TXT_HTMLB_HED_INS_SC");
        b.append("<TD>");
        b.append("<table><tr><td><span tabindex=\"0\" id=\"htmlb_hed_special_chars\" ct=\"PopupTrigger\" title class=\"urPopUpTrgWhl urPopUpTrgInd\" onClick=\"htmlb_hed_doInsertSpecialCharPopup('");
        b.append(id);
        b.append("',this,false)\" ");
        b.append(" onKeyDown=\"htmlb_hed_popup_openPopuMenu('");
        b.append(id);
        b.append("',this, event, 'insert_special_char') \"");
        b.append(" oncontextmenu=\"htmlb_hed_doInsertSpecialCharPopup('");
        b.append(id);
        b.append("',this,false)\">");
        this.writeImage(b, this.getImage(IMG_INSERTSPECIALCHAR), text);
        b.append("</td>");
        b.append("<td class=\"urTrcBdyRightPln\">");
        b.append("</td>");
        b.append("</tr></table>");
        b.append("</TD>");
    }

    private void getModifyTableProperties(StringBuffer b, String id, HtmlEdit editComponent, IPageContext pc, int t) {
        String text = this.getResource(pc, "TXT_HTMLB_MODIFYTABLEPROP");
        String errortext = RenderUtil.encodeForJS(this.getResource(pc, "TXT_HTMLB_ERRORMODIFYTABLE"));
        b.append("<TD><A HREF=\"javascript:doModifyTableAction('");
        b.append(id);
        b.append("','");
        b.append(errortext);
        b.append("');\"");
        b.append(" title=\"");
        b.append(text);
        b.append("\"");
        if (t != 0) {
            b.append(" tabindex=\"0\"");
        }
        b.append(" id=\"");
        b.append(id);
        b.append("_tbr_");
        b.append(t);
        b.append("\" ");
        b.append(" onKeyDown=\"htmlb_hed_popup_openPopuMenu('");
        b.append(id);
        b.append("',this, event, 'modify_table') \"");
        b.append(">");
        this.writeImage(b, this.getImage(IMG_MODIFYTABLEPROP), text);
        b.append("</A></TD>");
    }

    private void getInsertLinkKM(StringBuffer b, String id, HtmlEdit editComponent, IPageContext pc, int t) {
        String text = this.getResource(pc, "TXT_HTMLB_INSERTKMLINK");
        String txtLink = InsertLinkEvent.renderEventCall(pc, editComponent);
        if (txtLink != null && txtLink != CLASS_IMAGELINK) {
            int semicolon;
            if (txtLink.startsWith("return ")) {
                txtLink = txtLink.substring(7);
            }
            if (txtLink != null && (semicolon = txtLink.indexOf(59, 0)) != 0) {
                txtLink = txtLink.substring(0, semicolon + 1);
            }
            b.append("<TD><A HREF=\"javascript:if(insertLink ('");
            b.append(id);
            b.append("')){");
            b.append(txtLink);
            b.append("}\"");
            if (t != 0) {
                b.append(" tabindex=\"0\"");
            }
            b.append(" id=\"");
            b.append(id);
            b.append("_tbr_");
            b.append(t);
            b.append("\"");
            b.append(">");
            this.writeImage(b, this.getImage(IMG_LINKKM), text);
            b.append("</A></TD>");
        } else {
            String errortext = RenderUtil.encodeForJS(this.getResource(pc, "TXT_HTMLB_ERRORWEBLINK"));
            b.append("<TD><A HREF=\"javascript:doInsertWebLinkAction('");
            b.append(id);
            b.append("','");
            b.append(errortext);
            b.append("');\"");
            if (t != 0) {
                b.append(" tabindex=\"0\"");
            }
            b.append(" id=\"");
            b.append(id);
            b.append("_tbr_");
            b.append(t);
            b.append("\"");
            b.append(">");
            this.writeImage(b, this.getImage(IMG_LINKKM), text);
            b.append("</A></TD>");
        }
    }

    private void getStyle(StringBuffer b, String id, IPageContext pc) {
        String style = this.getResource(pc, "TXT_HTMLB_STYLE");
        String standard = this.getResource(pc, "TXT_HTMLB_STYLESTANDARD");
        String h1 = this.getResource(pc, "TXT_HTMLB_STYLEH1");
        String h2 = this.getResource(pc, "TXT_HTMLB_STYLEH2");
        String h3 = this.getResource(pc, "TXT_HTMLB_STYLEH3");
        String h4 = this.getResource(pc, "TXT_HTMLB_STYLEH4");
        String h5 = this.getResource(pc, "TXT_HTMLB_STYLEH5");
        String h6 = this.getResource(pc, "TXT_HTMLB_STYLEH6");
        b.append("<TD><select class=\"urDdlWhl\" id=\"style\" onChange=\"javascript:doComplexAction('");
        b.append(id);
        b.append("',cHX,this.value);this.selectedIndex=0;\"");
        if (pc.requiresSection508Rendering()) {
            b.append(" title=\"");
            b.append(style);
            b.append("\"");
        }
        b.append(">");
        b.append("<option value=\"NOP\">");
        b.append(style);
        b.append("</option><option value=\"<P>\">");
        b.append(standard);
        b.append("</option><option value=\"<H1>\">");
        b.append(h1);
        b.append("</option><option value=\"<H2>\">");
        b.append(h2);
        b.append("</option><option value=\"<H3>\">");
        b.append(h3);
        b.append("</option><option value=\"<H4>\">");
        b.append(h4);
        b.append("</option><option value=\"<H5>\">");
        b.append(h5);
        b.append("</option><option value=\"<H6>\">");
        b.append(h6);
        b.append("</option></select></TD>");
    }

    private void getTextsize(StringBuffer b, String id, IPageContext pc) {
        String size = this.getResource(pc, "TXT_HTMLB_SIZE");
        String medium = this.getResource(pc, "TXT_HTMLB_MEDIUM");
        String xxsmall = this.getResource(pc, "TXT_HTMLB_XXSMALL");
        String xsmall = this.getResource(pc, "TXT_HTMLB_XSMALL");
        String small = this.getResource(pc, "TXT_HTMLB_SMALL");
        String large = this.getResource(pc, "TXT_HTMLB_LARGE");
        String xlarge = this.getResource(pc, "TXT_HTMLB_XLARGE");
        String xxlarge = this.getResource(pc, "TXT_HTMLB_XXLARGE");
        b.append("<TD><select class=\"urDdlWhl\" id=\"textsize\" onChange=\"javascript:doComplexAction('");
        b.append(id);
        b.append("',cFONT_SIZE,this.value);this.selectedIndex=0;\"");
        if (pc.requiresSection508Rendering()) {
            b.append(" title=\"");
            b.append(size);
            b.append("\"");
        }
        b.append(">");
        b.append("<option value=\"NOP\">");
        b.append(size);
        b.append("</option><option value=\"4\">");
        b.append(medium);
        b.append("</option><option value=\"1\">");
        b.append(xxsmall);
        b.append("</option><option value=\"2\">");
        b.append(xsmall);
        b.append("</option><option value=\"3\">");
        b.append(small);
        b.append("</option><option value=\"5\">");
        b.append(large);
        b.append("</option><option value=\"6\">");
        b.append(xlarge);
        b.append("</option><option value=\"7\">");
        b.append(xxlarge);
        b.append("</option></select></TD>");
    }

    private void getEditorsize(StringBuffer b, String id, IPageContext pc) {
        String size = this.getResource(pc, "TXT_HTMLB_EDITOR_SIZE");
        String size400x300 = this.getResource(pc, "TXT_HTMLB_EDITOR_400_300");
        String size640x480 = this.getResource(pc, "TXT_HTMLB_EDITOR_640_480");
        String size800x600 = this.getResource(pc, "TXT_HTMLB_EDITOR_800_600");
        String size1024x768 = this.getResource(pc, "TXT_HTMLB_EDITOR_1024_768");
        b.append("<TD><select class=\"urDdlWhl\" id=\"textsize\" onChange=\"javascript:doResizeEditor('");
        b.append(id);
        b.append("',this.value);this.selectedIndex=0;\"");
        if (pc.requiresSection508Rendering()) {
            b.append(" title=\"");
            b.append(size);
            b.append("\"");
        }
        b.append(">");
        b.append("<option value=\"NOP\">");
        b.append(size);
        b.append("</option><option value=\"1\">");
        b.append(size400x300);
        b.append("</option><option value=\"2\">");
        b.append(size640x480);
        b.append("</option><option value=\"3\">");
        b.append(size800x600);
        b.append("</option><option value=\"4\">");
        b.append(size1024x768);
        b.append("</option></select></TD>");
    }

    private void getForeground(StringBuffer b, String id, IPageContext pc) {
        String foreground = this.getResource(pc, "TXT_HTMLB_FOREGROUND");
        String standard = this.getResource(pc, "TXT_HTMLB_COLORSTANDARD");
        String black = this.getResource(pc, "TXT_HTMLB_COLORBLACK");
        String white = this.getResource(pc, "TXT_HTMLB_COLORWHITE");
        String red = this.getResource(pc, "TXT_HTMLB_COLORRED");
        String green = this.getResource(pc, "TXT_HTMLB_COLORGREEN");
        String blue = this.getResource(pc, "TXT_HTMLB_COLORBLUE");
        String cyan = this.getResource(pc, "TXT_HTMLB_COLORCYAN");
        String magenta = this.getResource(pc, "TXT_HTMLB_COLORMAGENTA");
        String yellow = this.getResource(pc, "TXT_HTMLB_COLORYELLOW");
        Object returnText = null;
        b.append("<TD><select class=\"urDdlWhl\" id=\"forecolor\" onChange=\"javascript:doComplexAction('");
        b.append(id);
        b.append("',cFORE_COLOR,this.value);this.selectedIndex=0;\"");
        if (pc.requiresSection508Rendering()) {
            b.append(" title=\"");
            b.append(foreground);
            b.append("\"");
        }
        b.append(">");
        b.append("<option value=\"NOP\">");
        b.append(foreground);
        b.append("</option><option value=\"\">");
        b.append(standard);
        b.append("</option><option value=\"Black\">");
        b.append(black);
        b.append("</option><option value=\"White\">");
        b.append(white);
        b.append("</option><option value=\"Red\">");
        b.append(red);
        b.append("</option><option value=\"Green\">");
        b.append(green);
        b.append("</option><option value=\"Blue\">");
        b.append(blue);
        b.append("</option><option value=\"Cyan\">");
        b.append(cyan);
        b.append("</option><option value=\"Magenta\">");
        b.append(magenta);
        b.append("</option><option value=\"Yellow\">");
        b.append(yellow);
        b.append("</option></select></TD>");
    }

    private void getBackground(StringBuffer b, String id, IPageContext pc) {
        String background = this.getResource(pc, "TXT_HTMLB_BACKGROUND");
        String standard = this.getResource(pc, "TXT_HTMLB_COLORSTANDARD");
        String black = this.getResource(pc, "TXT_HTMLB_COLORBLACK");
        String white = this.getResource(pc, "TXT_HTMLB_COLORWHITE");
        String red = this.getResource(pc, "TXT_HTMLB_COLORRED");
        String green = this.getResource(pc, "TXT_HTMLB_COLORGREEN");
        String blue = this.getResource(pc, "TXT_HTMLB_COLORBLUE");
        String cyan = this.getResource(pc, "TXT_HTMLB_COLORCYAN");
        String magenta = this.getResource(pc, "TXT_HTMLB_COLORMAGENTA");
        String yellow = this.getResource(pc, "TXT_HTMLB_COLORYELLOW");
        b.append("<TD><select class=\"urDdlWhl\" id=\"backcolor\" onChange=\"javascript:doComplexAction('");
        b.append(id);
        b.append("',cBACK_COLOR,this.value);this.selectedIndex=0;\"");
        if (pc.requiresSection508Rendering()) {
            b.append(" title=\"");
            b.append(background);
            b.append("\"");
        }
        b.append(">");
        b.append("<option value=\"NOP\">");
        b.append(background);
        b.append("</option><option value=\"\">");
        b.append(standard);
        b.append("</option><option value=\"Black\">");
        b.append(black);
        b.append("</option><option value=\"White\">");
        b.append(white);
        b.append("</option><option value=\"Red\">");
        b.append(red);
        b.append("</option><option value=\"Green\">");
        b.append(green);
        b.append("</option><option value=\"Blue\">");
        b.append(blue);
        b.append("</option><option value=\"Cyan\">");
        b.append(cyan);
        b.append("</option><option value=\"Magenta\">");
        b.append(magenta);
        b.append("</option><option value=\"Yellow\">");
        b.append(yellow);
        b.append("</option></select></TD>");
    }

    private void getTableColorSelect(StringBuffer b, String id, IPageContext pc) {
        String errortext = RenderUtil.encodeForJS(this.getResource(pc, "TXT_HTMLB_TABLECOLORSELECT"));
        String background = this.getResource(pc, "TXT_HTMLB_TABLECOLOR");
        String standard = this.getResource(pc, "TXT_HTMLB_COLORSTANDARD");
        String black = this.getResource(pc, "TXT_HTMLB_COLORBLACK");
        String white = this.getResource(pc, "TXT_HTMLB_COLORWHITE");
        String red = this.getResource(pc, "TXT_HTMLB_COLORRED");
        String green = this.getResource(pc, "TXT_HTMLB_COLORGREEN");
        String blue = this.getResource(pc, "TXT_HTMLB_COLORBLUE");
        String cyan = this.getResource(pc, "TXT_HTMLB_COLORCYAN");
        String magenta = this.getResource(pc, "TXT_HTMLB_COLORMAGENTA");
        String yellow = this.getResource(pc, "TXT_HTMLB_COLORYELLOW");
        b.append("<TD><select class=\"urDdlWhl\" id=\"tablecolor\" onChange=\"javascript:doModifyTableColorAction('");
        b.append(id);
        b.append("',this.value");
        b.append(",'");
        b.append(errortext);
        b.append("');this.selectedIndex=0;\"");
        if (pc.requiresSection508Rendering()) {
            b.append(" title=\"");
            b.append(background);
            b.append("\"");
        }
        b.append(">");
        b.append("<option value=\"NOP\">");
        b.append(background);
        b.append("</option><option value=\"\">");
        b.append(standard);
        b.append("</option><option value=\"Black\">");
        b.append(black);
        b.append("</option><option value=\"White\">");
        b.append(white);
        b.append("</option><option value=\"Red\">");
        b.append(red);
        b.append("</option><option value=\"Green\">");
        b.append(green);
        b.append("</option><option value=\"Blue\">");
        b.append(blue);
        b.append("</option><option value=\"Cyan\">");
        b.append(cyan);
        b.append("</option><option value=\"Magenta\">");
        b.append(magenta);
        b.append("</option><option value=\"Yellow\">");
        b.append(yellow);
        b.append("</option></select></TD>");
    }

    private void getEndLayout(StringBuffer b, String id, HtmlEdit editComponent, IPageContext renderContext) {
        String width;
        String edtText = null;
        edtText = editComponent.getText();
        if (edtText == null || edtText.length() == 0) {
            edtText = CLASS_IMAGELINK;
        }
        if ((width = editComponent.getWidth()) != null && width != CLASS_IMAGELINK && width.indexOf("%") == -1) {
            width = "width:" + width + ";";
        }
        b.append("<tr class=\"urTbarWhl\" style=\"padding:1px 1px 1px 1px\"><td><div ");
        if (editComponent.getDoUsePortalStyle()) {
            b.append(CLASS_EDITAREA);
        } else {
            b.append(CLASS_EDITAREA_NO_STYLE);
        }
        b.append(" bgcolor=\"#FFFFFF\" style=\"position:relative;overflow:auto;height:100%;width:100%;");
        if (!editComponent.getDoUsePortalStyle()) {
            b.append("font-family:Times New Roman;");
        }
        b.append("background-color:#FFFFFF;border:none\" id=\"");
        b.append(id);
        b.append("htmlbeditor\" ");
        if (editComponent.isEditable()) {
            b.append("CONTENTEDITABLE=true ");
            b.append(" onbeforedeactivate=\"save('");
            b.append(id);
            b.append("');\"");
            b.append(" onclick=\"return htmlb_hed_hidePopupMenu(this);\" oncontextmenu=\"return htmlb_hed_launchContextMenu('");
            b.append(id);
            b.append("', this);\"");
            b.append(" onbeforeactivate=\"htmlb_hed_startupHandler('");
            b.append(id);
            b.append("',");
            if (editComponent.getDoUsePortalStyle()) {
                b.append("true");
            } else {
                b.append("false");
            }
            b.append(");\"");
        } else {
            b.append("CONTENTEDITABLE=false ");
        }
        if (renderContext.requiresSection508Rendering()) {
            String editorInputPaneDesc = editComponent.getAccessibilityInputPaneDescription();
            if (editorInputPaneDesc == null || editorInputPaneDesc == CLASS_IMAGELINK) {
                editorInputPaneDesc = this.getResource(renderContext, "TXT_HTMLB_EDITOR_INPUTPANE");
            }
            b.append(" title=\"");
            b.append(editorInputPaneDesc);
            b.append("\" tabindex=\"0\" ");
        }
        b.append(">");
        b.append(this.decodeContent(edtText, editComponent));
        b.append("</div></td></tr>");
        if (renderContext.requiresSection508Rendering() && editComponent.getDesignConfiguration() != HtmlEditDesign.NOTOOLBAR) {
            String skipEndText = this.getResource(renderContext, "TXT_HTMLB_EDITOR_SKIPEND");
            b.append("<span tabindex=\"1\" ti=\"0\" id=\"");
            b.append(this.str508SkipEndId);
            b.append("\" onKeyDown=\"sapUrMapi_skip('");
            b.append(this.str508SkipStartId);
            b.append("','");
            b.append(this.str508SkipEndId);
            b.append("',event);\" title=\"");
            b.append(skipEndText);
            b.append("\"></span>");
        }
        b.append("</table>");
        b.append("<script defer>");
        b.append(this.getInitMethod(id, editComponent, renderContext));
        b.append("</script><input type=\"hidden\" name=\"");
        b.append(id);
        b.append("\" value=\"\"><input type=\"hidden\" name=\"");
        b.append(id);
        b.append("_ADD\" value=\"\"><input type=\"hidden\" name=\"");
        b.append(id);
        b.append("_OLD\" value=\"\"><input type=\"hidden\" name=\"");
        b.append(id);
        b.append("_SCREEN\" value=\"");
        if (editComponent.getSelectedScreenSize() != null) {
            b.append(editComponent.getSelectedScreenSize());
        }
        b.append("\">");
        b.append("<input type=\"hidden\" name=\"");
        b.append(id);
        b.append("_OFFSET\" value=\"");
        b.append(editComponent.getHorizontalScrollPosition());
        b.append(",");
        b.append(editComponent.getVerticalScrollPosition());
        b.append("\">");
        b.append("<input type=\"hidden\" name=\"");
        b.append(id);
        b.append("_UNDO\" value=\"");
        b.append(editComponent.getUndoBuffer());
        b.append("\">");
        b.append("<input type=\"hidden\" name=\"");
        b.append(id);
        b.append("_REDO\" value=\"");
        b.append(editComponent.getRedoBuffer());
        b.append("\">");
        b.append("<input type=\"hidden\" name=\"");
        b.append(id);
        b.append("_EXPAND\" value=\"");
        b.append(editComponent.isExpandSize());
        b.append("\">");
        b.append("<input type=\"hidden\" name=\"");
        b.append(id);
        b.append("_USE_STYLE\" value=\"");
        b.append(editComponent.getDoUsePortalStyle());
        b.append("\">");
    }

    private String getImage(String image) {
        return Mimes.getMimeUrl(image);
    }

    private String doEncode(String input) {
        StringBuffer tmp = new StringBuffer(input.length());
        char c = '\u0000';
        int i = 0;
        while (i < input.length()) {
            c = input.charAt(i);
            switch (c) {
                case '\"': {
                    tmp.append("\\");
                    tmp.append(c);
                    break;
                }
                case '\'': {
                    tmp.append('\\');
                    tmp.append(c);
                    break;
                }
                default: {
                    tmp.append(c);
                }
            }
            ++i;
        }
        return tmp.toString();
    }

    private String decodeContent(String text, HtmlEdit editComponent) {
        int startPos;
        int endPos;
        int startPos2;
        if (text == null) {
            return null;
        }
        String content = text;
        String txtLink = "<A id=LINK_" + editComponent.getOldId();
        if (editComponent.getLinkURL() != null && editComponent.getLinkURL().length() > 0) {
            startPos2 = text.indexOf(txtLink);
            if (startPos2 >= 0 && (endPos = this.getClosingHREF(text, startPos2)) > 0) {
                content = text.substring(0, startPos2) + "<A HREF=" + editComponent.getLinkURL();
                content = content + " target=_blank";
                content = content + ">";
                if (text.substring(++endPos).indexOf("</A>") == 0) {
                    content = editComponent.getLinkText() != null && editComponent.getLinkText().length() > 0 ? content + editComponent.getLinkText() : content + editComponent.getLinkURL();
                }
                content = content + text.substring(endPos);
            }
        } else {
            String txtRest;
            int closeA;
            startPos2 = text.indexOf(txtLink);
            if (startPos2 >= 0 && (endPos = this.getClosingHREF(text, startPos2)) > 0 && (closeA = this.getClosingHREF(txtRest = text.substring(++endPos), 0)) > 0) {
                content = text.substring(0, startPos2) + txtRest.substring(0, ++closeA - 4) + txtRest.substring(closeA);
            }
        }
        String txtImage = "<IMG id=IMG_" + editComponent.getOldId();
        if (editComponent.getImageSrc() != null && editComponent.getImageSrc().length() > 0) {
            int endPos2;
            startPos = text.indexOf(txtImage);
            if (startPos >= 0 && (endPos2 = this.getClosingHREF(text, startPos)) > 0) {
                ++endPos2;
                content = text.substring(0, startPos) + "<IMG border=\"0\" SRC=" + editComponent.getImageSrc();
                if (editComponent.getImageHeight() != null && editComponent.getImageHeight().length() > 0) {
                    content = content + " height=" + "\"" + editComponent.getImageHeight() + "\"";
                }
                if (editComponent.getImageWidth() != null && editComponent.getImageWidth().length() > 0) {
                    content = content + " width=" + "\"" + editComponent.getImageWidth() + "\"";
                }
                if (editComponent.getImageTooltip() != null && editComponent.getImageTooltip().length() > 0) {
                    content = content + " alt=" + "\"" + editComponent.getImageTooltip() + "\"";
                }
                content = content + ">";
                content = content + text.substring(endPos2);
            }
        } else {
            int endPos3;
            startPos = text.indexOf(txtImage);
            if (startPos > 0 && (endPos3 = this.getClosingHREF(text, startPos)) > 0) {
                content = text.substring(0, startPos) + text.substring(endPos3 + 1);
            }
        }
        StringBuffer tmp = new StringBuffer(content.length());
        char c = '\u0000';
        int i = 0;
        while (i < content.length()) {
            c = content.charAt(i);
            switch (c) {
                case '\n': 
                case '\f': 
                case '\r': {
                    break;
                }
                default: {
                    tmp.append(c);
                }
            }
            ++i;
        }
        content = tmp.toString();
        return content;
    }

    /*
     * Unable to fully structure code
     */
    private int getClosingHREF(String text, int startPos) {
        doContinue = true;
        len = text.length();
        index = startPos;
        if (text != null && text.length() != 0) ** GOTO lbl11
        return 0;
lbl-1000:
        // 1 sources

        {
            if (index > len) {
                return 0;
            }
            if (text.charAt(index) == '>') {
                return index;
            }
            ++index;
lbl11:
            // 2 sources

            ** while (doContinue)
        }
lbl12:
        // 1 sources

        return 0;
    }

    private boolean doDisplayToolbarLine1(HtmlEdit editComponent) {
        return editComponent.getDoPreview() || editComponent.getDoPrint() || editComponent.getDoCutCopyPaste() || editComponent.getDoBold() || editComponent.getDoItalic() || editComponent.getDoUnderline() || editComponent.getDoStrikethrough() || editComponent.getDoSuperSubScript() || editComponent.getDoList() || editComponent.getDoInOutdent() || editComponent.getDoAlign() || editComponent.getDoLink() || editComponent.getDoImage();
    }

    private boolean doDisplayToolbarLine2(HtmlEdit editComponent) {
        return editComponent.getDoStyle() || editComponent.getDoTextsize() || editComponent.getDoForeground() || editComponent.getDoBackground();
    }

    private String getResource(IPageContext pageContext, String key) {
        try {
            return ResourceBundle.getBundle("com.sapportals.htmlb.Localization", pageContext.getLocale()).getString(key);
        }
        catch (Exception e) {
            Log.getLogLocation(false).debugT("DefaultHtmlEditRenderer", "getResource");
            return CLASS_IMAGELINK;
        }
    }

    private void getTextStyleMenu(StringBuffer b, String id, IPageContext pc, int t, boolean useStyle) {
        String tooltip = pc.requiresSection508Rendering() ? this.getResource(pc, "TXT_HTMLB_TXT_TXTSTYLE") + ". " + this.getResource(pc, "TXT_HTMLB_POPUP_OPEN") : this.getResource(pc, "TXT_HTMLB_TXT_TXTSTYLE");
        b.append("<TD>");
        b.append("<table><tr><td><span tabindex=\"0\" id=\"htmlb_hed_textstyle\" ct=\"PopupTrigger\" class=\"urPopUpTrgWhl urPopUpTrgInd\" ");
        if (useStyle) {
            b.append(" onKeyDown=\"htmlb_hed_popup_openPopuMenu('");
            b.append(id);
            b.append("',this, event, 'text_style') \"");
        } else {
            b.append(" onKeyDown=\"htmlb_hed_popup_openPopuMenu('");
            b.append(id);
            b.append("',this, event, 'text_no_portal_style') \"");
        }
        b.append(" title=\"");
        b.append(tooltip);
        b.append("\"");
        if (useStyle) {
            b.append(" onClick=\"htmlb_hed_doInsertTextStylePopup('");
            b.append(id);
            b.append("',this)\"");
            b.append(" oncontextmenu=\"htmlb_hed_doInsertTextStylePopup('");
            b.append(id);
            b.append("',this)\"");
        } else {
            b.append(" onClick=\"htmlb_hed_doInsertNoPortalTextStylePopup('");
            b.append(id);
            b.append("',this)\"");
            b.append(" oncontextmenu=\"htmlb_hed_doInsertNoPortalTextStylePopup('");
            b.append(id);
            b.append("',this)\"");
        }
        b.append(">");
        this.writeImage(b, this.getImage(IMG_TEXTCSS), tooltip);
        b.append("</td>");
        b.append("<td class=\"urTrcBdyRightPln\">");
        b.append("</td>");
        b.append("</tr></table>");
        b.append("</TD>");
    }

    private void getTextSizeMenu(StringBuffer b, String id, IPageContext pc, int t) {
        String tooltip = pc.requiresSection508Rendering() ? this.getResource(pc, "TXT_HTMLB_TXT_TXTSIZE") + ". " + this.getResource(pc, "TXT_HTMLB_POPUP_OPEN") : this.getResource(pc, "TXT_HTMLB_TXT_TXTSIZE");
        b.append("<TD>");
        b.append("<table><tr><td><span tabindex=\"0\" id=\"htmlb_hed_textsize\" ct=\"PopupTrigger\" title class=\"urPopUpTrgWhl urPopUpTrgInd\" onClick=\"htmlb_hed_doInsertTextSizePopup('");
        b.append(id);
        b.append("',this)\" ");
        b.append(" onKeyDown=\"htmlb_hed_popup_openPopuMenu('");
        b.append(id);
        b.append("',this, event,'text_size') \"");
        b.append(" title=\"");
        b.append(tooltip);
        b.append("\"");
        b.append(" oncontextmenu=\"htmlb_hed_doInsertTextSizePopup('");
        b.append(id);
        b.append("',this)\">");
        this.writeImage(b, this.getImage(IMG_TEXTSIZE), tooltip);
        b.append("</td>");
        b.append("<td class=\"urTrcBdyRightPln\">");
        b.append("</td>");
        b.append("</tr></table>");
        b.append("</TD>");
    }

    private void getTextForegroundColor(StringBuffer b, String id, IPageContext pc, int t) {
        String tooltip = pc.requiresSection508Rendering() ? this.getResource(pc, "TXT_HTMLB_TXT_FGCOLOR") + ". " + this.getResource(pc, "TXT_HTMLB_POPUP_OPEN") : this.getResource(pc, "TXT_HTMLB_TXT_FGCOLOR");
        b.append("<TD>");
        b.append("<table><tr><td><span tabindex=\"0\" id=\"htmlb_hed_textforegroundcolor\" ct=\"PopupTrigger\" title class=\"urPopUpTrgWhl urPopUpTrgInd\" onClick=\"htmlb_hed_doInsertTextForegroundColorPopup('");
        b.append(id);
        b.append("',this)\" ");
        b.append(" onKeyDown=\"htmlb_hed_popup_openPopuMenu('");
        b.append(id);
        b.append("',this, event, 'text_color') \"");
        b.append(" title=\"");
        b.append(tooltip);
        b.append("\"");
        b.append(" oncontextmenu=\"htmlb_hed_doInsertTextForegroundColorPopup('");
        b.append(id);
        b.append("',this)\">");
        this.writeImage(b, this.getImage(IMG_TEXTFGCOLOR), tooltip);
        b.append("</td>");
        b.append("<td class=\"urTrcBdyRightPln\">");
        b.append("</td>");
        b.append("</tr></table>");
        b.append("</TD>");
    }

    private void getTextBackgroundColor(StringBuffer b, String id, IPageContext pc, int t, boolean useStyle) {
        String tooltip = pc.requiresSection508Rendering() ? this.getResource(pc, "TXT_HTMLB_TXT_BGCOLOR") + ". " + this.getResource(pc, "TXT_HTMLB_POPUP_OPEN") : this.getResource(pc, "TXT_HTMLB_TXT_BGCOLOR");
        b.append("<TD>");
        b.append("<table><tr><td><span tabindex=\"0\" id=\"htmlb_hed_textbackgroundcolor\" ct=\"PopupTrigger\" title class=\"urPopUpTrgWhl urPopUpTrgInd\" onClick=\"htmlb_hed_doInsertTextBackgroundColorPopup('");
        b.append(id);
        b.append("',this,false)\" ");
        if (useStyle) {
            b.append(" onKeyDown=\"htmlb_hed_popup_openPopuMenu('");
            b.append(id);
            b.append("',this, event, 'text_backgroundcolor') \"");
        } else {
            b.append(" onKeyDown=\"htmlb_hed_popup_openPopuMenu('");
            b.append(id);
            b.append("',this, event, 'text_no_portal_backgroundcolor') \"");
        }
        b.append(" title=\"");
        b.append(tooltip);
        b.append("\"");
        if (useStyle) {
            b.append(" oncontextmenu=\"htmlb_hed_doInsertTextBackgroundColorPopup('");
            b.append(id);
            b.append("',this,false)\"");
        } else {
            b.append(" oncontextmenu=\"htmlb_hed_doInsertNoPortalTextBackgroundColorPopup('");
            b.append(id);
            b.append("',this,false)\"");
        }
        b.append(">");
        this.writeImage(b, this.getImage(IMG_TEXTBGCOLOR), tooltip);
        b.append("</td>");
        b.append("<td class=\"urTrcBdyRightPln\">");
        b.append("</td>");
        b.append("</tr></table>");
        b.append("</TD>");
    }
}

