/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Image;
import com.sapportals.htmlb.event.HoverItemClickEvent;
import com.sapportals.htmlb.hovermenu.HoverMenu;
import com.sapportals.htmlb.hovermenu.HoverMenuItem;
import com.sapportals.htmlb.rendering.AtomHtmlbRenderer;
import com.sapportals.htmlb.rendering.IHoverMenuRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import java.util.ArrayList;

public class DefaultHoverMenuRenderer
extends AtomHtmlbRenderer
implements IHoverMenuRenderer {
    public void render(Component component, IPageContext renderContext) {
        ArrayList subLevels = new ArrayList();
        int count = 1;
        boolean flag = false;
        if (component instanceof HoverMenu) {
            HoverMenu hoverMenu = (HoverMenu)component;
            String id = renderContext.getParamIdForComponent(hoverMenu);
            StringBuffer buffer = new StringBuffer();
            if (hoverMenu.getMenuItemCount() > 0) {
                buffer.append("<div id=\"");
                buffer.append(id);
                if (hoverMenu.hasRootComponent() || !hoverMenu.isFirstLevelVisible()) {
                    buffer.append("\"");
                    buffer.append("style=\"left:0;top:100px; position:absolute;visibility:hidden");
                    flag = true;
                }
                buffer.append("\">");
                this.renderHoverMenu(null, hoverMenu, buffer, subLevels, renderContext, count, 1, flag);
                buffer.append("</div>");
                ++count;
                while (!subLevels.isEmpty()) {
                    HoverMenuWithLevel pair = (HoverMenuWithLevel)subLevels.remove(0);
                    HoverMenu subHoverMenu = pair.getMenu();
                    String subMenuId = subHoverMenu.getParentItem().getParentMenu().getId() + "List" + subHoverMenu.getId();
                    buffer.append("<div id=\"");
                    buffer.append(subMenuId);
                    buffer.append("\" style=\"left:0;top:100px;position:absolute;visibility:hidden;\">");
                    this.renderHoverMenu(hoverMenu, subHoverMenu, buffer, subLevels, renderContext, count, pair.getLevel(), flag);
                    buffer.append("</div>");
                    ++count;
                }
                renderContext.write(buffer.toString());
            }
        }
    }

    public void renderHoverMenu(HoverMenu parent, HoverMenu hoverMenu, StringBuffer buffer, ArrayList subLevels, IPageContext renderContext, int count1, int level, boolean flag) {
        buffer.append("<table id=\"");
        if (parent == null) {
            buffer.append(hoverMenu.getId() + "Table" + count1);
        } else {
            buffer.append(parent.getId() + "List" + hoverMenu.getId() + "Table" + count1);
        }
        buffer.append("\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100\" class=\"sapDropDwnWhl\"><tbody>");
        int count = hoverMenu.getMenuItemCount();
        int i = 0;
        while (i < count) {
            HoverMenuItem item = hoverMenu.getMenuItemAt(i);
            if (item.hasHoverItemDivider() && i != 0) {
                buffer.append("<tr><td nowrap colspan=\"2\"><div class=\"sapDropDwnDivider\">&nbsp;</div></td></tr>");
            }
            if (item.isEnabled()) {
                buffer.append("<tr class=\"sapDropDwnRow\">");
            } else {
                buffer.append("<tr class=\"sapDropDwnRowDsbl\">");
            }
            String imgSrc = item.getImgSrc();
            if (imgSrc != null && !imgSrc.equals("")) {
                String disabledImgSrc;
                buffer.append("<td class=\"sapDropDwnIcon\" align=\"right\" onMouseOver=\"parent.htmlbHoverItem(this);\">");
                String imageAltText = item.getAltTextForImage();
                if (imageAltText == null) {
                    imageAltText = "";
                }
                Image img = new Image(imgSrc, imageAltText);
                if (!item.isEnabled() && (disabledImgSrc = item.getDisabledImgSrc()) != null && !disabledImgSrc.equals("")) {
                    img = new Image(disabledImgSrc, imageAltText);
                }
                buffer.append(img.renderAsString(renderContext));
                buffer.append("</td>");
            } else {
                buffer.append("<td>&nbsp;</td>");
            }
            buffer.append("<td nowrap id=\"");
            buffer.append(item.getId());
            buffer.append("\" colspan=\"");
            buffer.append("\"");
            if (item.getSubMenu() == null) {
                if (item.getLinkReference() != null) {
                    if (!item.isEnabled()) {
                        buffer.append(" class=\"sapDropDwnItemDsbl\"");
                    } else {
                        buffer.append(" class=\"sapDropDwnItem\" style=\"cursor:Hand;\" onMouseOver=\"parent.htmlbHoverItem(this)\" onClick=\"window.open('");
                        buffer.append(item.getLinkReference());
                        buffer.append("', ");
                        if (item.getLinkTarget() != null) {
                            buffer.append("'");
                            buffer.append(item.getLinkTarget());
                            buffer.append("')\"");
                        } else {
                            buffer.append("'_top')\"");
                        }
                    }
                    buffer.append(">");
                    buffer.append(item.getText());
                } else if (item.getClientSideScript() != null) {
                    String clientSideScript = item.getClientSideScript();
                    buffer.append(" class=\"sapDropDwnItem\" style=\"cursor:Hand;\" onMouseOver=\"parent.htmlbHoverItem(this)\" onClick=\"");
                    buffer.append(clientSideScript);
                    if (clientSideScript.charAt(clientSideScript.length() - 1) != ';') {
                        buffer.append(";");
                    }
                    buffer.append("parent.htmlbHideAllMenus();");
                    buffer.append("\">");
                    buffer.append(item.getText());
                } else if (!item.isEnabled() || !hoverMenu.requiresForm()) {
                    buffer.append(" class=\"sapDropDwnItemDsbl\">");
                    buffer.append(item.getText());
                } else {
                    if (!flag) {
                        if (level == 1) {
                            buffer.append(" class=\"sapDropDwnItem\" onMouseOver=\"htmlbHoverStandAloneItem(this)\"");
                        } else {
                            buffer.append(" class=\"sapDropDwnItem\" onMouseOver=\"parent.htmlbHoverItem(this)\"");
                        }
                    } else {
                        buffer.append(" class=\"sapDropDwnItem\" onMouseOver=\"parent.htmlbHoverItem(this)\"");
                    }
                    if (hoverMenu.requiresForm()) {
                        buffer.append(" onClick=\"");
                        buffer.append(HoverItemClickEvent.renderEventCall(renderContext, hoverMenu, item));
                    }
                    buffer.append("\">");
                    buffer.append(item.getText());
                }
            } else if (!item.isEnabled()) {
                buffer.append(" class=\"sapDropDwnCascItemDsbl\">");
                buffer.append(item.getText());
            } else {
                String subMenuId;
                HoverMenu subMenu = item.getSubMenu();
                if (!flag) {
                    if (level == 1) {
                        buffer.append(" class=\"sapDropDwnCascItem\" onMouseOver=\"htmlbHoverStandAloneItem(this,'");
                        subMenuId = hoverMenu.getId() + "List" + subMenu.getId();
                        buffer.append(subMenuId);
                        buffer.append("');window.event.cancelBubble = true;");
                    } else {
                        buffer.append(" class=\"sapDropDwnCascItem\" onMouseOver=\"parent.htmlbHoverItem(this);parent.htmlbShowMenu('");
                        subMenuId = hoverMenu.getId() + "List" + subMenu.getId();
                        buffer.append(subMenuId);
                        buffer.append("',this,'");
                        buffer.append(level);
                        buffer.append("')");
                    }
                } else {
                    buffer.append(" class=\"sapDropDwnCascItem\" onMouseOver=\"parent.htmlbHoverItem(this);parent.htmlbShowMenu('");
                    subMenuId = hoverMenu.getId() + "List" + subMenu.getId();
                    buffer.append(subMenuId);
                    buffer.append("',this,'");
                    buffer.append(level + 1);
                    buffer.append("')");
                }
                buffer.append("\">");
                buffer.append(item.getText());
                subLevels.add(new HoverMenuWithLevel(subMenu, level + 1));
            }
            buffer.append("</td></tr>");
            ++i;
        }
        buffer.append("</tbody></table>");
    }

    class HoverMenuWithLevel {
        private HoverMenu menu;
        private int level;

        public HoverMenuWithLevel(HoverMenu menu, int level) {
            this.menu = menu;
            this.level = level;
        }

        public HoverMenu getMenu() {
            return this.menu;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

