/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.Button;
import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Form;
import com.sapportals.htmlb.IJavascriptComponent;
import com.sapportals.htmlb.JavascriptFragment;
import com.sapportals.htmlb.MessageBar;
import com.sapportals.htmlb.enum.MessageType;
import com.sapportals.htmlb.hovermenu.HoverMenu;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IFormRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.statusicons.Mimes;
import com.sapportals.htmlb.util.Log;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.TreeMap;

public class DefaultFormRenderer
implements HtmlbRenderer,
IFormRenderer {
    public void render(Component component, int selector, IPageContext renderContext) {
        if (component instanceof Form) {
            Form myForm = (Form)component;
            switch (selector) {
                case 0: {
                    this.renderBegin(myForm, renderContext);
                    this.renderParameterFields(myForm, renderContext);
                    break;
                }
                case 1: {
                    this.renderEnd(myForm, renderContext);
                }
            }
        }
    }

    public void render(Component component, IPageContext renderContext) {
        if (component instanceof Form) {
            Form myForm = (Form)component;
            this.renderBegin(myForm, renderContext);
            this.renderParameterFields(myForm, renderContext);
            RenderUtil.renderContainerContent(myForm, renderContext);
            this.renderHoverMenus(myForm, renderContext);
            this.renderEnd(myForm, renderContext);
        }
    }

    public void renderBegin(Form form, IPageContext renderContext) {
        String myId;
        String waitText = "Please Wait";
        String requestString = "Your request is being processed";
        ResourceBundle messages = renderContext.getResourceBundle("com.sapportals.htmlb.Localization", renderContext.getLocale());
        if (messages != null) {
            try {
                waitText = messages.getString("TXT_HTMLB_WAIT");
                requestString = messages.getString("TXT_HTMLB_REQUEST");
            }
            catch (Exception e) {
                Log.getLogLocation(false).debugT("DefaultFormRenderer", "renderBegin: no bundle texts");
            }
        }
        if (form.isLoadingMessage()) {
            renderContext.write("<div id=\"htmlb_wait\" style=\"z-index:99; display:none; visibility:hidden; left:0px; top:0px; width:0px; height:0px; position:absolute; overflow:hidden;\">");
            renderContext.write("<table width=\"200\" cellspacing=\"0\" cellpadding=\"2\" border=\"0\">");
            renderContext.write("<tr><td nowrap class=\"urCellBgBorder\"><table width=\"200\" border=\"0\" cellpadding=\"2\" cellspacing=\"0\"><tr><td colspan=\"2\" nowrap class=\"urCellBgHeader urTxtH3\">");
            renderContext.write(waitText);
            renderContext.write("</td></tr><tr><td  class=\"urCellBgFill3\" width=\"25\" height=\"50\" align=\"right\" valign=\"middle\" nowrap><img src=\"");
            renderContext.write(Mimes.getMimeUrl("GEN_WAIT"));
            renderContext.write("\" border=\"0\" alt=\"");
            renderContext.write(waitText);
            renderContext.write("\" title=\"");
            renderContext.write(waitText);
            renderContext.write("\"></td><td valign=\"middle\" nowrap class=\"urCellBgFill3 urTxtStd\">");
            renderContext.write(requestString);
            renderContext.write("</td></tr></table></td></tr></table></div>");
        }
        renderContext.setCurrentForm(form);
        renderContext.write("<form style=\"margin:0px 0px 0px 0px;\" name=\"");
        String value = myId = renderContext.getCurrentFormId();
        if (value != null) {
            renderContext.write(value);
            renderContext.write("\" id=\"");
            renderContext.write(value);
        }
        if ((value = form.getMethod()) != null) {
            renderContext.write("\" method=\"");
            renderContext.write(value);
        }
        if ((value = form.getAction()) == null) {
            value = renderContext.getActionUrl();
        }
        if (value != null) {
            renderContext.write("\" action=\"");
            renderContext.write(RenderUtil.encodeForTagParam(value));
        }
        if ((value = form.getTarget()) != null) {
            renderContext.write("\" target=\"");
            renderContext.write(value);
        }
        if ((value = form.getEncodingType()) != null) {
            renderContext.write("\" enctype=\"");
            renderContext.write(value);
        }
        if ((value = form.getLanguage()) != null) {
            renderContext.write("\" lang=\"");
            renderContext.write(value);
        }
        if (myId != null) {
            renderContext.write("\" onsubmit=\"return htmlbCheckSubmit('");
            renderContext.write(myId);
            renderContext.write("');");
        }
        renderContext.write("\" ondragover=\"htmlbFormDragOver()");
        renderContext.write("\" ondragleave=\"htmlbFormDragLeave()");
        renderContext.write("\">");
        renderContext.write("<SCRIPT language=\"JavaScript\" defer>");
        renderContext.write("htmlb_formid = '" + renderContext.getCurrentFormId() + "';");
        MessageBar messageBar = form.getMessageBar();
        if (form.isMessageBarRequired()) {
            renderContext.write("var htmlb_messageBarId = '" + renderContext.getParamIdForComponent(messageBar) + "';");
        }
        renderContext.write("</SCRIPT>");
        if (form.isWidthInHundredPercent() || form.isHeightInHundredPercent()) {
            renderContext.write("<Table border=\"0\"");
            if (form.isWidthInHundredPercent()) {
                renderContext.write(" width=\"100%\"");
            }
            if (form.isHeightInHundredPercent()) {
                renderContext.write(" height=\"100%\"");
            }
            renderContext.write("><TR><TD>");
        }
        if (!form.isMessageBarAtFormEnd() && form.isMessageBarRequired() && !form.isUserDefinedMessageBar()) {
            renderContext.render(messageBar);
            if (messageBar.getMessageType() != null && messageBar.getMessageType() != MessageType.NONE) {
                form.setFocusedControl(messageBar);
            }
        }
    }

    protected void renderParameterFields(Form form, IPageContext pc) {
        String id = pc.getCurrentFormId();
        pc.write("<input type=\"hidden\" name=\"htmlbevt_ty\">");
        pc.write("<input type=\"hidden\" name=\"htmlbdoc_id\" value=\"");
        pc.write(pc.getDocument().getDocumentId());
        pc.write("\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_frm\" value=\"");
        pc.write(id);
        pc.write("\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_oid\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_id\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_cnt\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_par1\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_par2\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_par3\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_par4\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_par5\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_par6\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_par7\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_par8\">");
        pc.write("<input type=\"hidden\" name=\"htmlbevt_par9\">");
        pc.write("<input type=\"hidden\" name =\"htmlbScrollX\">");
        pc.write("<input type=\"hidden\" name =\"htmlbScrollY\">");
        pc.write("<input type=\"hidden\" name=\"htmlbValueHelpFieldId\" value=\"");
        pc.writeEncoded(pc.getParameter("htmlbValueHelpFieldId"));
        pc.write("\">");
        pc.write("<input type=\"hidden\" name =\"htmlbJavaScriptPath\" value=\"");
        pc.write(pc.getJavascriptPath());
        pc.write("\">");
        pc.write("<input type=\"submit\" name=\"htmlb_submit\" tabindex=\"-1\" style=\"position:absolute;top:-1;width:0;height:0;\" onClick=\"return htmlbCheckSubmit('");
        pc.write(id);
        pc.write("');\">");
        if (pc.isUsingSession()) {
            pc.storeParametersInSession(id);
            pc.write("<input type=\"hidden\" name=\"htmlb_sid\" value=\"");
            pc.write(id);
            pc.write("\">");
        }
    }

    private void renderHoverMenus(Form form, IPageContext pc) {
        HashSet hoverMenus = form.getHoverMenus();
        if (hoverMenus != null) {
            Iterator hoverIt = hoverMenus.iterator();
            while (hoverIt.hasNext()) {
                HoverMenu menu = (HoverMenu)hoverIt.next();
                pc.render(menu);
            }
        }
    }

    public void renderEnd(Form form, IPageContext pc) {
        String formId = pc.getCurrentFormId();
        if (form.isHeightInHundredPercent() || form.isWidthInHundredPercent()) {
            pc.write("</TD></TR></TABLE>");
        }
        this.renderEncodedElements(form, pc);
        Button defaultButton = form.getDefaultButton();
        if (defaultButton != null) {
            pc.write("<input type=\"hidden\" id=\"");
            pc.write(formId);
            pc.write("_dflt\" code=\"");
            pc.write(pc.getParamIdForComponent(defaultButton));
            pc.write("\">");
        }
        pc.write("<input type=\"hidden\" id=\"");
        pc.write(formId);
        pc.write("_complete\" code=\"OK\">");
        if (pc.getCurrentForm().isScrollingToLastPosition()) {
            String htmlbScrollY;
            pc.write("<script defer>");
            String htmlbScrollX = pc.getParameter("htmlbScrollX");
            int xPos = 0;
            int yPos = 0;
            if (htmlbScrollX != null && !htmlbScrollX.equals("")) {
                xPos = Integer.parseInt(htmlbScrollX);
            }
            if ((htmlbScrollY = pc.getParameter("htmlbScrollY")) != null && !htmlbScrollY.equals("")) {
                yPos = Integer.parseInt(htmlbScrollY);
            }
            pc.write("window.scrollTo(" + xPos + "," + yPos + ")");
            pc.write("</script>");
        }
        this.renderScrollContainerList(pc, form);
        pc.write("<script defer>sapUrMapi_initLinkStatus()</script>");
        MessageBar messageBar = form.getMessageBar();
        if (form.isMessageBarAtFormEnd() && form.isMessageBarRequired() && !form.isUserDefinedMessageBar()) {
            pc.render(form.getMessageBar());
            if (messageBar.getMessageType() != null && messageBar.getMessageType() != MessageType.NONE) {
                form.setFocusedControl(messageBar);
            }
        }
        if (form.getFocusedControl() != null) {
            pc.write("<script defer>");
            pc.write("sapUrMapi_Create_AddItem(\"htmlb\",\"sapUrMapi_focusElement('" + pc.getParamIdForComponent(form.getFocusedControl()) + "')\");");
            pc.write("</script>");
        } else if (pc.getIs508()) {
            pc.write("<script defer>");
            pc.write("htmlb_focusFirstElement('");
            pc.write(formId);
            pc.write("');");
            pc.write("</script>");
        }
        pc.write("</form>");
        this.renderJavascripts(form, pc);
        pc.setCurrentForm(null);
    }

    public void renderEncodedElements(Form form, IPageContext pc) {
        String formId = pc.getCurrentFormId();
        String encodedString = form.encodeFormElements();
        if (encodedString != null) {
            int len = encodedString.length();
            int numPerLine = 120;
            if (!pc.isUsingSession()) {
                int i = 0;
                while (i < len) {
                    pc.write("<input type=\"hidden\" name=\"htmlbfrm_");
                    pc.write(formId);
                    pc.write("_");
                    pc.write(i / numPerLine);
                    pc.write("\" value=\"");
                    String substring = encodedString.substring(i, i + numPerLine > len ? len : i + numPerLine);
                    pc.write(substring);
                    pc.write("\">");
                    i += numPerLine;
                }
            } else {
                String id = "htmlbfrm_" + formId + "_0";
                pc.getParamList().put(id, encodedString);
            }
        }
    }

    public String getEncodedElements(IPageContext pc) {
        String formId = pc.getParameter("htmlbevt_frm");
        if (formId != null) {
            String paramValue;
            StringBuffer sb = new StringBuffer();
            String paramName = "htmlbfrm_" + formId + "_";
            int i = 0;
            do {
                if ((paramValue = pc.getParameter(paramName + Integer.toString(i))) != null) {
                    sb.append(paramValue);
                }
                ++i;
            } while (paramValue != null);
            return sb.toString();
        }
        return null;
    }

    public void renderJavascripts(Form form, IPageContext pc) {
        ArrayList javascripts;
        String formId = pc.getCurrentFormId();
        HashMap<String, String> jsComponents = new HashMap<String, String>();
        Form f = form;
        TreeMap<String, Component> reverseMap = f.getForceJavascriptInterface();
        if (reverseMap == null) {
            reverseMap = new TreeMap<String, Component>();
        }
        if (form.isMessageBarRequired()) {
            MessageBar mb = form.getMessageBar();
            String mbgenid = pc.getParamIdForComponent(mb);
            jsComponents.put(mb.getId(), mbgenid);
            reverseMap.put(mbgenid, mb);
        }
        if ((javascripts = f.getFormEndJavascripts()) == null && reverseMap == null) {
            return;
        }
        pc.write("<script defer>");
        if (javascripts != null) {
            Iterator it = ((AbstractList)javascripts).iterator();
            while (it.hasNext()) {
                JavascriptFragment js = (JavascriptFragment)it.next();
                Component component = js.getComponent();
                if (component == null) {
                    jsComponents.put("this", "_");
                } else {
                    String newid = js.getGeneratedId();
                    jsComponents.put("this", newid);
                    jsComponents.put(component.getId(), newid);
                    reverseMap.put(newid, component);
                }
                String codeFragment = js.getJavascript();
                int length = codeFragment.length();
                int i = 0;
                while (i < length) {
                    int k;
                    char c = codeFragment.charAt(i);
                    switch (c) {
                        case '\"': 
                        case '\'': {
                            k = length;
                            while (++i < k) {
                                if (codeFragment.charAt(i) == c) {
                                    k = ++i;
                                    continue;
                                }
                                if (codeFragment.charAt(i) != '\\') continue;
                                ++i;
                            }
                            break;
                        }
                        default: {
                            if (!Character.isJavaIdentifierStart(c)) {
                                k = i + 1;
                                break;
                            }
                            k = i + 1;
                            while (k < length && Character.isJavaIdentifierPart(codeFragment.charAt(k))) {
                                ++k;
                            }
                            String id = codeFragment.substring(i, k);
                            String newid = null;
                            if (k < length && codeFragment.charAt(k) == '(') {
                                newid = "_";
                            } else {
                                newid = (String)jsComponents.get(id);
                                if (newid == null) {
                                    newid = "_";
                                    Component comp = form.getComponentById(id);
                                    if (comp != null) {
                                        try {
                                            IJavascriptComponent jsComponent = (IJavascriptComponent)((Object)comp);
                                            newid = pc.getParamIdForComponent(comp);
                                            reverseMap.put(newid, comp);
                                        }
                                        catch (Exception ex) {
                                            Log.getLogLocation(false).debugT("DefaultFormRenderer", "renderJavascripts");
                                        }
                                    }
                                    jsComponents.put(id, newid);
                                }
                            }
                            if (newid.equals("_")) break;
                            String newFragment = codeFragment.substring(0, i) + newid;
                            i = newFragment.length();
                            codeFragment = newFragment + codeFragment.substring(k);
                            length = codeFragment.length();
                            k = i;
                        }
                    }
                    i = k;
                }
                pc.write(codeFragment);
            }
            f.clearFormEndJavascripts();
            f.clearForceJavascriptInterface();
        }
        HashMap forcedEnabledElement = f.getForcedEnabledElement();
        Iterator it = reverseMap.keySet().iterator();
        while (it.hasNext()) {
            String generatedId = (String)it.next();
            IJavascriptComponent jsComponent = (IJavascriptComponent)reverseMap.get(generatedId);
            jsComponent.renderJavascriptInterface(pc, generatedId);
            if (forcedEnabledElement.get(generatedId) == null) continue;
            pc.write(generatedId + ".setDisabled();");
        }
        this.renderFullIdElements(pc, f);
        pc.write("</script>");
    }

    public void renderFullIdElements(IPageContext pc, Form form) {
        StringBuffer buffer = new StringBuffer();
        HashMap fullIdFormElements = form.getFullIdFormElements();
        if (!fullIdFormElements.isEmpty()) {
            buffer.append("var ");
            String formId = pc.getCurrentFormId();
            buffer.append(formId);
            buffer.append("_htmlbElements = new Array();");
            Iterator keys = fullIdFormElements.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = (String)fullIdFormElements.get(key);
                buffer.append(formId);
                buffer.append("_htmlbElements['");
                buffer.append(RenderUtil.encodeForJS(key));
                buffer.append("']='");
                buffer.append(RenderUtil.encodeForJS(value));
                buffer.append("';");
            }
            buffer.append("function ");
            buffer.append(formId);
            buffer.append("_getHtmlbElementId(componentId){");
            buffer.append("return ");
            buffer.append(formId);
            buffer.append("_htmlbElements[componentId];");
            buffer.append("}");
        }
        pc.write(buffer.toString());
    }

    private void renderScrollContainerList(IPageContext pc, Form form) {
        HashSet set = form.getScrollContainerSet();
        if (set != null) {
            pc.write("<script defer>");
            pc.write("var ");
            String formId = pc.getCurrentFormId();
            pc.write(formId);
            pc.write("_htmlbSC=new Array();");
            Iterator ids = set.iterator();
            int i = 0;
            while (ids.hasNext()) {
                String id = (String)ids.next();
                pc.write(formId);
                pc.write("_htmlbSC[");
                pc.write(i++);
                pc.write("]='");
                pc.write(id);
                pc.write("';");
            }
            pc.write("</script>");
        }
    }
}

