/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.FormLayout;
import com.sapportals.htmlb.FormLayoutCell;
import com.sapportals.htmlb.FormLayoutRow;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;

public class DefaultFormLayoutRenderer
implements HtmlbRenderer {
    public void render(Component component, int selector, IPageContext renderContext) {
        if (component instanceof FormLayout) {
            FormLayout formLayout = (FormLayout)component;
            FormLayoutCell cell = null;
            switch (selector) {
                case 0: {
                    formLayout.setCurrentColumnIndex(0);
                    formLayout.setCurrentRowIndex(0);
                    this.renderFormBegin(formLayout, renderContext);
                    break;
                }
                case 6: {
                    this.renderFormEnd(formLayout, renderContext);
                    break;
                }
                case 1: {
                    formLayout.setCurrentColumnIndex(0);
                    int currentRowIndex = formLayout.getCurrentRowIndex() + 1;
                    formLayout.setCurrentRowIndex(currentRowIndex);
                    this.renderRowBegin(formLayout, formLayout.getRow(currentRowIndex), renderContext);
                    break;
                }
                case 5: {
                    int currentRowIndex = formLayout.getCurrentRowIndex();
                    this.renderRowEnd(formLayout, formLayout.getRow(currentRowIndex), renderContext);
                    break;
                }
                case 2: {
                    int currentColumnIndex = formLayout.getCurrentColumnIndex() + 1;
                    formLayout.setCurrentColumnIndex(currentColumnIndex);
                    int currentRowIndex = formLayout.getCurrentRowIndex();
                    cell = formLayout.getRow(currentRowIndex).getCell(currentColumnIndex);
                    this.renderCellBegin(formLayout, cell, renderContext);
                    break;
                }
                case 4: {
                    int currentColumnIndex = formLayout.getCurrentColumnIndex();
                    int currentRowIndex = formLayout.getCurrentRowIndex();
                    cell = formLayout.getRow(currentRowIndex).getCell(currentColumnIndex);
                    this.renderCellEnd(formLayout, cell, renderContext);
                    break;
                }
                case 3: {
                    int currentColumnIndex = formLayout.getCurrentColumnIndex();
                    int currentRowIndex = formLayout.getCurrentRowIndex();
                    cell = formLayout.getRow(currentRowIndex).getCell(currentColumnIndex);
                    this.renderCellContent(formLayout, cell, renderContext);
                }
            }
        }
    }

    public void render(Component component, IPageContext renderContext) {
        if (component instanceof FormLayout) {
            int colSpan = 1;
            FormLayout formLayout = (FormLayout)component;
            Object[] rows = formLayout.getRows();
            this.renderFormBegin(formLayout, renderContext);
            int rowIndex = 0;
            while (rowIndex < rows.length) {
                FormLayoutRow row = null;
                row = (FormLayoutRow)rows[rowIndex];
                this.renderRowBegin(formLayout, row, renderContext);
                Object[] cells = row.getCells();
                int columnIndex = 0;
                while (columnIndex < cells.length) {
                    FormLayoutCell cell = null;
                    if (cells[columnIndex] instanceof FormLayoutCell) {
                        cell = (FormLayoutCell)cells[columnIndex];
                        if (cell.getWidth() == null && formLayout.getColumnCount() == columnIndex + 1) {
                            cell.setWidth("100%");
                        }
                        this.renderCellBegin(formLayout, cell, renderContext);
                        this.renderCellContent(formLayout, cell, renderContext);
                        this.renderCellEnd(formLayout, cell, renderContext);
                        if (cell != null && (colSpan = cell.getColspan()) > 1) {
                            columnIndex += --colSpan;
                        }
                    }
                    ++columnIndex;
                }
                if (rowIndex >= 0 && row.getPaddingBottom() == null) {
                    row.setPaddingBottom("5px");
                }
                this.renderRowEnd(formLayout, row, renderContext);
                ++rowIndex;
            }
            this.renderFormEnd(formLayout, renderContext);
        }
    }

    public void renderFormBegin(FormLayout formLayout, IPageContext renderContext) {
        renderContext.write("<table cellpadding=\"0\" cellspacing=\"0\"");
        if (formLayout.isDebugMode()) {
            renderContext.write(" border=\"1\"");
        }
        String width = formLayout.getWidth();
        renderContext.write(" style=\"");
        if (width != null) {
            renderContext.write("width:" + width + ";");
        }
        if (formLayout.isDebugMode()) {
            renderContext.write("border:1 solid black;background-color:red;");
        }
        renderContext.write("margin:");
        renderContext.write(formLayout.getMarginTop() + " ");
        renderContext.write(formLayout.getMarginRight() + " ");
        renderContext.write(formLayout.getMarginBottom() + " ");
        renderContext.write(formLayout.getMarginLeft() + ";\">");
    }

    public void renderFormEnd(FormLayout Form2, IPageContext renderContext) {
        renderContext.write("</table>");
    }

    public void renderRowBegin(FormLayout Form2, FormLayoutRow formLayoutRow, IPageContext renderContext) {
        if (formLayoutRow.getPaddingTop() != null) {
            renderContext.write("<tr style=\"height:");
            renderContext.write(formLayoutRow.getPaddingTop() + ";\">");
            renderContext.write("</tr>");
        }
        renderContext.write("<tr>");
    }

    public void renderRowEnd(FormLayout Form2, FormLayoutRow formLayoutRow, IPageContext renderContext) {
        renderContext.write("</tr>");
        if (formLayoutRow.getPaddingBottom() != null) {
            renderContext.write("<tr style=\"height:");
            renderContext.write(formLayoutRow.getPaddingBottom() + ";\">");
            renderContext.write("</tr>");
        }
    }

    public void renderCellBegin(FormLayout Form2, FormLayoutCell formLayoutCell, IPageContext renderContext) {
        renderContext.write("<td");
        if (formLayoutCell != null) {
            if (formLayoutCell.getColspan() > 1) {
                renderContext.write(" colspan=\"" + String.valueOf(formLayoutCell.getColspan()) + "\" ");
            }
            if (formLayoutCell.getRowspan() > 1) {
                renderContext.write(" rowspan=\"" + String.valueOf(formLayoutCell.getRowspan()) + "\" ");
            }
            if (formLayoutCell.getHorizontalAlignment() != null) {
                renderContext.write(" align=\"" + formLayoutCell.getHorizontalAlignment() + "\" ");
            }
            if (formLayoutCell.getVerticalAlignment() != null) {
                renderContext.write(" valign=\"" + formLayoutCell.getVerticalAlignment() + "\" ");
            }
            String width = formLayoutCell.getWidth();
            String paddingTop = formLayoutCell.getPaddingTop();
            String paddingLeft = formLayoutCell.getPaddingLeft();
            String paddingRight = formLayoutCell.getPaddingRight();
            String paddingBottom = formLayoutCell.getPaddingBottom();
            if (width != null || paddingTop != null || paddingLeft != null || paddingRight != null || paddingBottom != null) {
                renderContext.write(" style=\"");
                if (paddingTop != null || paddingLeft != null || paddingRight != null || paddingBottom != null) {
                    if (paddingTop == null) {
                        paddingTop = "0px";
                    }
                    if (paddingRight == null) {
                        paddingRight = "0px";
                    }
                    if (paddingLeft == null) {
                        paddingLeft = "0px";
                    }
                    if (paddingBottom == null) {
                        paddingBottom = "0px";
                    }
                    renderContext.write("padding:");
                    renderContext.write(paddingTop + " ");
                    renderContext.write(paddingRight + " ");
                    renderContext.write(paddingBottom + " ");
                    renderContext.write(paddingLeft + ";");
                }
                if (width != null) {
                    renderContext.write("width:" + width + ";");
                }
                renderContext.write("\"");
            }
        }
        renderContext.write(">");
    }

    public void renderCellEnd(FormLayout Form2, FormLayoutCell cell, IPageContext renderContext) {
        renderContext.write("</td>");
    }

    public void renderCellContent(FormLayout Form2, FormLayoutCell cell, IPageContext renderContext) {
        if (cell != null) {
            Object object = cell.getContent();
            if (object != null) {
                if (object instanceof String) {
                    String cellString = (String)object;
                    renderContext.write(cellString);
                }
                if (object instanceof Component) {
                    Component cellComponent = (Component)object;
                    cellComponent.render(renderContext);
                }
            } else {
                RenderUtil.renderContainerContent(cell, renderContext);
            }
        }
    }
}

