/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Form;
import com.sapportals.htmlb.event.EventModifierData;
import com.sapportals.htmlb.event.IEventModifier;
import com.sapportals.htmlb.rendering.IEventRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import java.util.ArrayList;

public class DefaultEventRenderer
implements IEventRenderer {
    public String renderEventCall(IPageContext pc, Class eventClass, String eventType, Component c, String serverEvent, String clientEvent, boolean validateControl, boolean validateForm, boolean defaultReturn, Object[] params) {
        String paramString = null;
        int n = 0;
        if (params != null) {
            n = params.length;
            paramString = this.constructParamString(params);
        }
        return this.renderEventCall(pc, eventClass, eventType, c, serverEvent, clientEvent, validateControl, validateForm, defaultReturn, n, paramString);
    }

    public String getBrowserSpecificEventParameters(IPageContext pc) {
        return "this";
    }

    public String renderEventCall(IPageContext pc, Class eventClass, String eventType, Component c, String serverEvent, String clientEvent, boolean validateControl, boolean validateForm, boolean defaultReturn, int paramCount, String paramString) {
        String modifierID;
        StringBuffer result = new StringBuffer(100);
        result.append("return htmlbDoEvent(");
        result.append(this.getBrowserSpecificEventParameters(pc));
        result.append(",'");
        if ("".equals(serverEvent)) {
            serverEvent = null;
        }
        if ("".equals(clientEvent)) {
            clientEvent = null;
        }
        if (defaultReturn) {
            result.append("T");
        }
        if (clientEvent != null) {
            result.append("C");
        }
        if (validateControl) {
            result.append("V");
        }
        if (serverEvent != null) {
            if (validateForm) {
                result.append("S");
            } else {
                result.append("X");
            }
        }
        result.append("','");
        result.append(eventType == null ? "_dflt" : eventType);
        result.append("','");
        Form currentForm = pc.getCurrentForm();
        if (currentForm == null) {
            throw new IllegalStateException("Using an event firing component without a form:" + c.getClass().getName() + ":" + c.getId());
        }
        String eventModifier = this.setUpModifierData(currentForm);
        if (eventModifier != null) {
            result.append("*");
        }
        result.append(currentForm.getIdForEvent(eventClass.getName()));
        result.append("','");
        result.append(pc.getCurrentFormId());
        result.append("',");
        IEventModifier myEventModifier = pc.getCurrentForm().getCurrentEventModifier();
        if (eventModifier != null) {
            modifierID = ((Component)((Object)myEventModifier)).getId();
            int internalId = currentForm.registerFormElement(c, modifierID + "_" + c.getId());
            result.append(internalId);
        } else {
            result.append(currentForm.getIndexOfElement(c));
        }
        result.append(',');
        result.append(currentForm.getIdForEvent(serverEvent));
        result.append(',');
        if (myEventModifier != null) {
            modifierID = ((Component)((Object)myEventModifier)).getId();
            result.append("'");
            result.append(myEventModifier.getComponentIdModifier());
            result.append("',");
        } else {
            result.append("'',");
        }
        int n = paramCount;
        if (eventModifier != null) {
            result.append(paramCount + 1);
            result.append(",'");
            result.append(eventModifier);
            result.append('\'');
        } else {
            result.append(n);
        }
        if (paramString != null) {
            result.append(paramString);
        }
        result.append(");");
        return result.toString();
    }

    protected String constructParamString(Object[] params) {
        if (params != null) {
            StringBuffer result = new StringBuffer(30);
            int i = 0;
            while (i < params.length) {
                result.append(",'");
                result.append(params[i]);
                result.append('\'');
                ++i;
            }
            return result.toString();
        }
        return "";
    }

    protected String setUpModifierData(Form currentForm) {
        int n;
        ArrayList modifierStack = currentForm.getEventModifier();
        int n2 = n = modifierStack == null ? 0 : modifierStack.size();
        if (n > 0) {
            StringBuffer result = new StringBuffer();
            do {
                IEventModifier mod = (IEventModifier)modifierStack.get(--n);
                EventModifierData modData = mod.getEventModifierData();
                int internalId = currentForm.getIndexOfElement((Component)((Object)mod));
                result.append(Integer.toString(internalId));
                result.append(':');
                if (modData != null) {
                    result.append(Integer.toString(currentForm.getIdForClass(modData.getClass())));
                    result.append(':');
                    result.append(modData.getDataAsString());
                } else {
                    result.append(':');
                }
                if (n <= 0) continue;
                result.append(':');
            } while (n > 0);
            return result.toString();
        }
        return null;
    }
}

