/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Document;
import com.sapportals.htmlb.enum.BrowserType;
import com.sapportals.htmlb.hovermenu.HoverMenu;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.unifiedrendering.ie5.FocusRectRenderer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DefaultDocumentRenderer
implements HtmlbRenderer {
    public void render(Component component, int selector, IPageContext renderContext) {
        if (component instanceof Document) {
            Document myDocument = (Document)component;
            switch (selector) {
                case 0: {
                    this.renderBegin(myDocument, renderContext);
                    break;
                }
                case 1: {
                    this.renderEnd(myDocument, renderContext);
                    break;
                }
                case 5: {
                    this.renderDocBegin(myDocument, renderContext);
                    break;
                }
                case 6: {
                    this.renderDocEnd(myDocument, renderContext);
                    break;
                }
                case 7: {
                    this.renderHeadBegin(myDocument, renderContext);
                    break;
                }
                case 8: {
                    this.renderHeadEnd(myDocument, renderContext);
                    break;
                }
                case 9: {
                    this.renderBodyBegin(myDocument, renderContext);
                    break;
                }
                case 10: {
                    this.renderBodyEnd(myDocument, renderContext);
                    break;
                }
                case 11: {
                    this.renderHead(myDocument, renderContext);
                    break;
                }
                case 12: {
                    this.renderDocType(myDocument, renderContext);
                }
            }
        }
    }

    public void render(Component component, IPageContext renderContext) {
        if (component instanceof Document) {
            Document myDocument = (Document)component;
            this.renderBegin(myDocument, renderContext);
            this.renderFocusRect(renderContext);
            RenderUtil.renderContainerContent(myDocument, renderContext);
            this.renderHoverMenus(myDocument, renderContext);
            this.renderClientTexts(myDocument, renderContext);
            renderContext.registerStylesheet("ur_fc");
            this.renderEnd(myDocument, renderContext);
        }
    }

    public void renderDocType(Document document, IPageContext rc) {
    }

    public void renderBegin(Document document, IPageContext rc) {
        rc.startDocument();
        rc.startDocumentHead(document.getTitle());
        rc.writeHeadIncludes();
        String rawHeadText = document.getHeadRawText();
        if (rawHeadText != null) {
            rc.writeHeadBegin(rawHeadText);
        }
        rc.endDocumentHead();
        rc.startDocumentBody();
    }

    public void renderEnd(Document document, IPageContext rc) {
        rc.endDocumentBody();
        rc.endDocument();
    }

    public void renderDocBegin(Document document, IPageContext pc) {
        pc.startDocument();
    }

    public void renderDocEnd(Document document, IPageContext pc) {
        pc.endDocument();
    }

    public void renderHeadBegin(Document document, IPageContext pc) {
        String myTitle = document.getTitle();
        pc.startDocumentHead(myTitle);
    }

    public void renderHeadEnd(Document document, IPageContext pc) {
        pc.endDocumentHead();
    }

    public void renderHead(Document document, IPageContext rc) {
        rc.startDocumentHead(document.getTitle());
        rc.writeHeadIncludes();
        String rawHeadText = document.getHeadRawText();
        if (rawHeadText != null) {
            rc.write(rawHeadText);
        }
        rc.endDocumentHead();
    }

    public void renderBodyBegin(Document document, IPageContext pc) {
        pc.startDocumentBody();
        this.renderFocusRect(pc);
    }

    public void renderBodyEnd(Document document, IPageContext pc) {
        this.renderHoverMenus(document, pc);
        this.renderClientTexts(document, pc);
        pc.endDocumentBody();
    }

    private void renderHoverMenus(Document document, IPageContext pc) {
        HashSet hoverMenus = document.getHoverMenus();
        if (hoverMenus != null) {
            Iterator hoverIt = hoverMenus.iterator();
            while (hoverIt.hasNext()) {
                HoverMenu menu = (HoverMenu)hoverIt.next();
                pc.render(menu);
            }
        }
    }

    private void renderClientTexts(Document document, IPageContext pc) {
        ResourceBundle messages = ResourceBundle.getBundle("com.sapportals.htmlb.Localization", pc.getLocale());
        document.registerStandardText("SAPUR_SEPARATOR");
        document.registerStandardText("SAPUR_DISABLED");
        document.registerStandardText("SAPUR_INVALID");
        document.registerStandardText("SAPUR_READOLNY");
        document.registerStandardText("SAPUR_REQUIRED");
        document.registerStandardText("SAPUR_EXPANDED");
        document.registerStandardText("SAPUR_COLLAPSED");
        document.registerStandardText("SAPUR_ENTERTAB");
        document.registerStandardText("SAPUR_MULTIPLESELECTION");
        document.registerStandardText("SAPUR_SINGLESELECTION");
        document.registerStandardText("SAPUR_SELECTED");
        document.registerStandardText("SAPUR_NOTSELECTED");
        document.registerStandardText("SAPUR_WHL1");
        document.registerStandardText("SAPUR_WHL2");
        document.registerStandardText("SAPUR_WHL3");
        document.registerStandardText("SAPUR_BLANK");
        document.registerStandardText("SAPUR_SELECT");
        document.registerStandardText("SAPUR_UNSELECT");
        document.registerStandardText("SAPUR_SKIPSTART");
        document.registerStandardText("SAPUR_SKIPEND_WHL");
        document.registerStandardText("SAPUR_SKIPEND_RETURN");
        document.registerStandardText("SAPUR_SKIP");
        document.registerStandardText("SAPUR_TODAY");
        document.registerStandardText("SAPUR_BADVALUE");
        document.registerStandardText("SAPUR_CRITICALVALUE");
        document.registerStandardText("SAPUR_GOODVALUE");
        document.registerStandardText("SAPUR_KEY");
        document.registerStandardText("SAPUR_NEGATIVE");
        document.registerStandardText("SAPUR_POSITIVE");
        document.registerStandardText("SAPUR_SUBTOTAL");
        document.registerStandardText("SAPUR_TOTAL");
        document.registerStandardText("SAPUR_STANDARD");
        document.registerStandardText("SAPUR_DATATIP_KEY");
        HashSet allTexts = document.getStandardTexts();
        if (pc.requiresSection508Rendering() && document.get508Texts() != null) {
            if (allTexts != null && document.get508Texts() != null) {
                allTexts.addAll(document.get508Texts());
            } else {
                allTexts = document.get508Texts();
            }
        }
        if (allTexts != null) {
            pc.write("<script>");
            Iterator allTextsIt = allTexts.iterator();
            StringBuffer jsVar = new StringBuffer("htmlb_addTexts('" + pc.getLocale().toString() + "',{");
            while (allTextsIt.hasNext()) {
                String value;
                String key = (String)allTextsIt.next();
                try {
                    value = messages.getString(key);
                }
                catch (MissingResourceException ex) {
                    value = "";
                }
                jsVar.append(key + ":\"" + RenderUtil.encodeForHtml(value, true) + "\"");
                if (!allTextsIt.hasNext()) continue;
                jsVar.append(",");
            }
            jsVar.append("});");
            pc.write(jsVar.toString());
            pc.write("</script>");
        }
    }

    private void renderFocusRect(IPageContext pc) {
        if (pc.getBrowserId().equals(BrowserType.MSIE6)) {
            new FocusRectRenderer().render(null, pc);
        }
    }
}

