/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.DateNavigator;
import com.sapportals.htmlb.enum.BrowserType;
import com.sapportals.htmlb.event.DateNavigatorDayClickEvent;
import com.sapportals.htmlb.event.DateNavigatorMonthClickEvent;
import com.sapportals.htmlb.event.DateNavigatorNavigationEvent;
import com.sapportals.htmlb.event.DateNavigatorWeekClickEvent;
import com.sapportals.htmlb.rendering.AtomHtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DefaultDateNavigatorRenderer
extends AtomHtmlbRenderer {
    private static int WEEKDAY_LENGTH = 2;

    protected String getSelectionClass(int selectionMode) {
        switch (selectionMode) {
            case 1: {
                return "urCalDayIt1Emp";
            }
            case 2: {
                return "urCalDayIt2Emp";
            }
            case 3: {
                return "urCalDayIt3Emp";
            }
            case 4: {
                return "urCalDayIt4Emp";
            }
            case 0: {
                return "urCalDaySelNot";
            }
        }
        return "urCalDayIt1Emp";
    }

    public void render(Component component, IPageContext rc) {
        if (component instanceof DateNavigator) {
            DateNavigator dnav = (DateNavigator)component;
            if (dnav.getModel().isLocaleUnknown()) {
                dnav.setLocale(rc.getLocale());
            }
            if (dnav.getSelectedDays() != null && dnav.getSelectedDays().isLocaleUnknown()) {
                dnav.getSelectedDays().setLocale(rc.getLocale());
            }
            Calendar calendar = dnav.getCalendar();
            calendar.setTime(dnav.getToday());
            int year = dnav.getCenteredYear() == null ? calendar.get(1) : dnav.getCenteredYear().intValue();
            int month = dnav.getCenteredMonth() == null ? calendar.get(2) : dnav.getCenteredMonth().intValue();
            int monthCount = dnav.getMonthsPerColumn() * dnav.getMonthsPerRow();
            int monthsBack = (monthCount + 1) / 2 - 1;
            calendar.set(year, month, 1);
            calendar.add(2, -monthsBack);
            int curYear = calendar.get(1);
            int curMonth = calendar.get(2);
            rc.write("<table border=\"0\"cellspacing=\"0\"cellpadding=\"0\"class=\"urGrcWhl\">");
            rc.write("<tr><td>");
            String function = null;
            if (dnav.getOnDayClick() != null) {
                rc.write(DateNavigatorDayClickEvent.renderJSFunction(rc, dnav));
                function = DateNavigatorDayClickEvent.getJSFunctionName(rc, dnav);
            }
            rc.write("<div class=\"urCalWhl");
            if (function != null) {
                rc.write("\" onMousedown=\"");
                rc.write(function);
                BrowserType bt = rc.getBrowserId();
                if (bt == BrowserType.NETSCAPE_6) {
                    rc.write("(event);");
                } else {
                    rc.write("();");
                }
            }
            rc.write("\"><table cellspacing=\"0\" cellpadding=\"2\" border=\"0\">");
            int rows = 0;
            while (rows < dnav.getMonthsPerColumn()) {
                rc.write("<tr>");
                int columns = 0;
                while (columns < dnav.getMonthsPerRow()) {
                    rc.write("<td valign=\"top\">");
                    boolean prevNav = false;
                    if (dnav.getOnNavigate() != null && rows == 0 && columns == 0) {
                        prevNav = true;
                    }
                    boolean nextNav = false;
                    if (dnav.getOnNavigate() != null && rows == 0 && columns == dnav.getMonthsPerRow() - 1) {
                        nextNav = true;
                    }
                    this.renderMonth(dnav, calendar, curYear, curMonth, prevNav, nextNav, rc);
                    rc.write("</td>");
                    calendar.set(curYear, curMonth, 1);
                    calendar.add(2, 1);
                    curYear = calendar.get(1);
                    curMonth = calendar.get(2);
                    ++columns;
                }
                rc.write("</tr>");
                ++rows;
            }
            rc.write("</table></div></tr></td></table>");
        }
    }

    public void renderMonth(DateNavigator dnav, Calendar calendar, int year, int month, boolean previousNavigation, boolean nextNavigation, IPageContext rc) {
        int firstDayOfWeek = calendar.getFirstDayOfWeek();
        calendar.set(year, month, 1, 0, 0, 0);
        calendar.set(14, 0);
        int firstDayOfMonth = calendar.get(7);
        SimpleDateFormat formatterMonth = new SimpleDateFormat("MMMMM", dnav.getLocale());
        String monthName = formatterMonth.format(calendar.getTime());
        calendar.add(2, 1);
        int nextMonth = calendar.get(2);
        calendar.add(2, -1);
        int preDays = firstDayOfMonth - firstDayOfWeek;
        if (preDays < 0) {
            preDays += 7;
        }
        calendar.add(5, -preDays);
        SimpleDateFormat formatterWeekday = new SimpleDateFormat("EE", dnav.getLocale());
        Date startDate = calendar.getTime();
        Date curDate = new Date(startDate.getTime());
        int curWeek = calendar.get(3);
        int curMonth = calendar.get(2);
        int curYear = calendar.get(1);
        rc.write("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tr><td>");
        rc.write("<table cellspacing=\"1\" cellpadding=\"0\" border=\"0\"><tr><td></td><td class=\"urCalArr\">");
        if (previousNavigation) {
            rc.write("<span onClick=\"");
            rc.write(DateNavigatorNavigationEvent.renderEventCall(rc, dnav, "previous"));
            rc.write("\">&nbsp;&laquo;&laquo;</span>");
        }
        rc.write("</td><td colspan=\"5\" align=\"center\" class=\"urCalHdr\"><span onClick=\"");
        if (dnav.getOnMonthClick() != null) {
            rc.write(DateNavigatorMonthClickEvent.renderEventCall(rc, dnav, year, month));
        }
        rc.write("\">");
        rc.write(monthName);
        rc.write(" ");
        rc.write(year);
        rc.write("</span></td><td class=\"urCalArr\">");
        if (nextNavigation) {
            rc.write("<span onClick=\"");
            rc.write(DateNavigatorNavigationEvent.renderEventCall(rc, dnav, "next"));
            rc.write("\">&nbsp;&raquo;&raquo;</span>");
        }
        rc.write("</td></tr><tr valign=\"middle\"><td></td>");
        int i = 0;
        while (i < 7) {
            String weekday = formatterWeekday.format(calendar.getTime());
            rc.write("<td class=\"urCalName\">");
            rc.write(DefaultDateNavigatorRenderer.formatWeekday(weekday));
            rc.write("</td>");
            calendar.add(5, 1);
            ++i;
        }
        calendar.setTime(startDate);
        int lines = 0;
        while (lines < 6) {
            curMonth = calendar.get(2);
            calendar.add(5, 6);
            curWeek = calendar.get(3);
            calendar.add(5, -6);
            curYear = calendar.get(1);
            if (curMonth != nextMonth) {
                rc.write("<tr class=\"urCalRow\"><td class=\"urCalNum\"><span onClick=\"");
                if (dnav.getOnWeekClick() != null) {
                    rc.write(DateNavigatorWeekClickEvent.renderEventCall(rc, dnav, curYear, curWeek));
                }
                rc.write("\">");
                rc.write(curWeek);
                rc.write("</span></td>");
                int i2 = 0;
                while (i2 < 7) {
                    int day = calendar.get(5);
                    curYear = calendar.get(1);
                    String dayID = DefaultDateNavigatorRenderer.formatDayId(curYear, curMonth, day);
                    String tooltip = null;
                    int selectionMode = -1;
                    if (dnav.getSelectedDays() != null) {
                        tooltip = dnav.getSelectedDays().getTooltip(calendar.getTime());
                        selectionMode = dnav.getSelectedDays().getSelectionMode(calendar.getTime());
                    }
                    Object txtClass = null;
                    rc.write("<td id=\"");
                    rc.write(dayID);
                    if (tooltip != null) {
                        rc.write("\" title=\"");
                        rc.writeEncoded(tooltip);
                    }
                    if (selectionMode != -1) {
                        if (curMonth != month) {
                            rc.write("\" class=\"urCalIna");
                        } else if (calendar.getTime().equals(dnav.getToday())) {
                            rc.write("\" class=\"urCalTod");
                        } else {
                            rc.write("\" class=\"");
                            rc.write(this.getSelectionClass(selectionMode));
                        }
                    } else if (curMonth != month) {
                        rc.write("\" class=\"urCalIna");
                    } else if (calendar.getTime().equals(dnav.getToday())) {
                        rc.write("\" class=\"urCalTod");
                    }
                    rc.write("\">");
                    rc.write(day);
                    rc.write("</td>");
                    calendar.add(5, 1);
                    curMonth = calendar.get(2);
                    ++i2;
                }
                rc.write("</tr>");
            }
            ++lines;
        }
        rc.write("</table></td></tr></table>");
    }

    /*
     * Unable to fully structure code
     */
    public static String formatWeekday(String weekday) {
        if (weekday.length() <= DefaultDateNavigatorRenderer.WEEKDAY_LENGTH) ** GOTO lbl4
        return weekday.substring(0, DefaultDateNavigatorRenderer.WEEKDAY_LENGTH);
lbl-1000:
        // 1 sources

        {
            weekday = weekday + " ";
lbl4:
            // 2 sources

            ** while (weekday.length() < DefaultDateNavigatorRenderer.WEEKDAY_LENGTH)
        }
lbl5:
        // 1 sources

        return weekday;
    }

    public static String formatDayId(int year, int month, int day) {
        int m2 = month + 1;
        StringBuffer result = new StringBuffer(8);
        if (year < 1000) {
            result.append('0');
        }
        if (year < 100) {
            result.append('0');
        }
        if (year < 10) {
            result.append('0');
        }
        result.append(year);
        if (m2 < 10) {
            result.append('0');
        }
        result.append(m2);
        if (day < 10) {
            result.append('0');
        }
        result.append(day);
        return result.toString();
    }
}

