/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.ClientEventContainer;
import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class DefaultClientEventContainerRenderer
implements HtmlbRenderer {
    public void render(Component component, int selector, IPageContext renderContext) {
        this.render(component, renderContext);
    }

    public void render(Component component, IPageContext renderContext) {
        if (component instanceof ClientEventContainer) {
            ClientEventContainer eventContainer = (ClientEventContainer)component;
            renderContext.write("<span");
            HashMap events = eventContainer.getEvents();
            if (events.size() > 0) {
                Set keys = events.keySet();
                Iterator keyIterator = keys.iterator();
                String eventName = null;
                String clientFunction = null;
                while (keyIterator.hasNext()) {
                    eventName = (String)keyIterator.next();
                    clientFunction = (String)events.get(eventName);
                    this.renderEvent(eventName, clientFunction, renderContext);
                }
            }
            renderContext.write(">");
            RenderUtil.renderContainerContent(eventContainer, renderContext);
            renderContext.write("</span>");
        }
    }

    private void renderEvent(String eventName, String clientFunction, IPageContext pc) {
        pc.write(" " + eventName + "=\"" + clientFunction + "\"");
    }
}

