/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.Checkbox;
import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.EventValidationComponent;
import com.sapportals.htmlb.enum.EventTrigger;
import com.sapportals.htmlb.event.CheckboxClickEvent;
import com.sapportals.htmlb.rendering.EventValidationRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import java.util.HashSet;

public class DefaultCheckboxRenderer
extends EventValidationRenderer {
    private static HashSet validationTriggers = new HashSet();
    static /* synthetic */ Class class$com$sapportals$htmlb$event$CheckboxClickEvent;

    public boolean getDefaultClientEventReturnValue(EventTrigger trigger, EventValidationComponent component) {
        return trigger == EventTrigger.ON_CLICK;
    }

    public void render(Component component, int selector, IPageContext renderContext) {
        if (component instanceof Checkbox) {
            Checkbox cb = (Checkbox)component;
            switch (selector) {
                case 0: {
                    this.renderElement(cb, renderContext);
                    break;
                }
                case 1: {
                    this.renderContent(cb, renderContext);
                    break;
                }
                case 2: {
                    this.renderElementForGroup(cb, renderContext);
                    break;
                }
                case 3: {
                    this.renderContentForGroup(cb, renderContext);
                }
            }
        }
    }

    public void render(Component component, IPageContext renderContext) {
        if (component instanceof Checkbox) {
            boolean hasContent;
            Checkbox cb = (Checkbox)component;
            boolean bl = hasContent = cb.getText() != null || cb.getElement() != null;
            if (hasContent) {
                renderContext.write("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"sapCbgWhl\"><tr>");
                this.renderElementForGroup(cb, renderContext);
                this.renderContentForGroup(cb, renderContext);
                renderContext.write("</tr></table>");
            } else {
                this.renderElement(cb, renderContext);
            }
        }
    }

    public void renderElementForGroup(Checkbox cb, IPageContext renderContext) {
        renderContext.write("<td style=\"width:1px;");
        renderContext.write("\" valign=");
        if (cb.getElement() != null) {
            renderContext.write("\"top");
        } else {
            renderContext.write("\"middle");
        }
        renderContext.write("\">");
        this.renderElement(cb, renderContext);
        renderContext.write("</td>");
    }

    public void renderElement(Checkbox cb, IPageContext renderContext) {
        if (cb.isEnabled()) {
            renderContext.write(CheckboxClickEvent.renderJSFunction(renderContext, cb));
        }
        renderContext.write("<input type=\"checkbox\" class=\"sapCbgBox\" name=\"");
        String paramIdForComponent = renderContext.getParamIdForComponent(cb);
        renderContext.write(paramIdForComponent);
        renderContext.write("\" id=\"");
        renderContext.write(paramIdForComponent);
        renderContext.write("\" value=\"");
        if (cb.getKey() != null) {
            renderContext.write(cb.getKey());
        }
        renderContext.write("\"");
        if (cb.isChecked()) {
            renderContext.write(" checked");
        }
        if (!cb.isEnabled()) {
            renderContext.write(" disabled");
        }
        if (cb.hasValidTooltip()) {
            renderContext.write(" title=\"");
            renderContext.write(cb.getTooltip());
            renderContext.write("\"");
        }
        this.renderEventValidationHandlers(class$com$sapportals$htmlb$event$CheckboxClickEvent == null ? (class$com$sapportals$htmlb$event$CheckboxClickEvent = DefaultCheckboxRenderer.class$("com.sapportals.htmlb.event.CheckboxClickEvent")) : class$com$sapportals$htmlb$event$CheckboxClickEvent, validationTriggers, false, cb, renderContext);
        renderContext.write(">");
    }

    public void renderContent(Checkbox cb, IPageContext renderContext) {
        if (cb.getElement() != null) {
            cb.getElement().render(renderContext);
            return;
        }
        renderContext.write("<span class=\"sapTxtStd\" ");
        if (cb.hasValidTooltip()) {
            renderContext.write("title=\"");
            renderContext.write(cb.getTooltip());
            renderContext.write("\" nowrap=\"\"");
        }
        renderContext.write(">");
        if (cb.isEncode()) {
            renderContext.writeEncoded(cb.getText());
        } else {
            renderContext.write(cb.getText());
        }
        renderContext.write("</span>");
    }

    public void renderContentForGroup(Checkbox cb, IPageContext renderContext) {
        renderContext.write("<td align=\"left\"  title=\"");
        if (cb.hasValidTooltip()) {
            renderContext.write(cb.getTooltip());
        }
        renderContext.write("\" valign=");
        if (cb.getElement() != null) {
            renderContext.write("\"top");
        } else {
            renderContext.write("\"middle");
        }
        renderContext.write("\" class=\"sapCbgTxt\">");
        if (cb.getElement() != null) {
            cb.getElement().render(renderContext);
        } else if (cb.isEncode()) {
            renderContext.writeEncoded(cb.getText());
        } else {
            renderContext.write(cb.getText());
        }
        renderContext.write("</td>");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        validationTriggers.add(EventTrigger.ON_BLUR);
        validationTriggers.add(EventTrigger.ON_CLICK);
    }
}

