/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.Checkbox;
import com.sapportals.htmlb.CheckboxGroup;
import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.rendering.HtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import java.util.Iterator;

public class DefaultCheckboxGroupRenderer
implements HtmlbRenderer {
    public void render(Component component, int selector, IPageContext renderContext) {
        if (component instanceof CheckboxGroup) {
            CheckboxGroup myGroup = (CheckboxGroup)component;
            switch (selector) {
                case 0: {
                    this.renderBegin(myGroup, renderContext);
                    break;
                }
                case 1: {
                    this.renderEnd(myGroup, renderContext);
                    break;
                }
                case 3: {
                    this.renderElementBegin(myGroup, renderContext);
                    break;
                }
                case 4: {
                    this.renderElementEnd(myGroup, renderContext);
                }
            }
        }
    }

    public void render(Component component, IPageContext renderContext) {
        if (component instanceof CheckboxGroup) {
            CheckboxGroup myGroup = (CheckboxGroup)component;
            this.renderBegin(myGroup, renderContext);
            this.renderContent(myGroup, renderContext);
            this.renderEnd(myGroup, renderContext);
        }
    }

    public void renderBegin(CheckboxGroup cbg, IPageContext renderContext) {
        renderContext.write("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" name=\"");
        renderContext.write("\"  class=\"sapCbgWhl");
        String width = cbg.getWidth();
        if (width != null) {
            renderContext.write("\" style=\"width:");
            renderContext.write(width);
        }
        renderContext.write("\">");
        cbg.setCurrentItem(0);
    }

    public void renderContent(CheckboxGroup cbg, IPageContext pc) {
        Iterator it = cbg.iterator();
        while (it.hasNext()) {
            this.renderElementBegin(cbg, pc);
            Checkbox msi = (Checkbox)it.next();
            pc.write("<td nowrap>");
            msi.render(0, pc);
            msi.render(1, pc);
            pc.write("</td>");
            this.renderElementEnd(cbg, pc);
        }
    }

    public void renderElementBegin(CheckboxGroup cbg, IPageContext renderContext) {
        int currentItem = cbg.getCurrentItem() + 1;
        cbg.setCurrentItem(currentItem);
        int colCount = cbg.getColumnCount();
        int colIndex = currentItem % colCount;
        if (colCount == 1 || colIndex == 1) {
            renderContext.write("<tr>");
        }
    }

    public void renderElementEnd(CheckboxGroup cbg, IPageContext renderContext) {
        int myCount = cbg.getColumnCount();
        int colIndex = cbg.getCurrentItem() % myCount;
        if (colIndex == 0) {
            renderContext.write("</tr>");
        }
    }

    public void renderEnd(CheckboxGroup group, IPageContext renderContext) {
        renderContext.write(" </tr>");
        renderContext.write("</table>");
    }
}

