/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.Chart;
import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.IChartModel;
import com.sapportals.htmlb.rendering.AtomHtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;

public class DefaultChartRenderer
extends AtomHtmlbRenderer {
    public static final String cssClassName = "sapCht";
    private static final String cDataRowBOL = "@.";
    private static final String cDataRowSEP = "@,";
    private static final String cDataRowEOL = " ";

    private void addAppletParameter(IPageContext renderContext, String paramName, String paramValue) {
        renderContext.write("<PARAM NAME=");
        renderContext.writeEncoded(paramName);
        renderContext.write(" VALUE=\"");
        renderContext.writeEncoded(paramValue);
        renderContext.write("\">\n");
    }

    private void addAppletParameter(IPageContext renderContext, String paramName, double paramValue) {
        String doubleval = "" + paramValue;
        renderContext.write("<PARAM NAME=");
        renderContext.writeEncoded(paramName);
        renderContext.write(" VALUE=\"");
        renderContext.writeEncoded(doubleval);
        renderContext.write("\">\n");
    }

    private void addAppletParameter(IPageContext renderContext, String paramName, int paramValue) {
        String intval = "" + paramValue;
        renderContext.write("<PARAM NAME=");
        renderContext.writeEncoded(paramName);
        renderContext.write(" VALUE=\"");
        renderContext.writeEncoded(intval);
        renderContext.write("\">\n");
    }

    private void addTagAttribute(IPageContext renderContext, String attribName, String attribValue) {
        renderContext.write(cDataRowEOL);
        renderContext.writeEncoded(attribName);
        renderContext.write("=\"");
        renderContext.writeEncoded(attribValue);
        renderContext.write("\"");
    }

    private void addTagAttribute(IPageContext renderContext, String attribName, int attribValue) {
        renderContext.write(cDataRowEOL);
        renderContext.writeEncoded(attribName);
        renderContext.write("=\"");
        renderContext.write(attribValue);
        renderContext.write("\"");
    }

    private String checkReference(String src, String pattern) {
        int from = 0;
        int to = 0;
        from = src.indexOf(pattern);
        from = src.indexOf("\"", from);
        to = src.indexOf("\"", from + 1);
        String retval = from >= 0 && to > 0 ? src.substring(from + 1, to) : null;
        return retval;
    }

    public void render(Component component, IPageContext renderContext) {
        if (component instanceof Chart) {
            Chart myChart = (Chart)component;
            String mimeDirectory = renderContext.getJavascriptPath();
            String mimeJarFile = mimeDirectory + "chart/piglet.jar";
            String cssFile = renderContext.getStylesheetUrl();
            if (myChart.isVisible()) {
                renderContext.write("\n\n<applet code=\"com.sap.miniapps.graphics.Piglet.class\"");
                this.addTagAttribute(renderContext, "archive", mimeJarFile);
                this.addTagAttribute(renderContext, "width", myChart.getWidth());
                this.addTagAttribute(renderContext, "height", myChart.getHeight());
                if (myChart.getTooltip().length() > 0) {
                    this.addTagAttribute(renderContext, "title", myChart.getTooltip());
                }
                if (myChart.getAltText().length() > 0) {
                    this.addTagAttribute(renderContext, "alt", myChart.getAltText());
                }
                renderContext.write(">\n");
                this.addAppletParameter(renderContext, "COLORORDER", "X");
                this.addAppletParameter(renderContext, "STYLESHEET", cssFile);
                this.addAppletParameter(renderContext, "STYLETAG", cssClassName);
                this.addAppletParameter(renderContext, "BG_COLOR", "0xffffff");
                this.addAppletParameter(renderContext, "TYPE", myChart.getChartTypeString());
                this.addAppletParameter(renderContext, "LEGEND", myChart.getChartLegendPositionString());
                this.addAppletParameter(renderContext, "THEME", myChart.getColorOrderString());
                if (myChart.getTitle().length() > 0) {
                    this.addAppletParameter(renderContext, "TITLE", myChart.getTitle());
                }
                if (myChart.getTitleCategories().length() > 0) {
                    this.addAppletParameter(renderContext, "CAT_AX_NAME", myChart.getTitleCategories());
                }
                if (myChart.getTitleValues().length() > 0) {
                    this.addAppletParameter(renderContext, "VAL_AX_NAME", myChart.getTitleValues());
                }
                if (myChart.getFractionDigits() >= 0) {
                    this.addAppletParameter(renderContext, "FRACTIONDIGITS", myChart.getFractionDigits());
                }
                if (myChart.getBusinessDigits()) {
                    this.addAppletParameter(renderContext, "BUSINESSDIGIT", "X");
                }
                if (myChart.isDisplayObjectValues()) {
                    this.addAppletParameter(renderContext, "DISPLAYOBJECTVALUES", "X");
                }
                if (myChart.getAxisMinVal() != myChart.getAxisMaxVal()) {
                    this.addAppletParameter(renderContext, "AXISMINVAL", myChart.getAxisMinVal());
                    this.addAppletParameter(renderContext, "AXISMAXVAL", myChart.getAxisMaxVal());
                }
                if (myChart.isVoidValueSet()) {
                    this.addAppletParameter(renderContext, "VOIDVALUE", myChart.getVoidValue());
                }
                IChartModel dataModel = myChart.getModel();
                StringBuffer dataStream = new StringBuffer(200);
                if (dataModel != null) {
                    dataModel.firstRow();
                    int columnCount = dataModel.getNumColumns();
                    boolean j = false;
                    do {
                        String rest;
                        String curGroupID = "";
                        String curX = "";
                        String curY = "";
                        String curZ = "";
                        String curExtension = "";
                        String curColor = "";
                        curGroupID = dataModel.getGroupId();
                        curX = dataModel.getX();
                        curY = dataModel.getY();
                        curExtension = dataModel.getExtension();
                        curColor = dataModel.getColor();
                        if (curGroupID.length() > 0) {
                            dataStream.append(cDataRowBOL);
                            dataStream.append(curGroupID);
                        } else {
                            dataStream.append(cDataRowBOL);
                            dataStream.append(' ');
                        }
                        if (curX.length() > 0) {
                            dataStream.append(cDataRowSEP);
                            dataStream.append(curX);
                        } else {
                            dataStream.append(cDataRowSEP);
                            dataStream.append("Item");
                        }
                        if (curY.length() > 0) {
                            dataStream.append(cDataRowSEP);
                            dataStream.append(curY);
                        } else {
                            dataStream.append(cDataRowSEP);
                            dataStream.append('0');
                        }
                        if (curExtension.length() > 0) {
                            dataStream.append(cDataRowSEP);
                            rest = this.checkReference(curExtension, "href");
                            if (rest != null) {
                                dataStream.append(rest);
                            } else {
                                dataStream.append(' ');
                            }
                        } else {
                            dataStream.append(cDataRowSEP);
                            dataStream.append(' ');
                        }
                        if (curExtension.length() > 0) {
                            dataStream.append(cDataRowSEP);
                            rest = this.checkReference(curExtension, "alt");
                            if (rest != null) {
                                dataStream.append(rest);
                            } else {
                                dataStream.append(' ');
                            }
                        } else {
                            dataStream.append(cDataRowSEP);
                            dataStream.append(' ');
                        }
                        if (curColor.length() > 0) {
                            dataStream.append(cDataRowSEP);
                            dataStream.append(curColor);
                        } else {
                            dataStream.append(cDataRowSEP);
                            dataStream.append(' ');
                        }
                        dataStream.append("@, \n");
                        j = false;
                    } while (dataModel.nextRow());
                    dataStream.append("@. ");
                } else {
                    dataStream.append("@.Row 1@,Test1@,100,000000@,http://www.sap.com@,Hallo Kai ");
                    dataStream.append("!@, @.Row 1@,Test2@,80,000000@,http://www.e-sap.de@,Hallo Markus");
                    dataStream.append("!@, @.Row 1@,Test3@,120,000000@,http://www.saplabs.com@,Hallo Jens");
                    dataStream.append("!@, @.Row 2@,Test1@,-40,000000@,http://www.mysap.com@,Hallo Peter");
                    dataStream.append("!@, @.Row 2@,Test2@,200,000000@,http://intranet.sap.com@,Hallo Welt");
                    dataStream.append("!@, @.Row 2@,Test3@,-160,000000@,http://intranet.sap.com@,Hallo Sonstwer");
                    dataStream.append("!@, @.");
                }
                this.addAppletParameter(renderContext, "DATA", dataStream.toString());
                renderContext.write("</APPLET>\n\n\n\n");
            }
        }
    }
}

