/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.rendering;

import com.sapportals.htmlb.Checkbox;
import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.IEventValidationComponent;
import com.sapportals.htmlb.InputField;
import com.sapportals.htmlb.JavascriptFragment;
import com.sapportals.htmlb.RadioButton;
import com.sapportals.htmlb.enum.EventTrigger;
import com.sapportals.htmlb.event.Event;
import com.sapportals.htmlb.event.EventManager;
import com.sapportals.htmlb.rendering.AtomHtmlbRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RenderUtil;
import com.sapportals.htmlb.table.TableView;
import com.sapportals.htmlb.validation.Validator;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;

public abstract class ComponentValidationRenderer
extends AtomHtmlbRenderer {
    public static boolean getDefaultClientEventReturnValue(EventTrigger trigger, IEventValidationComponent component) {
        return component instanceof Checkbox || component instanceof InputField || component instanceof TableView || component instanceof RadioButton;
    }

    public static void renderEventValidationFunction(HashSet validationTriggers, IEventValidationComponent component, IPageContext pageContext) {
        StringBuffer buffer = new StringBuffer();
        String validationCall = "_htmlbisvalid";
        ArrayList validators = component.getAllValidators();
        Locale locale = pageContext.getLocale();
        if (validators != null && component.isRequiresValidation()) {
            String errorText = component.getErrorText();
            StringBuffer result = new StringBuffer(1000);
            result.append("function ");
            validationCall = EventManager.getJavaScriptFunctionName(pageContext, (Component)((Object)component), EventTrigger.ON_VALIDATION.toString());
            result.append(validationCall);
            result.append("(){");
            boolean first = true;
            if (errorText == null) {
                Iterator validationIterator = ((AbstractList)validators).iterator();
                while (validationIterator.hasNext()) {
                    Validator validator = (Validator)validationIterator.next();
                    if (first) {
                        result.append("if(");
                        first = false;
                    } else {
                        result.append("else if(");
                    }
                    result.append("!");
                    result.append(validator.getJavascript(locale));
                    result.append(")e=");
                    result.append(RenderUtil.encodeJavascriptString(validator.getErrorText(locale)));
                    result.append(";");
                }
                result.append("else e=null; this.setErrorText(e);return(e==null);");
            } else {
                Iterator validationIterator = ((AbstractList)validators).iterator();
                while (validationIterator.hasNext()) {
                    Validator v = (Validator)validationIterator.next();
                    if (first) {
                        result.append("if(");
                        first = false;
                    } else {
                        result.append("&&");
                    }
                    result.append(v.getJavascript(locale));
                }
                result.append(")e=null;else e=");
                result.append(RenderUtil.encodeJavascriptString(errorText));
                result.append("; this.setErrorText(e);return(e==null);");
            }
            result.append("}\n");
            pageContext.getCurrentForm().addFormEndJavascript(new JavascriptFragment(((Component)((Object)component)).getId(), result.toString(), (Component)((Object)component), pageContext.getParamIdForComponent((Component)((Object)component))));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String renderEventValidationCall(Class defaultEventClass, boolean validateControl, boolean noFormValidation, IEventValidationComponent component, EventTrigger trigger, IPageContext pageContext) {
        String eventCall;
        HashMap clientEvents = component.getClientEventMap();
        boolean requiresValidation = true;
        HashMap serverEvents = component.getServerEventMap();
        String validationCall = "";
        if (component instanceof InputField) {
            InputField inf = (InputField)component;
            requiresValidation = inf.isRequiresValidation();
            validateControl = requiresValidation && validateControl;
            boolean bl = noFormValidation = !requiresValidation;
            if (requiresValidation) {
                validationCall = EventManager.getJavaScriptFunctionName(pageContext, (Component)((Object)component), EventTrigger.ON_VALIDATION.toString());
            }
        } else {
            validateControl = component.isRequiresValidation() && validateControl;
            noFormValidation = !component.isRequiresValidation();
        }
        String s = (String)clientEvents.get(trigger);
        if (s != null) {
            String eventType = trigger.toString();
            StringBuffer result = new StringBuffer(1000);
            result.append("\nfunction ");
            String jsFuncName = EventManager.getJavaScriptFunctionName(pageContext, (Component)((Object)component), eventType);
            result.append(jsFuncName);
            result.append("(htmlbevent){");
            result.append("htmlb_formid = '");
            result.append(pageContext.getCurrentFormId());
            result.append("';");
            result.append(s);
            result.append(";");
            result.append("}");
            pageContext.getCurrentForm().addFormEndJavascript(new JavascriptFragment(((Component)((Object)component)).getId(), result.toString(), (Component)((Object)component), pageContext.getParamIdForComponent((Component)((Object)component))));
        }
        boolean returnValue = ComponentValidationRenderer.getDefaultClientEventReturnValue(trigger, component);
        Event serverEvent = (Event)serverEvents.get(trigger);
        if (serverEvent == null) {
            if (clientEvents.get(trigger) == null && (!validateControl || !requiresValidation)) return "";
            eventCall = EventManager.renderEventCall(pageContext, defaultEventClass, trigger.toString(), (Component)((Object)component), null, (String)clientEvents.get(trigger), validateControl, !noFormValidation, returnValue, null);
        } else {
            eventCall = EventManager.renderEventCall(pageContext, serverEvent.getClass(), trigger.toString(), (Component)((Object)component), serverEvent.getAction(), (String)clientEvents.get(trigger), validateControl, !noFormValidation, returnValue, serverEvent.getParams((Component)((Object)component)));
        }
        StringBuffer jsCall = new StringBuffer();
        if (eventCall.equals("")) {
            jsCall.append(validationCall);
            if (returnValue) {
                jsCall.append("();return true;");
                return jsCall.toString();
            } else {
                jsCall.append("();return false;");
            }
            return jsCall.toString();
        } else {
            jsCall.append(eventCall);
        }
        return jsCall.toString();
    }
}

