/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.page;

import com.sapportals.htmlb.page.DynPage;
import com.sapportals.htmlb.page.PageException;
import com.sapportals.htmlb.page.PageProcessor;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class PageProcessorServlet
extends HttpServlet {
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    public void destroy() {
    }

    public abstract DynPage getPage();

    protected DynPage getPage(HttpServletRequest request, HttpServletResponse response) {
        return this.getPage();
    }

    private void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            RequestDispatcher dispatcher;
            String forward;
            response.setContentType("text/html");
            DynPage tmpPage = this.getPage(request, response);
            PageProcessor processor = new PageProcessor(request, response, tmpPage);
            if (processor != null) {
                processor.handleRequest();
            }
            if ((forward = tmpPage.getForward()) != null && (dispatcher = request.getRequestDispatcher(forward)) != null) {
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (PageException e) {
            Throwable ee = e.getEmbeddedException();
            if (ee != null) {
                throw new ServletException(ee);
            }
            throw new ServletException((Throwable)e);
        }
    }
}

