/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.page;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Container;
import com.sapportals.htmlb.Form;
import com.sapportals.htmlb.event.Event;
import com.sapportals.htmlb.page.DynPage;
import com.sapportals.htmlb.page.IPersistence;
import com.sapportals.htmlb.page.PageException;
import com.sapportals.htmlb.page.PersistenceManager;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.PageContextFactory;
import com.sapportals.htmlb.serialize.ISerializer;
import com.sapportals.htmlb.serialize.SerializeManager;
import com.sapportals.htmlb.util.DefaultHtmlbEncoder;
import java.util.Iterator;
import java.util.StringTokenizer;

public class PageProcessor {
    protected final String SEPARATOR = ":";
    protected final String FINALIZER = ";";
    protected Object request = null;
    protected Object response = null;
    protected DynPage page = null;
    protected IPageContext pageContext = null;
    private IPersistence persistence;

    public PageProcessor(Object request, Object response, DynPage page) throws PageException {
        this.response = response;
        this.request = request;
        this.page = page;
        this.pageContext = PageContextFactory.createPageContext(request, response);
        if (this.pageContext == null) {
            throw new PageException("Internal error: empty page context");
        }
    }

    public void handleRequest() throws PageException {
        this.page.setRequest(this.request);
        this.page.setResponse(this.response);
        this.page.setPageContext(this.pageContext);
        this.pageContext.setParent(this.page);
        if (this.page.getClassLoader() != null) {
            this.pageContext.setClassLoader(this.page.getClassLoader());
        } else {
            this.pageContext.setClassLoader(this.page.getClass().getClassLoader());
        }
        this.pageContext.rebuildComponents();
        long start = 0L;
        start = System.currentTimeMillis();
        this.persistence = PersistenceManager.getStore();
        String persistData = null;
        if (this.pageContext.getOldForm() != null) {
            persistData = this.persistence.readData(this.pageContext);
            this.rebuild(persistData, this.pageContext);
        }
        start = System.currentTimeMillis() - start;
        this.pageContext.addPerfCounter("Restore persistence: " + start + "ms");
        start = System.currentTimeMillis();
        this.page.doSetupOutput();
        start = System.currentTimeMillis() - start;
        this.pageContext.addPerfCounter("DynPage.doSetupOutput(): " + start + "ms");
        start = System.currentTimeMillis();
        String method = null;
        if (this.pageContext.getOldForm() != null) {
            this.page.doProcessAfterInput();
            method = "doProcessAfterInput()";
        } else {
            this.page.doInitialization();
            method = "doInitialization()";
        }
        start = System.currentTimeMillis() - start;
        this.pageContext.addPerfCounter("DynPage." + method + ": " + start + "ms");
        start = System.currentTimeMillis();
        Event event = this.pageContext.getCurrentEvent();
        if (event != null) {
            this.page.doProcessCurrentEvent(event);
        }
        start = System.currentTimeMillis() - start;
        this.pageContext.addPerfCounter("DynPage.doProcessCurrentEvent(): " + start + "ms");
        start = System.currentTimeMillis();
        this.page.doProcessBeforeOutput();
        start = System.currentTimeMillis() - start;
        this.pageContext.addPerfCounter("DynPage.doProcessBeforeOutput(): " + start + "ms");
        if (this.page.getForward() == null) {
            this.page.doOutput(this);
        }
        this.pageContext.cleanUp();
        this.pageContext.setParent(null);
    }

    public void serializeFormData(Form theForm) throws PageException {
        String persistData = this.serializePage(theForm);
        if (persistData != null && persistData.length() > 0) {
            this.persistence.writeData(theForm, persistData);
        }
    }

    private String serializePage(Component component) {
        String serializedPage = "";
        if (component instanceof Container) {
            Container container = (Container)component;
            Iterator iter = container.iterator();
            while (iter.hasNext()) {
                Object object = iter.next();
                if (!(object instanceof Component)) continue;
                Component comp = (Component)object;
                ISerializer serializer = SerializeManager.getSerializer(comp);
                if (serializer != null) {
                    String serialize = serializer.serialize(comp);
                    String encodedName = this.encode(comp.getId());
                    serializedPage = serializedPage + encodedName + ":" + this.encode(serialize) + ";";
                }
                if (!(comp instanceof Container)) continue;
                serializedPage = serializedPage + this.serializePage(comp);
            }
        }
        return serializedPage;
    }

    private void rebuild(String serial, IPageContext context) {
        StringTokenizer splitter = null;
        boolean count = false;
        String entry = null;
        StringTokenizer element = null;
        Object id = null;
        Object className = null;
        String compName = null;
        String encodedData = null;
        boolean index = false;
        if (serial != null) {
            splitter = new StringTokenizer(serial, ";");
            while (splitter.hasMoreTokens()) {
                String s;
                entry = splitter.nextToken();
                element = new StringTokenizer(entry, ":");
                if (element.hasMoreTokens()) {
                    s = element.nextToken();
                    compName = this.decode(s);
                }
                if (!element.hasMoreTokens() || (encodedData = this.decode(s = element.nextToken())).endsWith(";")) {
                    // empty if block
                }
                this.createComponent(context, compName, encodedData);
            }
        }
    }

    private Component createComponent(IPageContext context, String compName, String encodedData) {
        ISerializer serializer;
        Component component = context.getComponentForId(compName);
        if (component != null && (serializer = SerializeManager.getSerializer(component)) != null) {
            serializer.deserialize(component, encodedData);
        }
        return component;
    }

    private String encode(String data) {
        return DefaultHtmlbEncoder.escape(data);
    }

    private String decode(String encodedData) {
        return DefaultHtmlbEncoder.unEscape(encodedData);
    }
}

