/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.mmparser;

import com.sapportals.htmlb.mmparser.MMInputStream;
import java.io.FilterInputStream;
import java.io.IOException;

public class PartInputStream
extends FilterInputStream {
    private String m_boundary;
    private byte[] m_buf = new byte[65536];
    private int m_count;
    private int m_pos;
    private boolean m_eof;
    MMInputStream m_in = null;

    PartInputStream(MMInputStream in, String boundary) throws IOException {
        super(in);
        this.m_in = in;
        this.m_boundary = boundary;
    }

    private void fill() throws IOException {
        if (this.m_eof) {
            return;
        }
        if (this.m_count > 0) {
            if (this.m_count - this.m_pos == 2) {
                System.arraycopy(this.m_buf, this.m_pos, this.m_buf, 0, this.m_count - this.m_pos);
                this.m_count -= this.m_pos;
                this.m_pos = 0;
            } else {
                throw new IllegalStateException("fill() detected illegal buffer state");
            }
        }
        int read = 0;
        int maxRead = this.m_buf.length - this.m_boundary.length();
        while (this.m_count < maxRead) {
            read = this.m_in.readLine(this.m_buf, this.m_count, this.m_buf.length - this.m_count);
            if (read == -1) {
                throw new IOException("unexpected end of part");
            }
            if (read >= this.m_boundary.length()) {
                this.m_eof = true;
                int i = 0;
                while (i < this.m_boundary.length()) {
                    if (this.m_boundary.charAt(i) != this.m_buf[this.m_count + i]) {
                        this.m_eof = false;
                        break;
                    }
                    ++i;
                }
                if (this.m_eof) break;
            }
            this.m_count += read;
        }
    }

    public int read() throws IOException {
        if (this.m_count - this.m_pos <= 2) {
            this.fill();
            if (this.m_count - this.m_pos <= 2) {
                return -1;
            }
        }
        return this.m_buf[this.m_pos++] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int total = 0;
        if (len == 0) {
            return 0;
        }
        int avail = this.m_count - this.m_pos - 2;
        if (avail <= 0) {
            this.fill();
            avail = this.m_count - this.m_pos - 2;
            if (avail <= 0) {
                return -1;
            }
        }
        int copy = Math.min(len, avail);
        System.arraycopy(this.m_buf, this.m_pos, b, off, copy);
        this.m_pos += copy;
        total += copy;
        while (total < len) {
            this.fill();
            avail = this.m_count - this.m_pos - 2;
            if (avail <= 0) {
                return total;
            }
            copy = Math.min(len - total, avail);
            System.arraycopy(this.m_buf, this.m_pos, b, off + total, copy);
            this.m_pos += copy;
            total += copy;
        }
        return total;
    }

    public int available() throws IOException {
        int avail = this.m_count - this.m_pos - 2 + this.m_in.available();
        return avail < 0 ? 0 : avail;
    }

    public void close() throws IOException {
        if (!this.m_eof) {
            while (this.read(this.m_buf, 0, this.m_buf.length) != -1) {
            }
        }
    }
}

