/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.mmparser;

import com.sapportals.htmlb.mmparser.AbstractPart;
import com.sapportals.htmlb.mmparser.FilePart;
import com.sapportals.htmlb.mmparser.HeaderFields;
import com.sapportals.htmlb.mmparser.MMInputStream;
import com.sapportals.htmlb.mmparser.ParamPart;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

public class MimeMultipartParser {
    private String m_contentType;
    private int m_contentLength;
    private String m_boundary;
    private MMInputStream m_inputStream;
    private HeaderFields m_headers;
    private FilePart m_lastFilePart;
    private byte[] m_buf = new byte[8192];

    public MimeMultipartParser(HttpServletRequest req) throws IOException {
        this.m_headers = new HeaderFields();
        Enumeration en = req.getHeaderNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String value = req.getHeader(name);
            this.m_headers.setHeaderField(name, value);
        }
        this.m_contentType = this.m_headers.getHeaderField("content-type");
        if (this.m_contentType == null) {
            throw new IOException("Content type is not multipart/form-data");
        }
        if (!this.m_contentType.toLowerCase().startsWith("multipart/form-data")) {
            throw new IOException("Content type is not multipart/form-data");
        }
        this.m_contentLength = Integer.parseInt(this.m_headers.getHeaderField("content-length"));
        this.m_inputStream = new MMInputStream((InputStream)req.getInputStream());
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    public MimeMultipartParser(HttpURLConnection con) throws IOException {
        String name;
        this.m_headers = new HeaderFields();
        int i = 1;
        while ((name = ((URLConnection)con).getHeaderFieldKey(i)) != null) {
            void var2_3;
            String value = ((URLConnection)con).getHeaderField(i);
            this.m_headers.setHeaderField((String)var2_3, value);
            ++i;
        }
        this.m_contentType = this.m_headers.getHeaderField("content-type");
        if (this.m_contentType == null) {
            throw new IOException("Content type is not multipart/form-data");
        }
        if (!this.m_contentType.toLowerCase().startsWith("multipart/form-data")) {
            throw new IOException("Content type is not multipart/form-data");
        }
        this.m_contentLength = Integer.parseInt(this.m_headers.getHeaderField("content-length"));
        this.m_inputStream = new MMInputStream(con.getInputStream());
        this.init();
    }

    private void init() throws IOException {
        this.m_boundary = this.findBoundary(this.m_headers.getHeaderField("content-type"));
        if (this.m_boundary == null) {
            throw new IOException("No mime-multipart bondary was found in the content type.");
        }
        String line = this.nextLine();
        if (line == null) {
            throw new IOException("Invalid multipart form data received.");
        }
        if (!line.startsWith(this.m_boundary)) {
            throw new IOException("Invalid multipart form data received.");
        }
    }

    public AbstractPart nextPart() throws IOException {
        String contentType;
        int pos;
        String line;
        if (this.m_lastFilePart != null) {
            this.m_lastFilePart.getInputStream().close();
            this.m_lastFilePart = null;
        }
        HeaderFields header = new HeaderFields();
        while ((line = this.nextLine()) != null && !line.equals("")) {
            pos = line.indexOf(":");
            if (pos <= -1) continue;
            String hname = line.substring(0, pos);
            String hvalue = line.substring(pos + 1).trim();
            header.setHeaderField(hname, hvalue);
        }
        if (header.size() == 0) {
            return null;
        }
        String name = null;
        String filename = null;
        String dispinfo = header.getHeaderField("content-disposition");
        if (dispinfo != null) {
            pos = dispinfo.indexOf("name=\"");
            int pos2 = dispinfo.lastIndexOf(";");
            if (pos == -1) {
                throw new IOException("Malformed content-disposition in multipart header: " + dispinfo);
            }
            name = pos2 < pos ? dispinfo.substring(pos + 6, dispinfo.length() - 1) : dispinfo.substring(pos + 6, pos2 - 1);
            pos = dispinfo.indexOf("filename=\"", pos2);
            if (pos > -1) {
                filename = dispinfo.substring(pos + 10, dispinfo.length() - 1);
                if ((pos = filename.lastIndexOf("/")) == -1) {
                    pos = filename.lastIndexOf("\\");
                }
                if (pos > -1) {
                    filename = filename.substring(pos + 1);
                }
            }
        } else {
            filename = header.getHeaderField("x-compid");
            if (filename == null) {
                throw new IOException("Multipart header contains no content-diposition or x-compid.");
            }
            name = "sap_contentserver_component";
        }
        if ((contentType = header.getHeaderField("content-type")) == null) {
            header.setHeaderField("content-type", "text/plain");
        }
        if (filename == null) {
            return new ParamPart(name, this.m_inputStream, this.m_boundary);
        }
        if (filename.equals("")) {
            filename = null;
        }
        this.m_lastFilePart = new FilePart(name, this.m_inputStream, this.m_boundary, filename, header);
        return this.m_lastFilePart;
    }

    private String findBoundary(String line) {
        int index = line.lastIndexOf("boundary=");
        if (index == -1) {
            return null;
        }
        String boundary = "--" + line.substring(index + 9);
        return boundary;
    }

    private String nextLine() throws IOException {
        StringBuffer sb = new StringBuffer();
        int bytesRead = this.m_inputStream.readLine(this.m_buf, 0, this.m_buf.length);
        if (bytesRead != -1) {
            sb.append(new String(this.m_buf, 0, bytesRead, "ISO-8859-1"));
        }
        if (bytesRead == this.m_buf.length) {
            throw new IOException("Malformed mime multipart header (buffer overrun).");
        }
        if (sb.length() == 0) {
            return null;
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }
}

