/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.mmparser;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MMInputStream
extends FilterInputStream {
    private InputStream m_in;
    private byte[] m_buf = new byte[65536];
    private int m_count;
    private int m_pos;

    public MMInputStream(InputStream in) {
        super(in);
        this.m_in = in;
    }

    private void fill() throws IOException {
        int i = this.m_in.read(this.m_buf, 0, this.m_buf.length);
        if (i > 0) {
            this.m_pos = 0;
            this.m_count = i;
        }
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        int copy;
        int eol;
        int total = 0;
        if (len == 0) {
            return 0;
        }
        int avail = this.m_count - this.m_pos;
        if (avail <= 0) {
            this.fill();
            avail = this.m_count - this.m_pos;
            if (avail <= 0) {
                return -1;
            }
        }
        if ((eol = MMInputStream.findeol(this.m_buf, this.m_pos, copy = Math.min(len, avail))) != -1) {
            copy = eol;
        }
        System.arraycopy(this.m_buf, this.m_pos, b, off, copy);
        this.m_pos += copy;
        total += copy;
        while (total < len && eol == -1) {
            this.fill();
            avail = this.m_count - this.m_pos;
            if (avail <= 0) {
                return total;
            }
            copy = Math.min(len - total, avail);
            eol = MMInputStream.findeol(this.m_buf, this.m_pos, copy);
            if (eol != -1) {
                copy = eol;
            }
            System.arraycopy(this.m_buf, this.m_pos, b, off + total, copy);
            this.m_pos += copy;
            total += copy;
        }
        return total;
    }

    private static int findeol(byte[] b, int pos, int len) {
        int end = pos + len;
        int i = pos;
        while (i < end) {
            if (b[i++] != 10) continue;
            return i - pos;
        }
        return -1;
    }

    public int read() throws IOException {
        if (this.m_count <= this.m_pos) {
            this.fill();
            if (this.m_count <= this.m_pos) {
                return -1;
            }
        }
        return this.m_buf[this.m_pos++] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int total = 0;
        while (total < len) {
            int avail = this.m_count - this.m_pos;
            if (avail <= 0) {
                this.fill();
                avail = this.m_count - this.m_pos;
                if (avail <= 0) {
                    if (total > 0) {
                        return total;
                    }
                    return -1;
                }
            }
            int copy = Math.min(len - total, avail);
            System.arraycopy(this.m_buf, this.m_pos, b, off + total, copy);
            this.m_pos += copy;
            total += copy;
        }
        return total;
    }
}

