/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.mmparser;

import com.sapportals.htmlb.mmparser.AbstractPart;
import com.sapportals.htmlb.mmparser.HeaderFields;
import com.sapportals.htmlb.mmparser.MMInputStream;
import com.sapportals.htmlb.mmparser.PartInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FilePart
extends AbstractPart {
    private String fileName;
    private PartInputStream partInput;
    private HeaderFields m_header;

    FilePart(String name, MMInputStream in, String boundary, String fileName, HeaderFields header) throws IOException {
        super(name);
        this.m_header = header;
        this.fileName = fileName;
        this.partInput = new PartInputStream(in, boundary);
    }

    public String getFileName() {
        return this.fileName;
    }

    public HeaderFields getHeader() {
        return (HeaderFields)this.m_header.clone();
    }

    public void setHeader(HeaderFields header) {
        this.m_header = header;
    }

    public InputStream getInputStream() {
        return this.partInput;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long writeTo(File fileOrDirectory) throws IOException {
        long written = 0L;
        OutputStream fileOut = null;
        try {
            if (this.fileName != null) {
                File file = fileOrDirectory.isDirectory() ? new File(fileOrDirectory, this.fileName) : fileOrDirectory;
                fileOut = new BufferedOutputStream(new FileOutputStream(file));
                written = this.write(fileOut);
            }
            Object var7_5 = null;
            if (fileOut == null) return written;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (fileOut == null) throw throwable;
            fileOut.close();
            throw throwable;
        }
        fileOut.close();
        return written;
    }

    public long writeTo(OutputStream out) throws IOException {
        long size = 0L;
        if (this.fileName != null) {
            this.write(out);
        }
        return size;
    }

    public boolean isFile() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected long write(OutputStream out) throws IOException {
        int read;
        long size = 0L;
        byte[] buf = new byte[8192];
        while ((read = this.partInput.read(buf)) != -1) {
            void var4_4;
            out.write(buf, 0, (int)var4_4);
            size += (long)var4_4;
        }
        return size;
    }
}

