/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.htmlcontainer;

import com.sapportals.htmlb.util.Log;
import java.util.Enumeration;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;

public class DefaultHtmlParserCallback
extends HTMLEditorKit.ParserCallback {
    private StringBuffer document = new StringBuffer();
    private String url = new String();
    private boolean error = false;
    private HTML.Tag currentTag = null;

    public DefaultHtmlParserCallback(String url) {
        this.url = url.lastIndexOf("/") > 8 && url.substring(url.lastIndexOf("/"), url.length()).indexOf(".htm") > 0 ? url.substring(0, url.lastIndexOf("/")) : url;
    }

    public void handleStartTag(HTML.Tag tag, MutableAttributeSet attributes, int position) {
        this.currentTag = tag;
        if (this.error) {
            return;
        }
        if (this.checkTag(tag)) {
            this.document.append("<");
            this.document.append(tag);
            this.writeAttributes(this.adjustAttributes(attributes));
            this.document.append(">");
        }
        if (tag == HTML.Tag.BASE && attributes.getAttribute(HTML.Attribute.HREF) != null) {
            this.url = attributes.getAttribute(HTML.Attribute.HREF).toString();
        }
        if (tag == HTML.Tag.BODY) {
            this.document.append("<table ");
            this.document.append(this.adjustAttributes(attributes));
            this.document.append("><tr><td>");
        }
    }

    public void handleEndTag(HTML.Tag tag, int position) {
        if (this.error) {
            return;
        }
        if (this.checkTag(tag)) {
            this.document.append("</");
            this.document.append(tag);
            this.document.append(">");
        }
        if (tag == HTML.Tag.BODY) {
            this.document.append("</td></tr></table>");
        }
    }

    public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet attributes, int position) {
        this.currentTag = tag;
        if (this.error) {
            return;
        }
        if (this.checkTag(tag)) {
            this.document.append("<");
            this.document.append(tag);
            this.writeAttributes(this.adjustAttributes(attributes));
            this.document.append(">");
        }
    }

    public void handleText(char[] text, int position) {
        if (this.error) {
            return;
        }
        if (this.checkTag(this.currentTag)) {
            this.document.append(text);
        }
    }

    public void handleComment(char[] data, int position) {
        if (this.error) {
            return;
        }
        this.document.append("<!-- ");
        this.document.append(data);
        this.document.append(" -->");
    }

    private void writeAttributes(MutableAttributeSet attributes) {
        Enumeration<?> attr = attributes.getAttributeNames();
        while (attr.hasMoreElements()) {
            try {
                Object name = attr.nextElement();
                this.document.append(" " + name + "=\"");
                this.document.append(attributes.getAttribute(name));
                this.document.append("\" ");
            }
            catch (Exception e) {
                Log.getLogLocation(false).debugT("DefaultHtmlParserCallback", "Error in Attribute" + attributes.toString());
            }
        }
    }

    private boolean checkTag(HTML.Tag tag) {
        if (tag == HTML.Tag.HTML || tag == HTML.Tag.HEAD || tag == HTML.Tag.BODY || tag == HTML.Tag.META || tag == HTML.Tag.TITLE) {
            return false;
        }
        if (tag == HTML.Tag.FRAMESET || tag == HTML.Tag.FRAME) {
            this.document.delete(0, this.document.length());
            this.document.append("The document is using frames and can't be displayed non-isolated");
            this.error = true;
            return false;
        }
        if (tag == HTML.Tag.FORM) {
            this.document.delete(0, this.document.length());
            this.document.append("The document is using forms and can't be displayed non-isolated");
            this.error = true;
            return false;
        }
        return true;
    }

    private MutableAttributeSet adjustAttributes(MutableAttributeSet attributes) {
        attributes = this.adjustRelativeUrl(attributes, HTML.Attribute.SRC);
        attributes = this.adjustRelativeUrl(attributes, HTML.Attribute.HREF);
        attributes = this.adjustRelativeUrl(attributes, HTML.Attribute.BACKGROUND);
        if (this.currentTag == HTML.Tag.A) {
            attributes = this.adjustTargets(attributes);
        }
        return attributes;
    }

    private MutableAttributeSet adjustTargets(MutableAttributeSet attributes) {
        if (attributes.getAttribute(HTML.Attribute.TARGET) != null) {
            attributes.removeAttribute(HTML.Attribute.TARGET);
        }
        attributes.addAttribute(HTML.Attribute.TARGET, "_blank");
        return attributes;
    }

    private MutableAttributeSet adjustRelativeUrl(MutableAttributeSet attributes, HTML.Attribute attr) {
        if (!(attributes.getAttribute(attr) == null || attributes.getAttribute(attr).toString().toUpperCase().startsWith("HTTP") || attributes.getAttribute(attr).toString().toUpperCase().startsWith("MAILTO") || attributes.getAttribute(attr).toString().toUpperCase().startsWith("FTP"))) {
            String oldValue = attributes.getAttribute(attr).toString();
            attributes.removeAttribute(attr);
            StringBuffer newValue = new StringBuffer();
            if (oldValue.startsWith("/")) {
                if (this.url.indexOf("/", this.url.indexOf("//") + 2) > 0) {
                    newValue.append(this.url.substring(0, this.url.indexOf("/", this.url.indexOf("//") + 2)));
                } else {
                    newValue.append(this.url);
                }
            } else {
                newValue.append(this.url);
                newValue.append("/");
            }
            newValue.append(oldValue);
            attributes.addAttribute(attr, newValue);
        }
        return attributes;
    }

    public String getDocument() {
        return this.document.toString();
    }

    public void flush() {
    }
}

