/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.hovermenu;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.enum.ForcedTextDirection;
import com.sapportals.htmlb.hovermenu.HoverMenu;

public class HoverMenuItem
extends Component {
    private String id;
    private String text;
    private boolean hoverItemDivider = false;
    private HoverMenu subMenu;
    private String onItemClick;
    private String linkRef;
    private String clientSideScript;
    private String target;
    private HoverMenu parent;
    private boolean enabled;
    private String imgSrc;
    private String disabledImgSrc;
    private String altTextForImage;
    private boolean isCheckable;
    private boolean isChecked;
    public static final String UI_ID = "HoverMenuItem";
    private ForcedTextDirection textDirection = ForcedTextDirection.INHERIT;

    public HoverMenuItem(String id, String text) {
        this.id = id;
        this.text = text;
        this.enabled = true;
    }

    public String getUI() {
        return UI_ID;
    }

    public HoverMenuItem(String text, String id, String imgSrc) {
        this.text = text;
        this.id = id;
        this.imgSrc = imgSrc;
        this.enabled = true;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSubHoverMenu(HoverMenu menu) {
        HoverMenu parentMenu;
        this.subMenu = menu;
        menu.setParentItem(this);
        menu.setFirstLevelVisible(false);
        String itemClicked = this.getOnItemClick();
        if (this.subMenu.getOnHoverMenuClick() == null && itemClicked != null) {
            this.subMenu.setOnHoverMenuClick(itemClicked);
        }
        if ((parentMenu = this.getParentMenu()) != null) {
            menu.setRequiresForm(parentMenu.requiresForm());
        }
    }

    public HoverMenu addSubHoverMenu(String id) {
        HoverMenu menu = new HoverMenu(id);
        this.setSubHoverMenu(menu);
        HoverMenu parentMenu = this.getParentMenu();
        if (parentMenu != null) {
            menu.setRequiresForm(parentMenu.requiresForm());
        }
        return menu;
    }

    public HoverMenu getSubMenu() {
        return this.subMenu;
    }

    public boolean hasHoverItemDivider() {
        return this.hoverItemDivider;
    }

    public void setHoverItemDivider(boolean hoverItemDivider) {
        this.hoverItemDivider = hoverItemDivider;
    }

    public String getOnItemClick() {
        return this.onItemClick;
    }

    public void setOnItemClick(String onItemClicked) {
        this.onItemClick = onItemClicked;
        HoverMenu subMenu = this.getSubMenu();
        if (subMenu != null && subMenu.getOnHoverMenuClick() == null && this.getOnItemClick() != null) {
            subMenu.setOnHoverMenuClick(this.getOnItemClick());
        }
    }

    public String getLinkReference() {
        return this.linkRef;
    }

    public void setLinkReference(String linkRef) {
        this.linkRef = linkRef;
    }

    public String getClientSideScript() {
        return this.clientSideScript;
    }

    public void setClientSideScript(String clientSideScript) {
        this.clientSideScript = clientSideScript;
    }

    public String getLinkTarget() {
        return this.target;
    }

    public void setLinkTarget(String target) {
        this.target = target;
    }

    public HoverMenu getParentMenu() {
        return this.parent;
    }

    protected void setParentMenu(HoverMenu parent) {
        this.parent = parent;
    }

    public boolean isDisabled() {
        return !this.enabled;
    }

    public void setDisabled(boolean disabled) {
        this.enabled = !disabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getImgSrc() {
        return this.imgSrc;
    }

    public void setImgSrc(String imgSrc) {
        this.imgSrc = imgSrc;
    }

    public String getAltTextForImage() {
        return this.altTextForImage;
    }

    public void setAltTextForImage(String altTextForImage) {
        this.altTextForImage = altTextForImage;
    }

    public String getDisabledImgSrc() {
        return this.disabledImgSrc;
    }

    public void setDisabledImgSrc(String disabledImgSrc) {
        this.disabledImgSrc = disabledImgSrc;
    }

    public boolean isCheckable() {
        return this.isCheckable;
    }

    public void setCheckable(boolean checkable) {
        this.isCheckable = checkable;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean checked) {
        this.isChecked = checked;
    }

    public ForcedTextDirection getTextDirection() {
        return this.textDirection;
    }

    public void setTextDirection(ForcedTextDirection textDirection) {
        this.textDirection = textDirection;
    }
}

