/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.hovermenu;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.enum.HoverMenuTrigger;
import com.sapportals.htmlb.hovermenu.HoverMenuItem;
import com.sapportals.htmlb.hovermenu.IHoverMenuRootComponent;
import com.sapportals.htmlb.rendering.IHoverMenuRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.util.DefaultHtmlbEncoder;
import com.sapportals.htmlb.util.Log;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class HoverMenu
extends Component {
    public static final String UI_ID = "HoverMenu";
    private String id;
    private String onItemsClicked;
    private IHoverMenuRenderer renderer;
    private ArrayList menuItems = new ArrayList();
    private int[] indxCheckedItems;
    private String onHoverMenuClick;
    private IHoverMenuRootComponent rootComponent;
    private HoverMenuItem parentItem;
    private HoverMenuTrigger menuTrigger;
    private boolean firstLevelVisible = true;
    private boolean isRequiresForm = true;

    public HoverMenu(String id) {
        super(id);
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRenderer(IHoverMenuRenderer renderer) {
        this.renderer = renderer;
    }

    public void setOnHoverMenuClick(String onHoverMenuClick) {
        this.onHoverMenuClick = onHoverMenuClick;
        int count = this.getMenuItemCount();
        int i = 0;
        while (i < count) {
            HoverMenuItem item = this.getMenuItemAt(i);
            String onHoverMenuClicked = this.getOnHoverMenuClick();
            if (item.getOnItemClick() == null && onHoverMenuClicked != null) {
                item.setOnItemClick(onHoverMenuClicked);
            }
            ++i;
        }
    }

    public String getUI() {
        return UI_ID;
    }

    public String getId() {
        return this.id;
    }

    public HoverMenuItem getMenuItemAt(int i) {
        return (HoverMenuItem)this.menuItems.get(i);
    }

    public int getMenuItemCount() {
        return this.menuItems.size();
    }

    public Iterator getMenuItemsIterator() {
        return ((AbstractList)this.menuItems).iterator();
    }

    public IHoverMenuRenderer getRenderer() {
        return this.renderer;
    }

    public String getOnHoverMenuClick() {
        return this.onHoverMenuClick;
    }

    public IHoverMenuRootComponent getRootComponent() {
        return this.rootComponent;
    }

    public HoverMenuItem getParentItem() {
        return this.parentItem;
    }

    public void addMenuItem(HoverMenuItem item) {
        this.menuItems.add(item);
        item.setParentMenu(this);
        String itemClick = this.getOnHoverMenuClick();
        if (item.getOnItemClick() == null && itemClick != null) {
            item.setOnItemClick(itemClick);
        }
    }

    public HoverMenuItem addMenuItem(String key, String title) {
        HoverMenuItem item = new HoverMenuItem(key, title);
        this.addMenuItem(item);
        return item;
    }

    public boolean hasRootComponent() {
        return this.rootComponent != null;
    }

    public void setRootComponent(IHoverMenuRootComponent rootComponent) {
        this.rootComponent = rootComponent;
    }

    protected void setParentItem(HoverMenuItem parentItem) {
        this.parentItem = parentItem;
    }

    public HoverMenuTrigger getMenuTrigger() {
        return this.menuTrigger;
    }

    public void setMenuTrigger(HoverMenuTrigger trigger) {
        this.menuTrigger = trigger;
    }

    public boolean isFirstLevelInvisible() {
        return !this.firstLevelVisible;
    }

    public void setFirstLevelnvisible(boolean firstLevelInvisible) {
        this.firstLevelVisible = !firstLevelInvisible;
    }

    public boolean isFirstLevelVisible() {
        return this.firstLevelVisible;
    }

    public void setFirstLevelVisible(boolean firstLevelVisible) {
        this.firstLevelVisible = firstLevelVisible;
    }

    public int getMenuDepth() {
        int depth = 0;
        int maxDepth = 0;
        if (!this.menuItems.isEmpty()) {
            return this.getMenuDepth(this, depth + 1, maxDepth);
        }
        return maxDepth;
    }

    private int getMenuDepth(HoverMenu menu, int depth, int maxDepth) {
        if (depth >= maxDepth) {
            maxDepth = depth;
        }
        Iterator menuIt = menu.getMenuItemsIterator();
        while (menuIt.hasNext()) {
            HoverMenuItem item = (HoverMenuItem)menuIt.next();
            HoverMenu subMenu = item.getSubMenu();
            if (subMenu == null) continue;
            maxDepth = this.getMenuDepth(subMenu, depth + 1, maxDepth);
        }
        return maxDepth;
    }

    protected void initFromPageContext(IPageContext pc, String baseId) {
        String items = pc.getParameter(baseId + "_itm");
        String checkedItems = pc.getParameter(baseId + "_chkitm");
        if (items != null && items.length() > 0) {
            try {
                DefaultHtmlbEncoder encoder = new DefaultHtmlbEncoder();
                encoder.prepareDecoding(items);
                String itemId = null;
                itemId = encoder.getStringProperty();
                int i = 0;
                while (itemId != null) {
                    HoverMenuItem item = this.addMenuItem(itemId, "");
                    if (checkedItems != null && checkedItems.indexOf("+" + i + "+") >= 0) {
                        item.setChecked(true);
                    }
                    itemId = encoder.getStringProperty();
                    ++i;
                }
            }
            catch (IOException e) {
                Log.getLogLocation(false).debugT("Should not happen: HoverMenu", "initFromPageContext");
            }
        }
    }

    public String getEncodedItems() {
        try {
            DefaultHtmlbEncoder encoder = new DefaultHtmlbEncoder();
            encoder.prepareEncoding();
            Iterator menuIt = this.getMenuItemsIterator();
            while (menuIt.hasNext()) {
                HoverMenuItem item = (HoverMenuItem)menuIt.next();
                encoder.addProperty(item.getId());
            }
            return encoder.getEncodedString();
        }
        catch (IOException e) {
            Log.getLogLocation(false).debugT("Should not happen: HoverMenu", "getEncodedItems");
            return null;
        }
    }

    public String getItemsStatus() {
        StringBuffer checkedItems = new StringBuffer("+");
        Iterator menuIt = this.getMenuItemsIterator();
        int i = 0;
        while (menuIt.hasNext()) {
            HoverMenuItem item = (HoverMenuItem)menuIt.next();
            if (item.isChecked()) {
                checkedItems.append(i + "+");
            }
            ++i;
        }
        return checkedItems.toString();
    }

    public void updateItemStatus(HoverMenu menu) {
        Iterator menuIt = menu.getMenuItemsIterator();
        while (menuIt.hasNext()) {
            HoverMenuItem myItem;
            HoverMenuItem item = (HoverMenuItem)menuIt.next();
            if (!item.isChecked() || (myItem = this.getMenuItemById(item.getId())) == null) continue;
            myItem.setChecked(true);
        }
    }

    public HoverMenuItem getMenuItemById(String Id) {
        Iterator menuIt = this.getMenuItemsIterator();
        while (menuIt.hasNext()) {
            HoverMenuItem item = (HoverMenuItem)menuIt.next();
            if (!item.getId().equalsIgnoreCase(Id)) continue;
            return item;
        }
        return null;
    }

    public boolean requiresForm() {
        HoverMenu parentMenu = this;
        HoverMenuItem parentItem = this.getParentItem();
        while (parentItem != null) {
            parentMenu = parentItem.getParentMenu();
            parentItem = parentMenu.getParentItem();
        }
        return parentMenu.isRequiresForm;
    }

    public void setRequiresForm(boolean requiresForm) {
        this.isRequiresForm = requiresForm;
    }

    public boolean hasCheckableItems() {
        Iterator menuIt = this.getMenuItemsIterator();
        while (menuIt.hasNext()) {
            if (!((HoverMenuItem)menuIt.next()).isCheckable()) continue;
            return true;
        }
        return false;
    }
}

