/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.event;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.enum.TableNavigationMode;
import com.sapportals.htmlb.event.Event;
import com.sapportals.htmlb.event.EventManager;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.table.TableView;

public class TableNavigationEvent
extends Event {
    public static final String EVENT_TOP = "top";
    public static final String EVENT_PAGEUP = "pageUp";
    public static final String EVENT_LINEUP = "lineUp";
    public static final String EVENT_LINEDOWN = "lineDown";
    public static final String EVENT_PAGEDOWN = "pageDown";
    public static final String EVENT_BOTTOM = "bottom";
    int firstVisibleRow;
    int lastVisibleRow;
    int visibleRowCount;
    int rowCount;
    String navigationType;
    TableNavigationMode navigationMode;
    static /* synthetic */ Class class$com$sapportals$htmlb$event$TableNavigationEvent;

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public int getFirstVisibleRow() {
        return this.firstVisibleRow;
    }

    public int getTableRowCount() {
        return this.rowCount;
    }

    public String getNavigationType() {
        return this.navigationType;
    }

    public TableNavigationMode getNavigationMode() {
        return this.navigationMode;
    }

    public int getFirstVisibleRowAfter() {
        String navType = this.getNavigationType();
        if (navType.equals(EVENT_PAGEDOWN)) {
            return this.getLastVisibleRow() + 1;
        }
        if (navType.equals(EVENT_LINEDOWN)) {
            return this.firstVisibleRow + 1;
        }
        if (navType.equals(EVENT_BOTTOM)) {
            int i = this.rowCount % this.visibleRowCount;
            if (i == 0) {
                i = this.visibleRowCount;
            }
            return this.rowCount - i + 1;
        }
        if (navType.equals(EVENT_TOP)) {
            return 1;
        }
        if (navType.equals(EVENT_LINEUP)) {
            return this.getFirstVisibleRow() - 1;
        }
        if (navType.equals(EVENT_PAGEUP)) {
            int firstVisible = this.getFirstVisibleRow();
            int visible = this.getVisibleRowCount();
            if (firstVisible > this.visibleRowCount) {
                return this.getFirstVisibleRow() - this.getVisibleRowCount();
            }
            return 1;
        }
        return Integer.MIN_VALUE;
    }

    public int getLastVisibleRow() {
        return this.lastVisibleRow;
    }

    protected void setParams(String[] params) {
        if (params.length == 5) {
            try {
                this.navigationType = params[0];
                this.firstVisibleRow = Integer.parseInt(params[1]);
                this.visibleRowCount = Integer.parseInt(params[2]);
                this.lastVisibleRow = this.firstVisibleRow + this.visibleRowCount - 1;
                this.rowCount = Integer.parseInt(params[3]);
                if (this.lastVisibleRow > this.rowCount) {
                    this.lastVisibleRow = this.rowCount;
                }
                if ("L".equals(params[4])) {
                    this.navigationMode = TableNavigationMode.BYLINE;
                }
                this.navigationMode = TableNavigationMode.BYPAGE;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("TableNavigationEvent parameters must be of type int");
            }
        } else {
            throw new IllegalArgumentException("Wrong number of params for TableNavigationEvent");
        }
    }

    public static String renderEventCall(IPageContext pageContext, TableView tableView, String eventClass) {
        String onClick = tableView.getOnNavigate();
        if (onClick != null) {
            Object[] params = new Object[]{eventClass, Integer.toString(tableView.getVisibleFirstRow()), Integer.toString(tableView.getVisibleRowCount()), Integer.toString(tableView.getRowCount()), TableNavigationMode.BYLINE == tableView.getNavigationMode() ? "L" : "P"};
            return EventManager.renderEventCall(pageContext, class$com$sapportals$htmlb$event$TableNavigationEvent == null ? (class$com$sapportals$htmlb$event$TableNavigationEvent = TableNavigationEvent.class$("com.sapportals.htmlb.event.TableNavigationEvent")) : class$com$sapportals$htmlb$event$TableNavigationEvent, null, (Component)tableView, onClick, null, params);
        }
        return "";
    }

    public String toString() {
        return super.toString() + " navigationType:'" + this.navigationType + "' firstVisibleRow:'" + this.firstVisibleRow + "' lastVisibleRow:'" + this.lastVisibleRow + "' visibleRowCount:'" + this.visibleRowCount + "' rowCount:'" + this.rowCount + "'";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

