/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb.event;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Form;
import com.sapportals.htmlb.JavascriptFragment;
import com.sapportals.htmlb.event.Event;
import com.sapportals.htmlb.event.EventModifierData;
import com.sapportals.htmlb.rendering.IEventRenderer;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.rendering.RendererManager;
import com.sapportals.htmlb.util.Log;
import java.util.ArrayList;

public class EventManager {
    private static EventManager instance;
    ArrayList eventClasses = null;
    ArrayList eventNames = null;
    private static Object[] eventDefaults;

    private EventManager() {
        this.initDefaults();
    }

    private void initDefaults() {
        int n = eventDefaults.length;
        this.eventClasses = new ArrayList(n / 2);
        this.eventNames = new ArrayList(n / 2);
        int i = 0;
        while (i < eventDefaults.length) {
            this.addEventClass((String)eventDefaults[i], (Class)eventDefaults[i + 1]);
            i += 2;
        }
    }

    private void addEventClass(String eventId, Class eventClass) {
        this.eventClasses.add(eventClass);
        this.eventNames.add(eventId);
    }

    private int getIdForName(String name) {
        return this.eventNames.indexOf(name);
    }

    static EventManager getInstance() {
        if (instance == null) {
            instance = new EventManager();
        }
        return instance;
    }

    private Event internalCreateEvent(IPageContext pc, String eventType, String eventAction, String componentName, String[] params) throws Exception {
        Form myForm;
        Class<?> eventJavaClass;
        boolean isModified;
        Event theEvent;
        block19: {
            theEvent = null;
            isModified = false;
            if (eventType.startsWith("*")) {
                isModified = true;
                eventType = eventType.substring(1);
            }
            eventJavaClass = null;
            myForm = pc.getOldForm();
            int eventIndex = -1;
            try {
                eventIndex = Integer.parseInt(eventType);
                String className = myForm.getEventNameForId(eventIndex);
                if (className != null) {
                    eventJavaClass = pc.getClassLoader() == null ? Class.forName(className) : Class.forName(className, true, pc.getClassLoader());
                }
            }
            catch (NumberFormatException e) {
                Log.getLogLocation(false).debugT("Should not happen: EventManager", "internalCreateEvent");
            }
            catch (ClassNotFoundException e) {
                if (eventIndex < 0) break block19;
                eventJavaClass = (Class)this.eventClasses.get(eventIndex);
            }
        }
        if (eventJavaClass != null) {
            try {
                theEvent = (Event)eventJavaClass.newInstance();
            }
            catch (InstantiationException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                throw e;
            }
            try {
                theEvent.setAction(myForm.getEventNameForId(Integer.parseInt(eventAction)));
            }
            catch (NumberFormatException e) {
                theEvent.setAction(eventAction);
            }
            int index = -1;
            try {
                index = Integer.parseInt(componentName);
            }
            catch (NumberFormatException e) {
                Log.getLogLocation(false).debugT("Should not happen: EventManager", "internalCreateEvent");
            }
            if (index >= 0) {
                componentName = myForm.getUserIdForIndex(index);
                theEvent.elementId = index;
            }
            if (!isModified) {
                theEvent.setComponentName(componentName);
            }
            if (params != null) {
                if (isModified) {
                    this.processModifierData(params[0], myForm, theEvent);
                    theEvent.setComponentName(componentName);
                    int n = params.length - 1;
                    if (n > 0) {
                        String[] params2 = new String[n];
                        System.arraycopy(params, 1, params2, 0, n);
                        theEvent.setParams(params2);
                    }
                } else {
                    theEvent.setParams(params);
                }
            }
        }
        return theEvent;
    }

    void processModifierData(String params, Form myForm, Event theEvent) {
        int colIndex0 = 0;
        int sep = -1;
        EventModifierData root = null;
        do {
            int colIndex1 = params.indexOf(":", colIndex0);
            int colIndex2 = params.indexOf(":", colIndex1 + 1);
            sep = params.indexOf(":", colIndex2 + 1);
            String componentId = params.substring(colIndex0, colIndex1);
            String modClassId = params.substring(colIndex1 + 1, colIndex2);
            String payload = null;
            String componentName = null;
            EventModifierData instance = null;
            payload = sep >= 0 ? params.substring(colIndex2 + 1, sep) : params.substring(colIndex2 + 1);
            try {
                componentName = myForm.getUserIdForIndex(Integer.parseInt(componentId));
            }
            catch (NumberFormatException e) {
                Log.getLogLocation(false).debugT("Should not happen: EventManager", "internalCreateEvent");
            }
            try {
                Class modClass = myForm.getClassForId(Integer.parseInt(modClassId));
                instance = (EventModifierData)modClass.newInstance();
                instance.setDataAsString(payload);
                instance.setComponentName(componentName);
                if (root == null) {
                    root = instance;
                } else {
                    EventModifierData temp = root;
                    while (temp.getParent() != null) {
                        temp = temp.getParent();
                    }
                    temp.setParent(instance);
                }
            }
            catch (NumberFormatException e) {
                Log.getLogLocation(false).debugT("Should not happen: EventManager", "internalCreateEvent");
            }
            catch (InstantiationException e) {
                Log.getLogLocation(false).debugT("Should not happen: EventManager", "internalCreateEvent");
            }
            catch (IllegalAccessException e) {
                Log.getLogLocation(false).debugT("Should not happen: EventManager", "internalCreateEvent");
            }
            colIndex0 = sep + 1;
        } while (sep >= 0);
        theEvent.setModifierData(root);
    }

    public static String renderEventCall(IPageContext pc, String eventId, String eventType, Component c, String serverEvent, String clientEvent, int paramCount, String paramString) {
        EventManager instance = EventManager.getInstance();
        int myIndex = instance.eventNames.indexOf(eventId);
        if (myIndex >= 0) {
            Class clss = (Class)instance.eventClasses.get(myIndex);
            return EventManager.renderEventCall(pc, clss, eventType, c, serverEvent, clientEvent, paramCount, paramString);
        }
        return "";
    }

    public static String renderEventCall(IPageContext pc, String eventId, String eventType, Component c, String serverEvent, String clientEvent, Object[] params) {
        EventManager instance = EventManager.getInstance();
        int myIndex = instance.eventNames.indexOf(eventId);
        if (myIndex >= 0) {
            Class clss = (Class)instance.eventClasses.get(myIndex);
            return EventManager.renderEventCall(pc, clss, eventType, c, serverEvent, clientEvent, params);
        }
        return "";
    }

    public static String renderEventCall(IPageContext pc, Class eventClass, String eventType, Component c, String serverEvent, String clientEvent, int paramCount, String paramString) {
        return EventManager.renderEventCall(pc, eventClass, eventType, c, serverEvent, clientEvent, false, true, false, paramCount, paramString);
    }

    public static String renderEventCall(IPageContext pc, Class eventClass, String eventType, Component c, String serverEvent, String clientEvent, boolean validateControl, boolean validateForm, boolean defaultReturn, Object[] params) {
        IEventRenderer myEventRenderer = RendererManager.getEventRenderer(pc.getBrowserId());
        return myEventRenderer.renderEventCall(pc, eventClass, eventType, c, serverEvent, clientEvent, validateControl, validateForm, defaultReturn, params);
    }

    public static String renderEventCall(IPageContext pc, Class eventClass, String eventType, Component c, String serverEvent, String clientEvent, Object[] params) {
        IEventRenderer myEventRenderer = RendererManager.getEventRenderer(pc.getBrowserId());
        return myEventRenderer.renderEventCall(pc, eventClass, eventType, c, serverEvent, clientEvent, false, true, false, params);
    }

    public static String renderEventCall(IPageContext pc, Class eventClass, String eventType, Component c, String serverEvent, String clientEvent, boolean validateControl, boolean validateForm, boolean defaultReturn, int paramCount, String paramString) {
        IEventRenderer myEventRenderer = RendererManager.getEventRenderer(pc.getBrowserId());
        return myEventRenderer.renderEventCall(pc, eventClass, eventType, c, serverEvent, clientEvent, validateControl, validateForm, defaultReturn, paramCount, paramString);
    }

    public static String getJavaScriptFunctionName(IPageContext pc, Component c, String eventType) {
        String type = eventType == null ? "dflt" : eventType;
        return pc.getParamIdForComponent(c) + '_' + type;
    }

    public static String renderJavaScriptFragment(IPageContext pc, Component c, String eventType, String codeFragment) {
        if (codeFragment != null) {
            StringBuffer result = new StringBuffer(codeFragment.length() + 80);
            result.append("function ");
            String myName = EventManager.getJavaScriptFunctionName(pc, c, eventType);
            result.append(myName);
            result.append("(htmlbevent){");
            result.append(codeFragment);
            result.append(";}\n");
            pc.getCurrentForm().addFormEndJavascript(new JavascriptFragment(c.getId(), result.toString(), c, pc.getParamIdForComponent(c)));
        }
        return "";
    }

    public static Event createEvent(IPageContext pc, String eventType, String eventAction, String componentName, String[] params) throws Exception {
        return EventManager.getInstance().internalCreateEvent(pc, eventType, eventAction, componentName, params);
    }

    public static Event createEvent(String eventClass, String eventAction, String componentName, String[] params) throws Exception {
        Event theEvent = null;
        boolean isModified = false;
        Class<?> eventJavaClass = null;
        try {
            eventJavaClass = Class.forName(eventClass);
        }
        catch (ClassNotFoundException e) {
            Log.getLogLocation(false).debugT("Should not happen: EventManager", "createEvent");
        }
        if (eventJavaClass != null) {
            try {
                theEvent = (Event)eventJavaClass.newInstance();
            }
            catch (InstantiationException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                throw e;
            }
            theEvent.setAction(eventAction);
            theEvent.setComponentName(componentName);
            if (params != null) {
                theEvent.setParams(params);
            }
        }
        return theEvent;
    }

    public static void registerEvent(String uniqueId, Class eventClass) {
        EventManager.getInstance().addEventClass(uniqueId, eventClass);
    }

    static {
        eventDefaults = new Object[0];
    }
}

