/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class VersionInfo {
    private static final String packageVersion = "HTML Business for Java, 6.0";
    private static final String id = "$Id: //javabas/com.sapportals.htmlb/dev/src/java/core/com/sapportals/htmlb/VersionInfo.java#21 $";
    private static final String header = "$Header: //javabas/com.sapportals.htmlb/dev/src/java/core/com/sapportals/htmlb/VersionInfo.java#21 $";
    private static final String date = "$Date: 2003/06/17 $";
    private static final String dateTime = "$DateTime: 2003/06/17 15:18:22 $";
    private static final String change = "$Change: 156751 $";
    private static final String file = "$File: //javabas/com.sapportals.htmlb/dev/src/java/core/com/sapportals/htmlb/VersionInfo.java $";
    private static final String revision = "$Revision: #21 $";
    private static final String author = "$Author: d000924 $";
    private static String manifestVersion = VersionInfo.readManifest();
    static /* synthetic */ Class class$com$sapportals$htmlb$VersionInfo;

    public static String getId() {
        return id.substring(1, id.length() - 2);
    }

    public static String getAuthor() {
        return author.substring(1, author.length() - 2);
    }

    public static String getChange() {
        return change.substring(1, change.length() - 2);
    }

    public static String getDate() {
        return date.substring(1, date.length() - 2);
    }

    public static String getDateTime() {
        return dateTime.substring(1, dateTime.length() - 2);
    }

    public static String getFile() {
        return file.substring(1, file.length() - 2);
    }

    public static String getHeader() {
        return header.substring(1, header.length() - 2);
    }

    public static String getRevision() {
        return revision.substring(1, revision.length() - 2);
    }

    public static String getVersion() {
        if (manifestVersion != null) {
            return manifestVersion;
        }
        return packageVersion;
    }

    private static String readManifest() {
        String cn = (class$com$sapportals$htmlb$VersionInfo == null ? (class$com$sapportals$htmlb$VersionInfo = VersionInfo.class$("com.sapportals.htmlb.VersionInfo")) : class$com$sapportals$htmlb$VersionInfo).getName().replace('.', '/') + ".class";
        String jar = (class$com$sapportals$htmlb$VersionInfo == null ? (class$com$sapportals$htmlb$VersionInfo = VersionInfo.class$("com.sapportals.htmlb.VersionInfo")) : class$com$sapportals$htmlb$VersionInfo).getClassLoader().getResource(cn).toString();
        String release = null;
        String changelist = null;
        String date = null;
        if (jar.startsWith("jar:file:")) {
            JarFile jf;
            File file;
            int n = 9;
            if (jar.startsWith("jar:file:/") && jar.charAt(11) == ':') {
                n = 10;
            }
            String jarFilePath = jar.substring(n, jar.indexOf("!"));
            try {
                file = new File(jarFilePath);
                if (file != null) {
                    JarEntry je;
                    jf = new JarFile(file);
                    Manifest mf = jf.getManifest();
                    if (mf != null) {
                        Map<String, Attributes> m;
                        Attributes a;
                        Attributes attr = mf.getMainAttributes();
                        if (attr != null && (changelist = attr.getValue("Changelist")) != null && changelist.equalsIgnoreCase("${changelistnumber}")) {
                            changelist = "local build";
                        }
                        if ((a = (m = mf.getEntries()).get("origin")) != null) {
                            release = a.getValue("release");
                        }
                    }
                    if ((je = jf.getJarEntry("META-INF/Manifest.mf")) == null) {
                        je = jf.getJarEntry(cn);
                    }
                    if (je != null) {
                        date = new Date(je.getTime()).toString();
                    }
                }
            }
            catch (IOException e) {
                Log.getLogLocation(false).debugT("Version Info", "readManifest " + e.getMessage());
            }
            if (release != null) {
                manifestVersion = "HTML Business for Java, " + release + ", " + changelist + ", " + date;
            } else {
                try {
                    JarEntry je;
                    file = new File(jarFilePath);
                    if (file != null && (je = (jf = new JarFile(file)).getJarEntry("META-INF/buildinfo.xml")) != null) {
                        date = new Date(je.getTime()).toString();
                        InputStream i = jf.getInputStream(je);
                        if (i != null) {
                            BufferedReader content = new BufferedReader(new InputStreamReader(i));
                            String buffer = null;
                            int pos = 0;
                            boolean rel = false;
                            boolean cl = false;
                            while (!((buffer = content.readLine()) == null || rel && cl)) {
                                if (!rel && (pos = buffer.indexOf("RELEASE=\"")) > -1) {
                                    release = buffer.substring(pos + 9, buffer.indexOf("\"", pos + 9));
                                    rel = true;
                                }
                                if (cl || (pos = buffer.indexOf("CHANGELIST=\"")) <= -1) continue;
                                changelist = buffer.substring(pos + 12, buffer.indexOf("\"", pos + 12));
                                cl = true;
                            }
                        }
                    }
                }
                catch (IOException e) {
                    Log.getLogLocation(false).debugT("Version Info", "readManifest " + e.getMessage());
                }
                if (release != null) {
                    manifestVersion = "HTML Business for Java, " + release + ", " + changelist + ", " + date;
                }
            }
        }
        return manifestVersion;
    }

    public static String dump() {
        StringBuffer result = new StringBuffer(400);
        result.append(VersionInfo.getVersion());
        result.append("\n\n");
        result.append(VersionInfo.getId());
        result.append('\n');
        result.append(VersionInfo.getAuthor());
        result.append('\n');
        result.append(VersionInfo.getChange());
        result.append('\n');
        result.append(VersionInfo.getDateTime());
        result.append('\n');
        result.append(VersionInfo.getFile());
        result.append('\n');
        result.append(VersionInfo.getHeader());
        result.append('\n');
        result.append(VersionInfo.getRevision());
        result.append('\n');
        return result.toString();
    }

    public static void main(String[] args) {
        System.out.println(VersionInfo.getVersion());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

