/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.IChartModel;
import java.io.Serializable;
import java.util.ArrayList;

public class VectorChartModel
implements IChartModel,
Serializable {
    String nameOfKeyColumn;
    String nameOfValueColumn;
    ArrayList groupids = new ArrayList();
    ArrayList xs = new ArrayList();
    ArrayList ys = new ArrayList();
    ArrayList zs = new ArrayList();
    ArrayList colors = new ArrayList();
    ArrayList extensions = new ArrayList();
    int curRow = 0;

    public void addItem(String groupid, String x, String y, String color, String extension) {
        if (color == null) {
            color = "";
        }
        if (extension == null) {
            extension = "";
        }
        this.groupids.add(groupid);
        this.xs.add(x);
        this.ys.add(y);
        this.zs.add(" ");
        this.colors.add(color);
        this.extensions.add(extension);
    }

    public void addItem(String groupid, String x, String y, String color, String url, String altText) {
        this.groupids.add(groupid);
        this.xs.add(x);
        this.ys.add(y);
        this.zs.add(" ");
        if (color != null) {
            this.colors.add(color);
        } else {
            this.colors.add(" ");
        }
        String extension = "";
        if (url != null) {
            extension = extension + "href=\"" + url + "\" ";
        }
        if (altText != null) {
            extension = extension + "alt=\"" + altText + "\" ";
        }
        this.extensions.add(extension);
    }

    public int getRow() {
        return this.curRow;
    }

    public int getRow(int which) {
        if (which < 0 || which > this.groupids.size()) {
            throw new IndexOutOfBoundsException("Illegal row: " + which);
        }
        this.curRow = which;
        return this.curRow;
    }

    public int firstRow() {
        this.curRow = 0;
        return this.curRow;
    }

    public boolean nextRow() {
        if (this.curRow < this.groupids.size() - 1) {
            ++this.curRow;
            return true;
        }
        return false;
    }

    public String getFieldName(int which) {
        switch (which) {
            case 0: {
                return "GROUPID";
            }
            case 1: {
                return "X";
            }
            case 2: {
                return "Y";
            }
            case 3: {
                return "EXTENSION";
            }
            case 4: {
                return "COLOR";
            }
        }
        return "";
    }

    public String getFieldValue(int which) {
        switch (which) {
            case 0: {
                return (String)this.groupids.get(this.curRow);
            }
            case 1: {
                return (String)this.xs.get(this.curRow);
            }
            case 2: {
                return (String)this.ys.get(this.curRow);
            }
            case 3: {
                return (String)this.extensions.get(this.curRow);
            }
            case 4: {
                return (String)this.colors.get(this.curRow);
            }
        }
        return "";
    }

    public String getGroupId() {
        return (String)this.groupids.get(this.curRow);
    }

    public String getX() {
        return (String)this.xs.get(this.curRow);
    }

    public String getY() {
        return (String)this.ys.get(this.curRow);
    }

    public String getExtension() {
        return (String)this.extensions.get(this.curRow);
    }

    public String getColor() {
        return (String)this.colors.get(this.curRow);
    }

    public int getNumColumns() {
        return 5;
    }

    public int getNumRows() {
        return this.groupids.size();
    }
}

