/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Tree;
import com.sapportals.htmlb.enum.ForcedTextDirection;
import com.sapportals.htmlb.hovermenu.HoverMenu;
import com.sapportals.htmlb.util.IHtmlbEncoder;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class TreeNode {
    private String id;
    private String text;
    private Component component;
    private TreeNode parent;
    private Vector children;
    private String onNodeClick;
    private String onNodeExpand;
    private String onNodeClose;
    private String tooltip;
    private boolean isOpen;
    private boolean isEncode;
    private HoverMenu hoverMenu;
    private Tree tree;
    private boolean showExpander;
    private ForcedTextDirection textDirection = ForcedTextDirection.INHERIT;

    public TreeNode(String id) {
        this(id, "NoText");
    }

    public TreeNode(String id, String text) {
        this.setID(id);
        this.setText(text);
        this.setOpen(false);
    }

    public TreeNode(String id, String text, TreeNode parent) {
        this.setID(id);
        this.setText(text);
        if (parent != null) {
            parent.addChildNode(this);
        }
        this.setOpen(false);
    }

    public TreeNode(String id, String text, TreeNode parent, boolean isOpen) {
        this.setID(id);
        this.setText(text);
        if (parent != null) {
            parent.addChildNode(this);
        }
        this.setOpen(isOpen);
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public Component getComponent() {
        return this.component;
    }

    public Object getContent() {
        if (this.component != null) {
            return this.component;
        }
        return this.text;
    }

    public void addChildNode(TreeNode node) {
        this.getChildVector().add(node);
        node.parent = this;
    }

    public void removeChildNode(TreeNode node) {
        this.getChildVector().remove(node);
    }

    public void removeAllChilren() {
        this.getChildVector().clear();
    }

    public void removeAllChildren() {
        this.getChildVector().clear();
    }

    public Enumeration getChildNodes() {
        return this.getChildVector().elements();
    }

    public TreeNode getParentNode() {
        return this.parent;
    }

    public void setParentNode(TreeNode parent) {
        if (this.parent != null) {
            this.parent.removeChildNode(this);
        }
        parent.getChildVector().add(this);
        this.parent = parent;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public void setOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean hasChilds() {
        return this.hasChildren();
    }

    public boolean hasChildren() {
        return !this.getChildVector().isEmpty() || this.isShowExpander();
    }

    public void setOnNodeClick(String onNodeClick) {
        this.onNodeClick = onNodeClick;
    }

    public String getOnNodeClick() {
        return this.onNodeClick;
    }

    public String getOnNodeExpand() {
        return this.onNodeExpand;
    }

    public void setOnNodeExpand(String onNodeExpand) {
        this.onNodeExpand = onNodeExpand;
    }

    public String getOnNodeClose() {
        return this.onNodeClose;
    }

    public void setOnNodeClose(String onNodeClose) {
        this.onNodeClose = onNodeClose;
    }

    public TreeNode getNodeByID(String id) {
        if (this.id.equals(id)) {
            return this;
        }
        Enumeration children = this.getChildVector().elements();
        while (children.hasMoreElements()) {
            TreeNode child = (TreeNode)children.nextElement();
            if (child.getID().equals(id)) {
                return child;
            }
            if ((child = child.getNodeByID(id)) == null) continue;
            return child;
        }
        return null;
    }

    public void encodeTreeNode(IHtmlbEncoder encoder) throws IOException {
        encoder.addProperty(this.getID());
        if (this.hasChilds()) {
            encoder.addProperty("+");
            Enumeration childs = this.getChildNodes();
            while (childs.hasMoreElements()) {
                TreeNode child = (TreeNode)childs.nextElement();
                child.encodeTreeNode(encoder);
            }
            encoder.addProperty("-");
        }
    }

    public void updateNodeStatus(Tree tree) {
        TreeNode rootNode = tree.getRootNode();
        if (rootNode != null) {
            TreeNode referenceNode = rootNode.getNodeByID(this.getID());
            if (referenceNode != null) {
                this.setOpen(referenceNode.isOpen());
            }
            Enumeration childs = this.getChildVector().elements();
            while (childs.hasMoreElements()) {
                TreeNode child = (TreeNode)childs.nextElement();
                child.updateNodeStatus(tree);
            }
        } else {
            throw new IllegalStateException("Reconstructed Tree doesn't have a root node");
        }
    }

    public String getNodeStatus() {
        StringBuffer status = new StringBuffer();
        int nodeIndex = 1;
        this.collectNodeStatusString(nodeIndex, status);
        return status.toString();
    }

    public int collectNodeStatusString(int nodeIndex, StringBuffer status) {
        if (this.isOpen()) {
            status.append(':');
            status.append(nodeIndex);
            status.append(':');
            status.append("+");
        }
        Enumeration childs = this.getChildVector().elements();
        while (childs.hasMoreElements()) {
            ++nodeIndex;
            TreeNode child = (TreeNode)childs.nextElement();
            nodeIndex = child.collectNodeStatusString(nodeIndex, status);
        }
        return nodeIndex;
    }

    public HoverMenu getHoverMenu() {
        return this.hoverMenu;
    }

    public void setHoverMenu(HoverMenu hoverMenu) {
        this.hoverMenu = hoverMenu;
        hoverMenu.setFirstLevelVisible(false);
    }

    private Vector getChildVector() {
        if (this.children == null) {
            this.children = new Vector();
        }
        return this.children;
    }

    public Tree getTree() {
        return this.tree;
    }

    public void setTree(Tree tree) {
        this.tree = tree;
    }

    public boolean isEncode() {
        return this.isEncode;
    }

    public void setEncode(boolean encode) {
        this.isEncode = encode;
    }

    public boolean isShowExpander() {
        return this.showExpander;
    }

    public void setShowExpander(boolean showExpander) {
        this.showExpander = showExpander;
    }

    public ForcedTextDirection getTextDirection() {
        return this.textDirection;
    }

    public void setTextDirection(ForcedTextDirection textDirection) {
        this.textDirection = textDirection;
    }
}

