/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.TreeNode;
import com.sapportals.htmlb.enum.ForcedTextDirection;
import com.sapportals.htmlb.hovermenu.HoverMenu;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.util.DefaultHtmlbEncoder;
import com.sapportals.htmlb.util.Log;
import java.io.IOException;
import java.util.Stack;

public class Tree
extends Component {
    public static final String UI_ID = "Tree";
    public static final int TREE_BEGIN = 0;
    public static final int TREE_END = 1;
    public static final String TREE_HIERARCHY = "Nodes";
    public static final String TREE_LAYOUT = "Eln";
    private String title;
    private String height;
    private TreeNode rootNode;
    private String onTreeClick;
    private String tooltip;
    private boolean rootNodeIsVisible = true;
    private int offsetForTreeNode;
    private transient int nodeId;
    private ForcedTextDirection textDirection = ForcedTextDirection.INHERIT;

    public String getUI() {
        return UI_ID;
    }

    protected Tree() {
        this("A HTMLBusiness for Java tree");
    }

    public Tree(String name) {
        this.setId(name);
    }

    public Tree(String name, String title) {
        this.setId(name);
        this.setTitle(title);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public void setRootNode(TreeNode rootNode) {
        this.rootNode = rootNode;
        rootNode.setTree(this);
        if (!this.rootNodeIsVisible) {
            this.rootNode.setOpen(true);
        }
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public void setOnTreeClick(String onTreeClick) {
        this.onTreeClick = onTreeClick;
    }

    public String getOnTreeClick() {
        return this.onTreeClick;
    }

    public TreeNode expandNodeById(String id) {
        if (this.rootNode == null) {
            return null;
        }
        TreeNode node = this.rootNode.getNodeByID(id);
        if (node != null) {
            node.setOpen(true);
        }
        return node;
    }

    public TreeNode collapseNodeById(String id) {
        if (this.rootNode == null) {
            return null;
        }
        TreeNode node = this.rootNode.getNodeByID(id);
        if (node != null) {
            node.setOpen(false);
        }
        return node;
    }

    public void setRootNodeIsVisible(boolean rootNodeIsVisible) {
        this.rootNodeIsVisible = rootNodeIsVisible;
        if (!rootNodeIsVisible && this.rootNode != null) {
            this.rootNode.setOpen(true);
        }
    }

    public boolean rootNodeIsVisible() {
        return this.isRootNodeVisible();
    }

    public boolean isRootNodeVisible() {
        return this.rootNodeIsVisible;
    }

    public String getEncodedTreeHierachy() {
        try {
            DefaultHtmlbEncoder encoder = new DefaultHtmlbEncoder();
            encoder.prepareEncoding();
            if (this.rootNode != null) {
                this.rootNode.encodeTreeNode(encoder);
            }
            return encoder.getEncodedString();
        }
        catch (IOException e) {
            Log.getLogLocation(false).debugT(UI_ID, "getEncodedTreeHierachy " + e.getMessage());
            return null;
        }
    }

    public void decodeTreeHierarchy(String encoded, String status) {
        Stack<TreeNode> parentStack = new Stack<TreeNode>();
        int nodeIndex = 1;
        try {
            DefaultHtmlbEncoder encoder = new DefaultHtmlbEncoder();
            encoder.prepareDecoding(encoded);
            String prop = null;
            TreeNode parent = null;
            TreeNode newNode = null;
            do {
                if ((prop = encoder.getStringProperty()) == null) continue;
                if (prop.equals("+")) {
                    parentStack.push(newNode);
                    parent = newNode;
                    continue;
                }
                if (prop.equals("-")) {
                    parentStack.pop();
                    if (parentStack.empty()) continue;
                    parent = (TreeNode)parentStack.peek();
                    continue;
                }
                newNode = new TreeNode(prop, prop);
                if (status != null) {
                    newNode.setOpen(this.getNodeStatus(nodeIndex, status));
                }
                ++nodeIndex;
                if (parent != null) {
                    parent.addChildNode(newNode);
                    continue;
                }
                this.setRootNode(newNode);
            } while (prop != null);
            encoder.finishDecoding();
        }
        catch (IOException e) {
            Log.getLogLocation(false).debugT(UI_ID, "decodeTreeHierarchy " + e.getMessage());
        }
    }

    public void updateNodeStatus(Tree tree) {
        this.rootNode.updateNodeStatus(tree);
    }

    private boolean getNodeStatus(int nodeIndex, String status) {
        String index = ":" + String.valueOf(nodeIndex) + ":";
        boolean nodeStatus = false;
        int pos = -1;
        int state = 45;
        if (status != null && !status.equals("") && (pos = status.indexOf(index)) > -1 && (state = (int)status.charAt(pos + index.length())) == 43) {
            nodeStatus = true;
        }
        return nodeStatus;
    }

    protected void initFromPageContext(IPageContext pc, String baseId) {
        String hierarchy = null;
        String param_name = baseId.concat(TREE_HIERARCHY) + "_";
        String param_part = null;
        StringBuffer hierBuf = new StringBuffer();
        int i = 0;
        do {
            if ((param_part = pc.getParameter(param_name + i)) != null) {
                hierBuf.append(param_part);
            }
            ++i;
        } while (param_part != null);
        hierarchy = hierBuf.toString();
        String status = pc.getParameter(baseId.concat(TREE_LAYOUT));
        if (hierarchy != null && hierarchy.length() > 0) {
            this.decodeTreeHierarchy(hierarchy, status);
        }
    }

    public int getCurrentNodeId() {
        return this.nodeId;
    }

    public void setCurrentNodeId(int nodeId) {
        this.nodeId = nodeId;
    }

    public int getOffsetForTreeNode() {
        return this.offsetForTreeNode;
    }

    public void setOffsetForTreeNode(int offsetForTreeNode) {
        this.offsetForTreeNode = offsetForTreeNode;
    }

    public HoverMenu getHoverMenu() {
        return null;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public ForcedTextDirection getTextDirection() {
        return this.textDirection;
    }

    public void setTextDirection(ForcedTextDirection textDirection) {
        this.textDirection = textDirection;
    }
}

