/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.EventValidationComponent;
import com.sapportals.htmlb.IUserDataComponent;
import com.sapportals.htmlb.LabeledComponent;
import com.sapportals.htmlb.enum.ForcedTextDirection;
import com.sapportals.htmlb.enum.TextWrapping;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.type.AbstractDataType;
import com.sapportals.htmlb.type.DataString;

public class TextEdit
extends EventValidationComponent
implements IUserDataComponent,
LabeledComponent {
    public static final String UI_ID = "TextEdit";
    private int cols;
    private int rows;
    private TextWrapping wrapping;
    private String tooltip;
    private String text;
    private boolean labeled;
    private String width;
    private String height;
    private boolean valid = true;
    private ForcedTextDirection textDirection = ForcedTextDirection.INHERIT;

    private TextEdit() {
    }

    public TextEdit(String name) {
        this.id = name;
        this.setCols(40);
        this.setRows(5);
        this.setWrapping(TextWrapping.HARD);
    }

    protected void initFromPageContext(IPageContext pc, String baseId) {
        this.setText(pc.getParameter(baseId));
    }

    public int getCols() {
        return this.cols;
    }

    public void setCols(int cols) {
        this.cols = cols;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getText() {
        return this.text;
    }

    public TextWrapping getWrapping() {
        return this.wrapping;
    }

    public void setWrapping(TextWrapping wrapping) {
        this.wrapping = wrapping;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getUI() {
        return UI_ID;
    }

    public AbstractDataType getValueAsDataType() {
        return new DataString(this.text);
    }

    public void setLabeled(boolean isLabeled) {
        this.labeled = isLabeled;
    }

    public boolean isLabeled() {
        return this.labeled;
    }

    public void setValid(boolean isValid) {
        this.valid = isValid;
    }

    public boolean isValid() {
        return this.valid;
    }

    public ForcedTextDirection getTextDirection() {
        return this.textDirection;
    }

    public void setTextDirection(ForcedTextDirection textDirection) {
        this.textDirection = textDirection;
    }
}

