/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Container;
import com.sapportals.htmlb.TabStripItem;
import com.sapportals.htmlb.enum.CellHAlign;
import com.sapportals.htmlb.enum.CellVAlign;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.util.IndexedLinkedList;
import com.sapportals.htmlb.util.Log;

public class TabStrip
extends Container {
    public static final String UI_ID = "TabStrip";
    public static final int VAR_HEADBEGIN = 0;
    public static final int VAR_HEADITEM_BEGIN = 1;
    public static final int VAR_HEADITEM_END = 2;
    public static final int VAR_HEADITEM_SEP = 3;
    public static final int VAR_HEADEND = 4;
    public static final int VAR_CONTENT_BEGIN = 5;
    public static final int VAR_ITEM_BEGIN = 6;
    public static final int VAR_ITEM_END = 7;
    public static final int VAR_CONTENT_END = 8;
    public static final String DEFAULT_SELECTION_HANDLER = "TabSelectionChanged";
    int selection;
    int currentIndex;
    String height;
    String width;
    CellHAlign hAlign;
    CellVAlign vAlign;
    IndexedLinkedList pages;
    String tooltip;
    private String accessibilityDescription = "";

    private TabStrip() {
    }

    public TabStrip(String name) {
        this.setId(name);
        this.selection = 1;
        this.setHAlign(CellHAlign.LEFT);
        this.setVAlign(CellVAlign.TOP);
    }

    protected void initFromPageContext(IPageContext pc, String baseId) {
        try {
            this.setSelection(Integer.parseInt(pc.getParameter(baseId + "_idx")));
        }
        catch (NumberFormatException e) {
            Log.getLogLocation(false).debugT(UI_ID, "initFromPageContext");
        }
    }

    public int getItemCount() {
        if (this.pages != null) {
            return this.pages.size();
        }
        return 0;
    }

    public int getIndexPosition(int index) {
        if (this.pages != null) {
            return this.pages.getIndexIndex(index);
        }
        return -1;
    }

    public int getSelection() {
        return this.selection;
    }

    public void setSelection(int selection) {
        this.selection = selection;
    }

    public String getBodyHeight() {
        return this.height;
    }

    public void setBodyHeight(String height) {
        this.height = height;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public CellVAlign getVAlign() {
        return this.vAlign;
    }

    public void setVAlign(CellVAlign vAlign) {
        this.vAlign = vAlign;
    }

    public CellHAlign getHAlign() {
        return this.hAlign;
    }

    public void setHAlign(CellHAlign hAlign) {
        this.hAlign = hAlign;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public TabStripItem addTab(int index) {
        TabStripItem myItem = new TabStripItem(this, index);
        if (this.pages == null) {
            this.pages = new IndexedLinkedList();
        }
        this.pages.put(index, myItem);
        this.addComponent(myItem);
        return myItem;
    }

    public TabStripItem addTab(int index, String title, Component bodyContent) {
        TabStripItem result = this.addTab(index);
        result.setTitle(title);
        result.setBody(bodyContent);
        return result;
    }

    public TabStripItem addTab(int index, Component headerComponent, Component bodyContent) {
        TabStripItem result = this.addTab(index);
        result.setHeader(headerComponent);
        result.setBody(bodyContent);
        return result;
    }

    public TabStripItem getItem(int index) {
        if (this.pages != null) {
            return (TabStripItem)this.pages.get(index);
        }
        return null;
    }

    public IndexedLinkedList getItems() {
        return this.pages;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
    }

    public String getUI() {
        return UI_ID;
    }

    public String getAccessibilityDescription() {
        return this.accessibilityDescription;
    }

    public void setAccessibilityDescription(String accessibilityDescription) {
        this.accessibilityDescription = accessibilityDescription == null ? "" : accessibilityDescription;
    }
}

