/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.RoadMapItem;
import com.sapportals.htmlb.enum.RoadMapEdgesDesign;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class RoadMap
extends Component {
    public static final String UI_ID = "RoadMap";
    private String id;
    private LinkedList roadItems;
    private RoadMapEdgesDesign startDesign;
    private RoadMapEdgesDesign endDesign;
    private String accessibilityDescription = "";

    public RoadMap(String ID) {
        this.setId(ID);
        this.roadItems = new LinkedList();
        this.setStartPointDesign(RoadMapEdgesDesign.DEFAULT);
        this.setEndPointDesign(RoadMapEdgesDesign.DEFAULT);
    }

    public String getUI() {
        return UI_ID;
    }

    public RoadMapEdgesDesign getEndPointDesign() {
        return this.endDesign;
    }

    public String getID() {
        return this.getId();
    }

    public int getNumberItems() {
        return this.roadItems.size();
    }

    public RoadMapItem[] getRoadItems() {
        RoadMapItem[] roadItemArray = this.roadItems.toArray(new RoadMapItem[0]);
        return roadItemArray;
    }

    public RoadMapEdgesDesign getStartPointDesign() {
        return this.startDesign;
    }

    public void setEndPointDesign(RoadMapEdgesDesign design) {
        this.endDesign = design;
    }

    public void setStartPointDesign(RoadMapEdgesDesign design) {
        this.startDesign = design;
    }

    public boolean addItem(RoadMapItem item) {
        boolean success = false;
        if (item != null && !this.containsItem(item.getID())) {
            success = this.roadItems.add(item);
            item.setIndex(this.getItemPosition(item.getID()));
        }
        return success;
    }

    public void addItem(RoadMapItem item, int position) throws IndexOutOfBoundsException {
        --position;
        boolean success = false;
        if (item != null && !this.containsItem(item.getID())) {
            this.roadItems.add(position, item);
        }
    }

    public boolean isEmpty() {
        return this.getNumberItems() == 0;
    }

    public ListIterator iterateItems() {
        ListIterator roadMapListIterator = this.roadItems.listIterator();
        return roadMapListIterator;
    }

    public RoadMapItem removeItem(int position) {
        RoadMapItem roadItem = (RoadMapItem)this.roadItems.remove(--position);
        RoadMapItem[] roadItemArray = this.getRoadItems();
        int i = 0;
        while (i < this.roadItems.size()) {
            roadItemArray[i].setIndex(i + 1);
            ++i;
        }
        return roadItem;
    }

    public boolean removeItem(RoadMapItem item) {
        boolean success = false;
        success = this.roadItems.remove(item);
        RoadMapItem[] roadItemArray = this.getRoadItems();
        int i = 0;
        while (i < this.roadItems.size()) {
            roadItemArray[i].setIndex(i + 1);
            ++i;
        }
        return success;
    }

    public RoadMapItem[] removeAllItems() {
        LinkedList tempList = this.roadItems;
        RoadMapItem[] roadItemArray = this.getRoadItems();
        if (this.roadItems.removeAll(tempList)) {
            return roadItemArray;
        }
        return null;
    }

    public int getItemPosition(RoadMapItem item) {
        int index = -1;
        index = this.roadItems.indexOf(item) + 1;
        return index;
    }

    public int getItemPosition(String itemID) {
        int index = -1;
        RoadMapItem[] roadItemArray = this.getRoadItems();
        if (roadItemArray != null) {
            int i = 0;
            while (i < this.roadItems.size()) {
                if (roadItemArray[i].getID().equals(itemID)) {
                    index = i + 1;
                    return index;
                }
                ++i;
            }
        }
        return index;
    }

    public RoadMapItem getRoadItem(int position) {
        return (RoadMapItem)this.roadItems.get(--position);
    }

    private boolean containsItem(String id) {
        boolean result = false;
        Iterator it = this.roadItems.iterator();
        if (it != null) {
            while (it.hasNext()) {
                RoadMapItem roadMapItem = (RoadMapItem)it.next();
                if (!roadMapItem.getId().equals(id)) continue;
                result = true;
            }
        }
        return result;
    }

    public String getAccessibilityDescription() {
        return this.accessibilityDescription;
    }

    public void setAccessibilityDescription(String accessibilityDescription) {
        this.accessibilityDescription = accessibilityDescription == null ? "" : accessibilityDescription;
    }
}

