/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.IUserDataComponent;
import com.sapportals.htmlb.Label;
import com.sapportals.htmlb.RadioButton;
import com.sapportals.htmlb.StatefulButtonGroupBase;
import com.sapportals.htmlb.enum.CellVAlign;
import com.sapportals.htmlb.enum.EventTrigger;
import com.sapportals.htmlb.event.RadioButtonClickEvent;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.type.AbstractDataType;
import com.sapportals.htmlb.type.DataString;
import java.util.Iterator;

public class RadioButtonGroup
extends StatefulButtonGroupBase
implements IUserDataComponent {
    public static final String UI_ID = "RadioButtonGroup";
    private int selectionIndex = -1;
    String selectionKey = "";
    String onClick;
    String onClientClick;
    CellVAlign verticalAlignRbColumn = CellVAlign.MIDDLE;
    CellVAlign verticalAlignTextColumn = CellVAlign.MIDDLE;
    private String accessibilityDescription = "";

    private RadioButtonGroup() {
    }

    public RadioButtonGroup(String name) {
        super(name);
    }

    public RadioButton addItem(String key) {
        RadioButton r = this.addItem(key, "" + this.elements.size());
        if (this.onClick != null && this.onClick.length() > 0) {
            RadioButtonClickEvent radioButtonClickEvent = new RadioButtonClickEvent();
            radioButtonClickEvent.setAction(this.onClick);
            r.setServerEvent(EventTrigger.ON_CLICK, radioButtonClickEvent);
        }
        return r;
    }

    public RadioButton getRadioButtonForKey(String key) {
        return (RadioButton)super.getComponentForKey(key);
    }

    public void setSelection(String key) {
        this.selectionKey = key;
        this.evaluateSelection();
    }

    private boolean evaluateSelection() {
        if (this.selectionKey == null) {
            return false;
        }
        boolean wasSet = false;
        int i = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            RadioButton rb = (RadioButton)it.next();
            rb.setSelectedInternal(false);
            if (this.selectionKey.equals(rb.getKey())) {
                this.selectionIndex = i;
                rb.setSelectedInternal(true);
                wasSet = true;
            }
            ++i;
        }
        return wasSet;
    }

    public String getSelection() {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            RadioButton item = (RadioButton)iter.next();
            if (!item.isSelected()) continue;
            return item.getKey();
        }
        return null;
    }

    public RadioButton addItem(String key, String text) {
        Label label = new Label(text);
        label.setHasDesignBar(false);
        RadioButton rb = (RadioButton)this.addComponent(label, key);
        if (this.onClick != null && this.onClick.length() > 0) {
            RadioButtonClickEvent radioButtonClickEvent = new RadioButtonClickEvent();
            radioButtonClickEvent.setAction(this.onClick);
            rb.setServerEvent(EventTrigger.ON_CLICK, radioButtonClickEvent);
        }
        label.setText(text);
        label.setLabeledComponentId(rb.getId());
        label.setLabledComponentClassName(rb.getClass().getName());
        rb.setLabeled(true);
        return rb;
    }

    public Component addComponent(Component component, String key) {
        RadioButton rb = (RadioButton)this.addComponent(component);
        rb.setKey(key);
        rb.setId(this.getId() + "cjlm" + this.getChildCount());
        this.evaluateSelection();
        if (this.onClick != null && this.onClick.length() > 0) {
            RadioButtonClickEvent radioButtonClickEvent = new RadioButtonClickEvent();
            radioButtonClickEvent.setAction(this.onClick);
            rb.setServerEvent(EventTrigger.ON_CLICK, radioButtonClickEvent);
        }
        return rb;
    }

    public Component addComponent(Component component) {
        if (component instanceof RadioButton) {
            this.elements.add(component);
            ((RadioButton)component).setId(this.getId());
            return component;
        }
        RadioButton rb = new RadioButton(this);
        rb.setElement(component);
        rb.setId(this.getId());
        this.elements.add(rb);
        if (this.onClick != null && this.onClick.length() > 0) {
            RadioButtonClickEvent radioButtonClickEvent = new RadioButtonClickEvent();
            radioButtonClickEvent.setAction(this.onClick);
            rb.setServerEvent(EventTrigger.ON_CLICK, radioButtonClickEvent);
        }
        return rb;
    }

    public String getOnClick() {
        return this.onClick;
    }

    public void setOnClick(String onClick) {
        this.onClick = onClick;
        int i = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            RadioButton rb = (RadioButton)it.next();
            RadioButtonClickEvent radioButtonClickEvent = new RadioButtonClickEvent();
            radioButtonClickEvent.setAction(onClick);
            rb.setServerEvent(EventTrigger.ON_CLICK, radioButtonClickEvent);
            ++i;
        }
    }

    public String getUI() {
        return UI_ID;
    }

    protected void initFromPageContext(IPageContext pc, String baseId) {
        String key = null;
        key = pc.getParameter(baseId);
        if (key != null) {
            this.addItem(key);
            this.setSelection(key);
        }
    }

    public AbstractDataType getValueAsDataType() {
        return new DataString(this.getSelection());
    }

    public void setVerticalAlign(CellVAlign radioButtonColumn, CellVAlign textColumn) {
        this.setVerticalAlignRbColumn(radioButtonColumn);
        this.setVerticalAlignTextColumn(textColumn);
    }

    public CellVAlign getVerticalAlignTextColumn() {
        return this.verticalAlignTextColumn;
    }

    private void setVerticalAlignTextColumn(CellVAlign verticalAlignTextColumn) {
        this.verticalAlignTextColumn = verticalAlignTextColumn;
    }

    public CellVAlign getVerticalAlignRbColumn() {
        return this.verticalAlignRbColumn;
    }

    private void setVerticalAlignRbColumn(CellVAlign verticalAlignRbColumn) {
        this.verticalAlignRbColumn = verticalAlignRbColumn;
    }

    public String getAccessibilityDescription() {
        return this.accessibilityDescription;
    }

    public void setAccessibilityDescription(String accessibilityDescription) {
        this.accessibilityDescription = accessibilityDescription == null ? "" : accessibilityDescription;
    }
}

