/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.DefaultListModel;
import com.sapportals.htmlb.EventValidationComponent;
import com.sapportals.htmlb.IListModel;
import com.sapportals.htmlb.LabeledComponent;
import com.sapportals.htmlb.enum.EventTrigger;
import com.sapportals.htmlb.event.Event;
import com.sapportals.htmlb.event.ListSelectEvent;
import com.sapportals.htmlb.rendering.IPageContext;
import java.util.Iterator;

public class ListBox
extends EventValidationComponent
implements LabeledComponent {
    public static final String UI_ID = "ListBox";
    IListModel model;
    int size;
    String width;
    String tooltip;
    boolean labeled;

    private ListBox() {
    }

    public ListBox(String name) {
        this.setId(name);
        this.setModel(this.createDefaultModel());
    }

    protected void initFromPageContext(IPageContext pc, String baseId) {
        String[] values = pc.getParameterValues(baseId);
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                this.addSelection(values[i]);
                ++i;
            }
        }
    }

    protected IListModel createDefaultModel() {
        DefaultListModel myModel = new DefaultListModel();
        myModel.setSingleSelection(false);
        return myModel;
    }

    public IListModel getModel() {
        return this.model;
    }

    public void setModel(IListModel model) {
        this.model = model;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String[] getMultiSelection() {
        return this.model.getMultiSelection();
    }

    public void addSelection(String selection) {
        this.model.addSelection(selection);
    }

    public void removeSelection(String selection) {
        this.model.removeSelection(selection);
    }

    public String getSingleSelection() {
        return this.model.getSingleSelection();
    }

    public void setSingleSelection(String selection) {
        this.model.setSelection(selection);
    }

    public boolean isSelected(String key) {
        return this.model.isSelected(key);
    }

    public String getNameOfKeyColumn() {
        return this.model.getNameOfKeyColumn();
    }

    public void setNameOfKeyColumn(String nameOfKeyColumn) {
        this.model.setNameOfKeyColumn(nameOfKeyColumn);
    }

    public String getNameOfValueColumn() {
        return this.model.getNameOfTextColumn();
    }

    public void setNameOfValueColumn(String nameOfValueColumn) {
        this.model.setNameOfTextColumn(nameOfValueColumn);
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getOnSelect() {
        Event event = this.getServerEvent(EventTrigger.ON_CHANGE);
        return event == null ? null : event.getAction();
    }

    public void setOnSelect(String onSelect) {
        ListSelectEvent listSelectEvent = new ListSelectEvent();
        listSelectEvent.setAction(onSelect);
        this.setServerEvent(EventTrigger.ON_CHANGE, listSelectEvent);
    }

    public String getOnClientSelect() {
        return this.getClientEvent(EventTrigger.ON_CHANGE);
    }

    public void setOnClientSelect(String onClientSelect) {
        this.setClientEvent(EventTrigger.ON_CHANGE, onClientSelect);
    }

    public String getUI() {
        return UI_ID;
    }

    public void addItem(String key, String text) {
        this.model.addItem(key, text);
    }

    public String getTextForKey(String key) {
        return this.model.getTextForKey(key);
    }

    public Iterator getKeys() {
        return this.model.getKeys();
    }

    public void setLabeled(boolean isLabeled) {
        this.labeled = isLabeled;
    }

    public boolean isLabeled() {
        return this.labeled;
    }
}

