/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.EventValidationContainer;
import com.sapportals.htmlb.IPopupTriggerContent;
import com.sapportals.htmlb.Image;
import com.sapportals.htmlb.LabeledComponent;
import com.sapportals.htmlb.TextView;
import com.sapportals.htmlb.enum.EventTrigger;
import com.sapportals.htmlb.enum.ForcedTextDirection;
import com.sapportals.htmlb.enum.LinkDesign;
import com.sapportals.htmlb.enum.LinkFontSize;
import com.sapportals.htmlb.event.Event;
import com.sapportals.htmlb.event.LinkClickEvent;
import com.sapportals.htmlb.hovermenu.HoverMenu;
import com.sapportals.htmlb.rendering.IPageContext;
import java.util.Iterator;

public class Link
extends EventValidationContainer
implements LabeledComponent,
IPopupTriggerContent {
    public static final String UI_ID = "Link";
    public static final int VAR_BEGIN = 0;
    public static final int VAR_END = 1;
    public static final int VAR_TEXT = 2;
    private String onClick;
    private String onClientClick;
    private String target;
    private String tooltip;
    private String reference;
    private LinkFontSize fontSize;
    private LinkDesign linkDesign = LinkDesign.DRILLDOWN;
    private boolean labeled;
    private TextView innerText;
    private boolean validation;
    private ForcedTextDirection textDirection = ForcedTextDirection.INHERIT;

    private Link() {
        this.linkDesign = LinkDesign.DRILLDOWN;
        this.validation = false;
    }

    public Link(String name) {
        this.linkDesign = LinkDesign.DRILLDOWN;
        this.setId(name);
        this.validation = false;
    }

    public Link(String name, String text) {
        this.linkDesign = LinkDesign.DRILLDOWN;
        this.setId(name);
        this.innerText = new TextView(text);
        this.addComponent(this.innerText);
        this.validation = false;
    }

    public String addText(String text) {
        this.innerText = new TextView(text);
        this.addComponent(this.innerText);
        return this.innerText.getText();
    }

    public Component addComponent(Component c) {
        if (c instanceof TextView) {
            this.innerText = (TextView)c;
        }
        return super.addComponent(c);
    }

    public String getUI() {
        return UI_ID;
    }

    public String getOnClick() {
        Event event = this.getServerEvent(EventTrigger.ON_CLICK);
        return event == null ? null : event.getAction();
    }

    public void setOnClick(String onClick) {
        LinkClickEvent linkClickEvent = new LinkClickEvent(onClick);
        String reference = this.getReference();
        if (reference != null && reference.length() != 0) {
            linkClickEvent.setRef(reference);
        }
        linkClickEvent.setAction(onClick);
        this.setServerEvent(EventTrigger.ON_CLICK, linkClickEvent);
    }

    public String getOnClientClick() {
        return this.getClientEvent(EventTrigger.ON_CLICK);
    }

    public void setOnClientClick(String onClientClick) {
        this.setClientEvent(EventTrigger.ON_CLICK, onClientClick);
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public LinkFontSize getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(LinkFontSize fontSize) {
        this.fontSize = fontSize;
    }

    public LinkDesign getLinkDesign() {
        return this.linkDesign;
    }

    public void setLinkDesign(LinkDesign linkDesign) {
        this.linkDesign = linkDesign;
    }

    public TextView getInnerText() {
        return this.innerText;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
        Event serverEvent = this.getServerEvent(EventTrigger.ON_CLICK);
        if (serverEvent != null) {
            ((LinkClickEvent)serverEvent).setRef(reference);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(100);
        buf.append("Link (");
        if (this.getId() != null) {
            buf.append(" name='" + this.getId() + "'");
        }
        buf.append(")");
        return buf.toString();
    }

    public boolean requiresForm() {
        return this.getOnClick() != null;
    }

    public void setLabeled(boolean isLabeled) {
        this.labeled = isLabeled;
    }

    public boolean isLabeled() {
        return this.labeled;
    }

    public void removerHoverMenu(HoverMenu menu) {
    }

    public void preRender(IPageContext pc) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (pc.getIs508()) {
                if (o instanceof TextView) {
                    TextView txt = (TextView)o;
                    txt.setNested(true);
                    if (txt.getTooltip() != null && txt.getTooltip().length() > 0) {
                        this.setTooltip(txt.getText() + " " + txt.getTooltip());
                    }
                } else if (o instanceof Image) {
                    Image i = (Image)o;
                    i.setNested(true);
                    if (i.getTooltip() != null && i.getTooltip().length() > 0) {
                        this.setTooltip(i.getTooltip());
                    }
                }
            }
            if (!(o instanceof Component)) continue;
            Component myComponent = (Component)o;
            myComponent.preRender(pc);
        }
    }

    public boolean isRequiresValidation() {
        return this.validation;
    }

    public void setRequiresValidation(boolean validation) {
        this.validation = validation;
    }

    public ForcedTextDirection getTextDirection() {
        return this.textDirection;
    }

    public void setTextDirection(ForcedTextDirection textDirection) {
        this.textDirection = textDirection;
    }
}

