/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.Checkbox;
import com.sapportals.htmlb.DropdownListBox;
import com.sapportals.htmlb.EventValidationComponent;
import com.sapportals.htmlb.InputField;
import com.sapportals.htmlb.LabeledComponent;
import com.sapportals.htmlb.Link;
import com.sapportals.htmlb.ListBox;
import com.sapportals.htmlb.RadioButton;
import com.sapportals.htmlb.TextEdit;
import com.sapportals.htmlb.TextView;
import com.sapportals.htmlb.enum.DropdownListBoxDesign;
import com.sapportals.htmlb.enum.ForcedTextDirection;
import com.sapportals.htmlb.enum.InputFieldDesign;
import com.sapportals.htmlb.enum.LinkFontSize;
import com.sapportals.htmlb.enum.TextViewDesign;

public class Label
extends EventValidationComponent {
    public static final String UI_ID = "Label";
    private String text;
    private TextViewDesign design;
    private boolean required;
    private boolean valid = true;
    private boolean enabled = true;
    private boolean encode = true;
    private boolean hasDesignBar = true;
    private boolean wrapping;
    private String tooltip;
    private String width;
    private LabeledComponent labeledComponent;
    private String labeledComponentId;
    private String labeledComponentClass;
    private ForcedTextDirection textDirection = ForcedTextDirection.INHERIT;

    public Label(String text) {
        this.setDesign(TextViewDesign.LABEL);
        this.setText(text);
        this.setEncode(true);
    }

    public Label(String text, LabeledComponent field) {
        this(text);
        EventValidationComponent lb;
        this.setRequired(false);
        this.setValid(true);
        if (field instanceof InputField) {
            InputField inf = (InputField)field;
            this.setRequired(inf.isRequired());
            this.setValid(inf.isValid());
            this.setEnabled(inf.isEnabled());
            if (inf.getDesign() == InputFieldDesign.SMALL) {
                this.setDesign(TextViewDesign.LABELSMALL);
            }
            inf.setLabel(this);
        }
        if (field instanceof Link) {
            Link link = (Link)field;
            if (link.getFontSize() == LinkFontSize.SMALL) {
                this.setDesign(TextViewDesign.LABELSMALL);
            }
            if (link.getOnClick() != null && link.getOnClick() != "" || link.getReference() != null && link.getReference() != "") {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
        if (field instanceof TextView) {
            TextView tv = (TextView)field;
            if (tv.getDesign() == TextViewDesign.LEGEND) {
                this.setDesign(TextViewDesign.LABELSMALL);
            }
            this.setEnabled(true);
        }
        if (field instanceof Checkbox) {
            Checkbox cb = (Checkbox)field;
            this.setEnabled(cb.isEnabled());
        }
        if (field instanceof DropdownListBox) {
            lb = (DropdownListBox)field;
            if (((DropdownListBox)lb).getDesign() == DropdownListBoxDesign.SMALL) {
                this.setDesign(TextViewDesign.LABELSMALL);
            }
            this.setEnabled(lb.isEnabled());
        }
        if (field instanceof ListBox) {
            lb = (ListBox)field;
            this.setEnabled(lb.isEnabled());
        }
        if (field instanceof RadioButton) {
            RadioButton rb = (RadioButton)field;
            this.setEnabled(rb.isEnabled());
        }
        if (field instanceof TextEdit) {
            TextEdit te = (TextEdit)field;
            this.setEnabled(te.isEnabled());
        }
        this.setLabelFor(field);
    }

    public String getUI() {
        return UI_ID;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isEncode() {
        return this.encode;
    }

    public void setEncode(boolean encode) {
        this.encode = encode;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public TextViewDesign getDesign() {
        return this.design;
    }

    public void setDesign(TextViewDesign design) {
        this.design = design;
    }

    public LabeledComponent getLabelFor() {
        return this.labeledComponent;
    }

    public void setLabelFor(LabeledComponent labeledComponent) {
        this.labeledComponent = labeledComponent;
        if (labeledComponent != null) {
            labeledComponent.setLabeled(true);
        }
    }

    public void setLabeledComponentId(String labeledComponent) {
        this.labeledComponentId = labeledComponent;
    }

    public String getLabeledComponentId() {
        return this.labeledComponentId;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void setHasDesignBar(boolean hasDesignBar) {
        this.hasDesignBar = hasDesignBar;
    }

    public boolean hasDesignBar() {
        return this.hasDesignBar;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public boolean isWrapping() {
        return this.wrapping;
    }

    public void setWrapping(boolean wrapping) {
        this.wrapping = wrapping;
    }

    public boolean requiresForm() {
        return false;
    }

    public String toString() {
        return this.getText();
    }

    public void setLabledComponentClassName(String className) {
        this.labeledComponentClass = className;
    }

    public String getLabledComponentClassName() {
        if (this.labeledComponent != null) {
            return this.labeledComponent.getClass().getName();
        }
        if (this.labeledComponentClass != null) {
            return this.labeledComponentClass;
        }
        return "";
    }

    public ForcedTextDirection getTextDirection() {
        return this.textDirection;
    }

    public void setTextDirection(ForcedTextDirection textDirection) {
        this.textDirection = textDirection;
    }
}

