/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sap.mw.jco.JCO;
import com.sapportals.htmlb.IListModel;
import com.sapportals.htmlb.util.EmptyEnumeration;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class JCOListModel
implements IListModel,
Serializable {
    String nameOfKeyColumn;
    String nameOfValueColumn;
    ArrayList selection;
    boolean isSingleSelect;
    JCO.Table table;

    public JCOListModel(JCO.Table table) {
        this.table = table;
        this.setSingleSelection(true);
        this.selection = new ArrayList();
    }

    public void addItem(String key, String text) {
        throw new IllegalStateException("Can't modify a JCOListModel");
    }

    public int size() {
        return this.table.getNumRows();
    }

    public String getKeyByIndex(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Illegal index: " + index);
        }
        this.table.setRow(index);
        return this.table.getString(this.getNameOfKeyColumn());
    }

    public String getTextByIndex(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Illegal index: " + index);
        }
        this.table.setRow(index);
        return this.table.getString(this.getNameOfTextColumn());
    }

    public Iterator getKeys() {
        if (this.table != null) {
            JCO.Table table = this.table;
            synchronized (table) {
                String keyId = this.getNameOfKeyColumn();
                ArrayList<String> list = new ArrayList<String>(this.table.getNumRows());
                this.table.firstRow();
                do {
                    list.add(this.table.getString(keyId));
                } while (this.table.nextRow());
                Iterator iterator = ((AbstractList)list).iterator();
                return iterator;
            }
        }
        return EmptyEnumeration.getInstance();
    }

    public String getTextForKey(String key) {
        JCO.Table table = this.table;
        synchronized (table) {
            String keyId = this.getNameOfKeyColumn();
            this.table.firstRow();
            do {
                String tableKey;
                if (!key.equals(tableKey = this.table.getString(keyId))) continue;
                String string = this.table.getString(this.getNameOfTextColumn());
                return string;
            } while (this.table.nextRow());
            String string = null;
            return string;
        }
    }

    public boolean isSelected(int index) {
        return this.isSelected(this.getKeyByIndex(index));
    }

    public boolean isSelected(String key) {
        return this.selection.contains(key);
    }

    public String getNameOfKeyColumn() {
        return this.nameOfKeyColumn;
    }

    public void setNameOfKeyColumn(String nameOfKeyColumn) {
        this.nameOfKeyColumn = nameOfKeyColumn;
    }

    public String getNameOfTextColumn() {
        return this.nameOfValueColumn;
    }

    public void setNameOfTextColumn(String nameOfValueColumn) {
        this.nameOfValueColumn = nameOfValueColumn;
    }

    public void setSelection(String selection) {
        this.selection.clear();
        this.selection.add(selection);
    }

    public boolean isSingleSelection() {
        return this.isSingleSelect;
    }

    public void setSingleSelection(boolean isSingleSelection) {
        this.isSingleSelect = isSingleSelection;
    }

    public String getSingleSelection() {
        if (this.isSingleSelect) {
            if (this.selection.size() == 1) {
                return (String)this.selection.get(0);
            }
            return null;
        }
        throw new IllegalStateException("List uses multiselection");
    }

    public String[] getMultiSelection() {
        return new String[0];
    }

    public void addSelection(String selection) {
        if (!this.selection.contains(selection)) {
            this.selection.add(selection);
        }
    }

    public void removeSelection(String selection) {
        ((AbstractCollection)this.selection).remove(selection);
    }

    public void removeItem(String key) {
        throw new IllegalStateException("Can't modify a JCOListModel");
    }
}

