/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.EventValidationComponent;
import com.sapportals.htmlb.Form;
import com.sapportals.htmlb.IUserDataComponent;
import com.sapportals.htmlb.Label;
import com.sapportals.htmlb.LabeledComponent;
import com.sapportals.htmlb.enum.DataType;
import com.sapportals.htmlb.enum.ForcedTextDirection;
import com.sapportals.htmlb.enum.HorizontalTextAlignment;
import com.sapportals.htmlb.enum.InputFieldDesign;
import com.sapportals.htmlb.rendering.IPageContext;
import com.sapportals.htmlb.type.AbstractDataType;
import com.sapportals.htmlb.type.DataBCD;
import com.sapportals.htmlb.type.DataDate;
import com.sapportals.htmlb.type.DataInteger;
import com.sapportals.htmlb.type.DataString;
import com.sapportals.htmlb.type.DataTime;
import com.sapportals.htmlb.type.TypeFormatter;
import com.sapportals.htmlb.util.Log;
import com.sapportals.htmlb.validation.LengthValidator;
import com.sapportals.htmlb.validation.RequiredValidator;
import com.sapportals.htmlb.validation.Validator;
import com.sapportals.htmlb.valuehelp.ValueHelpContext;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class InputField
extends EventValidationComponent
implements IUserDataComponent,
LabeledComponent {
    public static final String UI_ID = "InputField";
    private Object value;
    private String width;
    private String tooltip;
    private boolean visible;
    private boolean valid = true;
    private boolean password;
    private boolean required;
    private boolean labeled;
    private int size;
    private int maxlength;
    private int minlength;
    private boolean showHelp;
    private int firstDayOfWeek = 1;
    private InputFieldDesign design;
    private boolean valueEncode;
    private boolean sessionParking = false;
    private boolean requiresValidation = true;
    private boolean enabled = true;
    private boolean showValueHelp;
    private ValueHelpContext valueHelpContext;
    private Component label = null;
    private HorizontalTextAlignment align;
    private ForcedTextDirection textDirection = ForcedTextDirection.INHERIT;

    public InputField() {
        this.setSize(20);
        this.setFirstDayOfWeek(1);
        this.setDesign(InputFieldDesign.STANDARD);
        this.setVisible(true);
        this.setRequired(false);
        this.setValueEncode(true);
        this.setHAlign(HorizontalTextAlignment.LEFT);
    }

    public InputField(String name) {
        this.setId(name);
        this.setSize(20);
        this.setFirstDayOfWeek(1);
        this.setDesign(InputFieldDesign.STANDARD);
        this.setVisible(true);
        this.setRequired(false);
        this.setValueEncode(true);
        this.setHAlign(HorizontalTextAlignment.LEFT);
    }

    public String getUI() {
        return UI_ID;
    }

    protected String getEncodedIdForForm(Form theForm) {
        String result = super.getEncodedIdForForm(theForm);
        if (this.value instanceof AbstractDataType) {
            String dataTypeId = Integer.toString(theForm.getIdForClass(this.value.getClass()));
            return result + "_" + dataTypeId;
        }
        return result;
    }

    protected void initFromShortId(IPageContext pc, String id) {
        int index;
        if (id != null && (index = id.indexOf("_")) >= 0) {
            this.value = null;
            String dataTypeId = id.substring(index + 1);
            try {
                int intId = Integer.parseInt(dataTypeId);
                Class dataClass = pc.getOldForm().getClassForId(intId);
                this.value = (AbstractDataType)dataClass.newInstance();
            }
            catch (NumberFormatException e) {
                Log.getLogLocation(false).debugT("Should not happen: initFromShortId", "initFromShortId");
            }
            catch (InstantiationException e) {
                Log.getLogLocation(false).debugT("Should not happen: initFromShortId", "initFromShortId");
            }
            catch (IllegalAccessException e) {
                Log.getLogLocation(false).debugT("Should not happen: initFromShortId", "initFromShortId");
            }
        }
    }

    protected void initFromPageContext(IPageContext pc, String baseId) {
        String value = pc.getParameter(baseId);
        if (value != null) {
            if (this.value instanceof DataBCD) {
                ((DataBCD)this.value).setValue(value, pc.getLocale());
            } else if (this.value instanceof DataDate) {
                SimpleDateFormat sdf = (SimpleDateFormat)TypeFormatter.getFormat(pc.getLocale(), DataType.DATE);
                sdf.setLenient(false);
                try {
                    Date d = sdf.parse(value);
                    ((DataDate)this.value).setValue(d);
                }
                catch (ParseException e) {
                    this.setValue(value);
                }
            } else {
                this.setValue(value);
            }
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        if (value == null) {
            return;
        }
        if (this.value instanceof AbstractDataType && !(value instanceof AbstractDataType)) {
            ((AbstractDataType)this.value).setValue(value);
        } else if (value instanceof AbstractDataType) {
            if (this.value == null) {
                this.value = value;
            } else if (this.value.getClass().equals(value.getClass())) {
                this.value = value;
            } else {
                this.throwNewIllegalDataState();
            }
        } else {
            this.getString().setValue(value);
        }
    }

    public void setType(DataType type) {
        if (this.value == null) {
            this.value = AbstractDataType.getInstance(type);
        } else if (this.value instanceof AbstractDataType) {
            if (!type.equals(((AbstractDataType)this.value).getType())) {
                AbstractDataType newValue = AbstractDataType.getInstance(type);
                newValue.setValue(((AbstractDataType)this.value).toString());
                this.value = newValue;
            }
        } else {
            AbstractDataType newValue = AbstractDataType.getInstance(type);
            newValue.setValue(this.value);
            this.value = newValue;
        }
    }

    public DataType getType() {
        if (this.value instanceof AbstractDataType) {
            return ((AbstractDataType)this.value).getType();
        }
        return null;
    }

    public void setString(Object value) {
        if (value instanceof DataString && (this.value == null || this.value instanceof DataString)) {
            this.value = value;
            return;
        }
        this.getString().setValue(value);
    }

    public DataString getString() {
        if (this.value == null) {
            this.value = new DataString();
        }
        if (this.value instanceof DataString) {
            return (DataString)this.value;
        }
        this.throwNewIllegalDataState();
        return null;
    }

    public void setDate(Object date) {
        if (date instanceof DataDate && (this.value == null || this.value instanceof DataDate)) {
            this.value = date;
            return;
        }
        this.getDate().setValue(date);
    }

    public DataDate getDate() {
        if (this.value == null) {
            this.value = new DataDate();
        }
        if (this.value instanceof DataDate) {
            return (DataDate)this.value;
        }
        this.throwNewIllegalDataState();
        return null;
    }

    public void setTime(Object time) {
        if (time instanceof DataTime && (this.value == null || this.value instanceof DataTime)) {
            this.value = time;
            return;
        }
        this.getTime().setValue(time);
    }

    public DataTime getTime() {
        if (this.value == null) {
            this.value = new DataTime();
        }
        if (this.value instanceof DataTime) {
            return (DataTime)this.value;
        }
        this.throwNewIllegalDataState();
        return null;
    }

    public void setBCD(Object bcd) {
        if (bcd instanceof DataBCD && (this.value == null || this.value instanceof DataBCD)) {
            this.value = bcd;
            return;
        }
        this.getBCD().setValue(bcd);
    }

    public DataBCD getBCD() {
        if (this.value == null) {
            this.value = new DataBCD();
        }
        if (this.value instanceof DataBCD) {
            return (DataBCD)this.value;
        }
        this.throwNewIllegalDataState();
        return null;
    }

    public void setInteger(Object integer) {
        if (integer instanceof DataInteger && (this.value == null || this.value instanceof DataInteger)) {
            this.value = integer;
            return;
        }
        this.getInteger().setValue(integer);
    }

    public DataInteger getInteger() {
        if (this.value == null) {
            this.value = new DataInteger();
        }
        if (this.value instanceof DataInteger) {
            return (DataInteger)this.value;
        }
        this.throwNewIllegalDataState();
        return null;
    }

    private void throwNewIllegalDataState() {
        String name = null;
        if (this.value instanceof AbstractDataType) {
            name = "type " + ((AbstractDataType)this.value).getType().toString();
        } else if (this.value != null) {
            name = this.value.getClass().getName();
        }
        String s = "InputField is already defined for value of " + name;
        throw new IllegalStateException(s);
    }

    public AbstractDataType getValueAsDataType() {
        return (AbstractDataType)this.value;
    }

    public ArrayList getAllValidators() {
        if (this.isRequiresValidation()) {
            DataString string;
            Validator typeValidator = null;
            Validator appValidator = this.getValidator();
            int maxlength = this.maxlength;
            int minlength = this.minlength;
            if ((maxlength == 0 || minlength == 0) && this.getType() == DataType.STRING) {
                string = (DataString)this.getValue();
                maxlength = string.getLength();
                minlength = string.getMinLength();
            }
            try {
                typeValidator = this.getValueAsDataType().getValidator();
                if (this.getType() == DataType.STRING && (string = (DataString)this.getValue()).getPattern() == null) {
                    typeValidator = null;
                }
            }
            catch (Exception ex) {
                Log.getLogLocation(false).debugT("InputField getAllValidators", "Get Value");
            }
            if (this.isRequired() || typeValidator != null || appValidator != null || minlength > 0 || maxlength > 0) {
                ArrayList<Validator> list = new ArrayList<Validator>();
                if (this.isRequired()) {
                    list.add(new RequiredValidator());
                }
                if (maxlength > 0 || minlength > 0) {
                    if (minlength > 0) {
                        list.add(new LengthValidator(minlength, maxlength));
                    } else {
                        list.add(new LengthValidator(maxlength));
                    }
                }
                if (typeValidator != null) {
                    list.add(typeValidator);
                }
                if (appValidator != null) {
                    list.add(appValidator);
                }
                return list;
            }
        }
        return null;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        if (!visible) {
            this.setRequiresValidation(false);
        }
    }

    public boolean isPassword() {
        return this.password;
    }

    public void setPassword(boolean password) {
        this.password = password;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isInvalid() {
        return !this.isValid();
    }

    public void setInvalid(boolean invalid) {
        this.setValid(!invalid);
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getMaxlength() {
        return this.maxlength;
    }

    public void setMaxlength(int maxlength) {
        this.maxlength = maxlength;
    }

    public int getMinlength() {
        return this.minlength;
    }

    public void setMinlength(int minlength) {
        this.minlength = minlength;
    }

    public boolean isShowHelp() {
        return this.showHelp;
    }

    public void setShowHelp(boolean showHelp) {
        this.showHelp = showHelp;
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
    }

    public InputFieldDesign getDesign() {
        return this.design;
    }

    public void setDesign(InputFieldDesign design) {
        this.design = design;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setLabeled(boolean isLabeled) {
        this.labeled = isLabeled;
    }

    public boolean isLabeled() {
        return this.labeled;
    }

    public boolean getValueEncode() {
        return this.valueEncode;
    }

    public void setValueEncode(boolean encode) {
        this.valueEncode = encode;
    }

    public boolean isShowValueHelp() {
        return this.showValueHelp;
    }

    public void setShowValueHelp(boolean showValueHelp) {
        this.showValueHelp = showValueHelp;
        this.setJsObjectNeeded(true);
    }

    public boolean isRequiresValidation() {
        return this.requiresValidation;
    }

    public void setRequiresValidation(boolean requiresValidation) {
        this.requiresValidation = requiresValidation;
    }

    public ValueHelpContext getValueHelpContext() {
        return this.valueHelpContext;
    }

    public void setValueHelpContext(ValueHelpContext valueHelpContext) {
        this.valueHelpContext = valueHelpContext;
        valueHelpContext.setInputField(this);
    }

    public void setParkInSession(boolean parkInSession) {
        this.sessionParking = parkInSession;
    }

    public boolean getParkInSession() {
        return this.sessionParking;
    }

    public Component getLabel() {
        return this.label;
    }

    public void setLabel(Component label) {
        this.label = label;
    }

    public HorizontalTextAlignment getHAlign() {
        return this.align;
    }

    public void setHAlign(HorizontalTextAlignment align) {
        this.align = align;
    }

    public ForcedTextDirection getTextDirection() {
        return this.textDirection;
    }

    public void setTextDirection(ForcedTextDirection textDirection) {
        this.textDirection = textDirection;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.label != null) {
            ((Label)this.label).setEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

