/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.GridLayoutCell;
import java.util.Iterator;
import java.util.NoSuchElementException;

class GridLayoutIterator
implements Iterator {
    private Object[][] cells;
    private int rowSize;
    private int columnSize;
    private int rowIndex;
    private int columnIndex;
    private Object nextObject = null;

    public GridLayoutIterator(Object[][] cells) {
        this.cells = cells;
        this.rowSize = cells.length;
        this.columnSize = cells[1].length;
        this.rowIndex = 1;
        this.columnIndex = 1;
    }

    public boolean hasNext() {
        if (this.rowIndex >= this.rowSize || this.columnIndex >= this.columnSize) {
            return false;
        }
        this.nextObject = this.getNextObject(this.rowIndex, this.columnIndex);
        return this.nextObject != null;
    }

    public Object next() throws NoSuchElementException {
        if (this.rowIndex >= this.rowSize || this.columnIndex >= this.columnSize) {
            throw new NoSuchElementException();
        }
        Object object = this.cells[this.rowIndex][this.columnIndex];
        if (this.columnIndex == this.columnSize - 1) {
            this.columnIndex = 1;
            if (this.rowIndex < this.rowSize) {
                ++this.rowIndex;
            }
        } else {
            ++this.columnIndex;
        }
        if (object == null) {
            if (this.rowIndex < this.rowSize && this.columnIndex < this.columnSize) {
                return this.next();
            }
            return null;
        }
        GridLayoutCell cell = (GridLayoutCell)object;
        return cell.getContent();
    }

    public void remove() throws UnsupportedOperationException, IllegalStateException {
    }

    private Object getNextObject(int rowIndex, int columnIndex) {
        if (rowIndex >= this.rowSize || columnIndex >= this.columnSize) {
            return null;
        }
        Object object = null;
        do {
            object = this.cells[rowIndex][columnIndex];
            if (columnIndex == this.columnSize - 1) {
                columnIndex = 1;
                if (rowIndex >= this.rowSize) continue;
                ++rowIndex;
                continue;
            }
            ++columnIndex;
        } while (object == null && rowIndex < this.rowSize && columnIndex < this.columnSize);
        return object;
    }
}

