/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Container;
import com.sapportals.htmlb.GridLayoutCell;
import com.sapportals.htmlb.GridLayoutIterator;
import java.util.Iterator;

public class GridLayout
extends Container {
    public static final String UI_ID = "GridLayout";
    public static final int GRID_BEGIN = 0;
    public static final int GRID_END = 1;
    public static final int GRID_ROW_BEGIN = 2;
    public static final int GRID_ROW_END = 3;
    public static final int GRID_CELL_BEGIN = 4;
    public static final int GRID_CELL_END = 5;
    public static final int GRID_CELL_CONTENT = 6;
    private int columnSize;
    private int rowSize;
    private int cellSpacing = 0;
    private int cellPadding = 0;
    private String width;
    private int height = -1;
    private boolean debugMode = false;
    transient int currentRowIndex;
    transient int currentColumnIndex;
    private Object[][] cells = null;
    private boolean NN4Optimized;
    private boolean fixedLayout = false;

    public GridLayout() {
        this(1, 1);
    }

    public GridLayout(int rowSize, int columnSize) {
        if (rowSize < 1) {
            rowSize = 1;
        }
        if (columnSize < 1) {
            columnSize = 1;
        }
        this.setRowSize(rowSize);
        this.setColumnSize(columnSize);
        this.cells = new Object[this.rowSize + 1][this.columnSize + 1];
    }

    public void setRowSize(int rowSize) {
        this.rowSize = rowSize;
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public void setColumnSize(int columnSize) {
        this.columnSize = columnSize;
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public void addComponent(int rowIndex, int columnIndex, Component component) {
        GridLayoutCell cell = new GridLayoutCell(component);
        this.addCell(rowIndex, columnIndex, cell);
    }

    public void addColSpanComponent(int rowIndex, int columnIndex, Component component, int colSpan) {
        GridLayoutCell cell = new GridLayoutCell(component, colSpan);
        this.addCell(rowIndex, columnIndex, cell);
    }

    public void addText(int rowIndex, int columnIndex, String text) {
        GridLayoutCell cell = new GridLayoutCell(text);
        this.addCell(rowIndex, columnIndex, cell);
    }

    public void addColSpanText(int rowIndex, int columnIndex, String text, int colSpan) {
        GridLayoutCell cell = new GridLayoutCell(text, colSpan);
        this.addCell(rowIndex, columnIndex, cell);
    }

    public void addCell(int rowIndex, int columnIndex, GridLayoutCell cell) {
        this.updateArraySize(rowIndex, columnIndex);
        this.cells[rowIndex][columnIndex] = cell;
    }

    public void setCellSpacing(int cellSpacing) {
        this.cellSpacing = cellSpacing;
    }

    public int getCellSpacing() {
        return this.cellSpacing;
    }

    public void setCellPadding(int cellPadding) {
        this.cellPadding = cellPadding;
    }

    public int getCellPadding() {
        return this.cellPadding;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getWidth() {
        return this.width;
    }

    public void setHeightPercentage(int height) {
        this.height = height;
    }

    public int getHeightPercentage() {
        return this.height;
    }

    public String getHeight() {
        if (this.height >= 0) {
            return Integer.toString(this.height) + "%";
        }
        return null;
    }

    public String getUI() {
        return UI_ID;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public boolean hasDebugMode() {
        return this.debugMode;
    }

    public GridLayoutCell getCell(int rowIndex, int columnIndex) {
        if (rowIndex < 1 || rowIndex > this.rowSize) {
            return null;
        }
        if (columnIndex < 1 || columnIndex > this.columnSize) {
            return null;
        }
        return (GridLayoutCell)this.cells[rowIndex][columnIndex];
    }

    public Object[][] getCells() {
        return this.cells;
    }

    public Iterator iterator() {
        return new GridLayoutIterator(this.cells);
    }

    private void updateArraySize(int rowSize, int columnSize) {
        if (this.cells == null) {
            this.cells = new Object[rowSize][columnSize];
        }
        if (rowSize > this.rowSize || columnSize > this.columnSize) {
            if (rowSize > this.rowSize) {
                this.rowSize = rowSize;
            }
            if (columnSize > this.columnSize) {
                this.columnSize = columnSize;
            }
            Object[][] newCells = new Object[this.rowSize + 1][this.columnSize + 1];
            int rowIndex = 0;
            while (rowIndex < this.cells.length) {
                Object[] row = this.cells[rowIndex];
                int columnIndex = 0;
                while (columnIndex < row.length) {
                    newCells[rowIndex][columnIndex] = this.cells[rowIndex][columnIndex];
                    ++columnIndex;
                }
                ++rowIndex;
            }
            this.cells = newCells;
        }
    }

    public boolean requiresForm() {
        return false;
    }

    public void setNN4Optimized(boolean NN4Optimized) {
        this.NN4Optimized = NN4Optimized;
    }

    public boolean isNN4Optimized() {
        return this.NN4Optimized;
    }

    public int getCurrentRowIndex() {
        return this.currentRowIndex;
    }

    public void setCurrentRowIndex(int currentRowIndex) {
        this.currentRowIndex = currentRowIndex;
    }

    public int getCurrentColumnIndex() {
        return this.currentColumnIndex;
    }

    public void setCurrentColumnIndex(int currentColumnIndex) {
        this.currentColumnIndex = currentColumnIndex;
    }

    public boolean isFixedLayout() {
        return this.fixedLayout;
    }

    public void setFixedLayout(boolean fixedLayout) {
        this.fixedLayout = fixedLayout;
    }
}

