/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.htmlb;

import com.sapportals.htmlb.Component;
import com.sapportals.htmlb.Container;
import com.sapportals.htmlb.FormLayoutCell;
import com.sapportals.htmlb.FormLayoutRow;
import com.sapportals.htmlb.util.Log;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class FormLayout
extends Container {
    public static final String UI_ID = "FormLayout";
    public static final int FORMLAYOUT_BEGIN = 0;
    public static final int FORMLAYOUT_ROW_BEGIN = 1;
    public static final int FORMLAYOUT_CELL_BEGIN = 2;
    public static final int FORMLAYOUT_CELL_CONTENT = 3;
    public static final int FORMLAYOUT_CELL_END = 4;
    public static final int FORMLAYOUT_ROW_END = 5;
    public static final int FORMLAYOUT_END = 6;
    private ArrayList rows = new ArrayList();
    private String marginTop = "5px";
    private String marginRight = "5px";
    private String marginBottom = "5px";
    private String marginLeft = "5px";
    private String width = "1";
    private boolean debugMode = false;
    private transient int currentRowIndex;
    private transient int currentColumnIndex;
    private int columnCount = 0;
    private int rowCount = 0;

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public FormLayoutRow addRow() {
        FormLayoutRow formLayoutRow = new FormLayoutRow();
        formLayoutRow.setParentFormLayout(this);
        formLayoutRow.setParent(this);
        this.rows.add(formLayoutRow);
        ++this.rowCount;
        return formLayoutRow;
    }

    public FormLayoutRow addRow(Component[] components) {
        FormLayoutRow formLayoutRow = this.addRow();
        int n = 0;
        while (n < components.length) {
            formLayoutRow.addCell().addComponent(components[n]);
            ++n;
        }
        return formLayoutRow;
    }

    public FormLayoutCell addComponent(int row, int cell, Component component) {
        FormLayoutRow layoutRow = null;
        FormLayoutCell layoutCell = null;
        int rows = this.getRowCount();
        if (row > rows) {
            int i = rows + 1;
            while (i <= row) {
                layoutRow = this.addRow();
                ++i;
            }
        } else {
            layoutRow = this.getRow(row);
        }
        int cells = layoutRow.getCellCount();
        if (cell > cells) {
            int i = cells + 1;
            while (i <= cell) {
                layoutCell = layoutRow.addCell();
                ++i;
            }
        } else {
            layoutCell = layoutRow.getCell(cell);
        }
        layoutCell.addComponent(component);
        return layoutCell;
    }

    public String getMarginTop() {
        return this.marginTop;
    }

    public String getMarginRight() {
        return this.marginRight;
    }

    public String getMarginBottom() {
        return this.marginBottom;
    }

    public String getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginTop(String marginTop) {
        this.marginTop = marginTop;
    }

    public void setMarginRight(String marginRight) {
        this.marginRight = marginRight;
    }

    public void setMarginBottom(String marginBottom) {
        this.marginBottom = marginBottom;
    }

    public void setMarginLeft(String marginLeft) {
        this.marginLeft = marginLeft;
    }

    public void setMargin(String marginTop, String marginRight, String marginBottom, String marginLeft) {
        this.marginTop = marginTop;
        this.marginRight = marginRight;
        this.marginBottom = marginBottom;
        this.marginLeft = marginLeft;
    }

    public Object[] getRows() {
        return this.rows.toArray();
    }

    public FormLayoutRow getRow(int index) {
        try {
            return (FormLayoutRow)this.rows.get(index - 1);
        }
        catch (IndexOutOfBoundsException i) {
            Log.getLogLocation(false).debugT(UI_ID, "getRow");
            return null;
        }
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public String getUI() {
        return UI_ID;
    }

    public boolean requiresForm() {
        return false;
    }

    public Iterator iterator() {
        return ((AbstractList)this.rows).iterator();
    }

    public int getChildCount() {
        return this.rows.size();
    }

    public int getCurrentRowIndex() {
        return this.currentRowIndex;
    }

    public void setCurrentRowIndex(int currentRowIndex) {
        this.currentRowIndex = currentRowIndex;
    }

    public int getCurrentColumnIndex() {
        return this.currentColumnIndex;
    }

    public void setCurrentColumnIndex(int currentColumnIndex) {
        this.currentColumnIndex = currentColumnIndex;
    }
}

